<?php
error_reporting(E_ALL);

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>XML Data</title>
<style>
	body {
		font-family: Arial, Helvetica, sans-serif;
		font-size:12px;
	}
	table {
		border: solid thin #666;
	    border-spacing: 0;
    	border-collapse: collapse;
	}
	th {
		background-color:#999;
		font-weight:bold;
	}
	td {
		padding:2px; 
	}
</style>
</head>
<body>
<?php
$xmlfile = "uk.xml";

$xmlfile = file_get_contents($xmlfile);
$ob= simplexml_load_string($xmlfile);


echo "<table border=1>";
echo "	<tr>";
echo "		<th>Channel ID</th>";
echo "		<th>Channel Name</th>";
echo "		<th>Channel URL</th>";
echo "		<th>Channel Language</th>";
echo "		<th>Program Title</th>";
echo "		<th>Description</th>";
echo "		<th>Category</th>";
echo "		<th>Episode</th>";
echo "		<th>Start Time</th>";
echo "		<th>Stop Time</th>";
echo "		<th>Credits - Director</th>";
echo "		<th>Credits - Producer</th>";
echo "		<th>Credits - Actor</th>";
echo "		<th>Credits - Writer</th>";
echo "		<th>Icon</th>";
echo "	</tr>";

foreach ($ob->programme as $programme)
{

	$stdate = date("d-m-Y H:i:s",strtotime(substr($programme['start'],0,14)));
	$eddate = date("d-m-Y H:i:s",strtotime(substr($programme['stop'],0,14)));

	echo "	<tr>";
	$chnl = get_channel_name($ob,trim($programme['channel']));
	print_element($programme['channel']);
	print_element($chnl->{'display-name'}[0]);
	print_element($chnl->url[0]);
	print_element($chnl->{'display-name'}["lang"]);
	print_element($programme->title);
	print_element($programme->desc);
	print_element($programme->category);
	print_element($programme->{'episode-num'});
	echo "		<td nowrap valign='top'>".$stdate."</td>";
	echo "		<td nowrap valign='top'>".$eddate."</td>";
	print_element($programme->credits->director);
	print_element($programme->credits->producer);
	print_element($programme->credits->actor);
	print_element($programme->credits->writer);

	echo "		<td valign='top'>";
	echo '<img src="'. $programme->icon['src'] .'" width="50">';
	echo "		</td>";
	
	echo "	</tr>";

}
echo "</table>";

function print_element($obj) {
	if(isset($obj)) {
		echo "		<td valign='top'>";
		if(isset($obj)) {
			if(count($obj)>0) {
				$o_str = "";
				foreach($obj as $oj) {
					if(strlen($o_str) >0) $o_str .= ", ";
					$o_str .= $oj;
				}
				echo $o_str;
			}
			else {
				echo $obj;
			}
		}
		else {
			echo  "&nbsp;";
		}
		echo "		</td>";
	}
	else {
		echo "		<td>&nbsp;</td>";
	}
}


function get_channel_name($ob,$id)  {
	$ch=array();
	foreach ($ob->channel as $channel) {
		if($channel["id"] == $id) {
			$ch = $channel;
			break;
		}
	}
	return $ch;
}

?>
 </BODY>
</HTML>

