<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product;

// Ensure visibility
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>
<div <?php post_class( 'product-item-grid' ); ?>>
	<div class="pro-item">
		<div class="pro-image cd-item" id="prdct1">

			<?php
			/**
			 * woocommerce_before_shop_loop_item hook.
			 *
			 * @hooked woocommerce_template_loop_product_link_open - 10
			 */
			do_action( 'woocommerce_before_shop_loop_item' );

			/**
			 * woocommerce_before_shop_loop_item_title hook.
			 *
			 * @hooked woocommerce_show_product_loop_sale_flash - 10
			 * @hooked woocommerce_template_loop_product_thumbnail - 10
			 */
			do_action( 'woocommerce_before_shop_loop_item_title' );
			?>

			<div class="pro-overlay"></div>

			<a href="<?php the_permalink(); ?>" class="icon"><span class="fa fa-link"></span></a>
			<?php
			/**
			 * woocommerce_after_shop_loop_item hook.
			 *
			 * @hooked woocommerce_template_loop_product_link_close - 5
			 * @hooked woocommerce_template_loop_add_to_cart - 10
			 */
			do_action( 'woocommerce_after_shop_loop_item' );
			?>
			<a href="#" class="cd-trigger icon hidden-xs hidden-sm product-search"><span class="flaticon-search"></span></a>
            <a href="<?php the_permalink(); ?>" class="visible-xs visible-sm icon"><span class="flaticon-search"></span></a>
            <div class="quick-view-content">
              <div class="quick-view-content-wrapper">
                <div class="cd-slider-wrapper">
                  <ul class="cd-slider">
                      <li class="selected"><?php the_post_thumbnail(); ?></li>
                  </ul> <!-- cd-slider -->
                </div> <!-- cd-slider-wrapper -->
    
                <div class="cd-item-info">
                  <?php echo woocommerce_template_loop_product_title(); ?>
                  <h4 class="pro-price"><?php echo woocommerce_template_loop_price(); ?></h4>
                  <?php echo woocommerce_template_loop_rating(); ?>
                  <?php echo woocommerce_template_single_excerpt(); ?>
                  <ul class="cd-item-action pro-button">
                    <li><?php echo woocommerce_template_loop_add_to_cart(); ?></li>         
                    <li><a href="<?php esc_url( the_permalink() ); ?>"><?php _e( 'Read more', 'big-event' ); ?></a></li>  
                  </ul> <!-- cd-item-action -->
                </div> <!-- cd-item-info -->
              </div>
            </div>
		</div>

		<div class="pro-content">
		
			<?php
			/**
			 * woocommerce_shop_loop_item_title hook.
			 *
			 * @hooked woocommerce_template_loop_product_title - 10
			 */
			do_action( 'woocommerce_shop_loop_item_title' );


			/**
			 * woocommerce_after_shop_loop_item_title hook.
			 *
			 * @hooked woocommerce_template_loop_rating - 5
			 * @hooked woocommerce_template_loop_price - 10
			 */
			do_action( 'woocommerce_after_shop_loop_item_title' );
			?>

			<?php echo woocommerce_template_single_excerpt(); ?>
			<ul class="pro-button">
                <li class="add-to-cart-btn"><?php echo woocommerce_template_loop_add_to_cart(); ?></li>
              <li><a href="<?php esc_url( the_permalink() ); ?>"><?php _e( 'Read more', 'big-event' ); ?></a></li>  
            </ul>
		</div>

	</div>
</div>
