<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

?>


<div id="post-<?php the_ID(); ?>" <?php post_class( 'blog-item' ); ?>>
  <?php
  if( has_post_thumbnail() ) : ?>

  <div class="image">
    <a href="<?php echo get_permalink(); ?>">
    	<?php the_post_thumbnail( 'big-event-blog-image', array( 'class' => 'img-responsive' ) ); ?>
    </a>
  </div><!-- image -->

  <?php
  endif; ?>

  <div class="blog-content">
    <div class="<?php echo ( ! has_post_thumbnail() ) ? 'empty-image' : ''; ?>">
		<?php big_event_posted_on();

		if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			echo '<li class="comments-link"><span class="icon flaticon-chat"></span>';
			comments_popup_link(
				sprintf(
					wp_kses(
						/* translators: %s: post title */
						__( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'big-event' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					get_the_title()
				)
			);
			echo '</li>';
		}
		?>

		</ul> <!-- This ul start from template-tags.php line no #39 -->
      <div class="content">
		<?php
		if ( is_singular() ) :
			the_title( '<h4 class="entry-title">', '</h4>' );
		else :
			the_title( '<h4 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' );
		endif; ?>
		<?php
			if( is_single() ) :
				the_content( sprintf(
					/* translators: %s: Name of current post. */
					wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'big-event' ), array( 'span' => array( 'class' => array() ) ) ),
					the_title( '<span class="screen-reader-text">"', '"</span>', false )
				) );

				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'big-event' ),
					'after'  => '</div>',
				) );
			else :

			the_excerpt( sprintf(
				/* translators: %s: Name of current post. */
				wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'big-event' ), array( 'span' => array( 'class' => array() ) ) ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			) ); ?>

			<?php echo '<a href="' . esc_url( get_permalink() ) . '" class="default-button">' . esc_html__( 'Read More', 'big-event' ) . '</a>'; ?>
				
			<?php endif;
 		
		?>
      </div><!-- content -->
    </div>
  </div><!-- blog-content -->
</div><!-- blog item -->
