<?php
/**
 * Template part for displaying speaker details post
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
$be_speakers_designation	= '';
$be_speakers_social_info	= array();
$be_speakers_contact_info	= array();

if( function_exists( 'cs_get_option' ) ) :

	$be_speakers_post_options = get_post_meta( get_the_ID(), '_be_speakers_post_options', true );
	$be_speakers_designation  = isset( $be_speakers_post_options['be_speakers_designation'] ) ? $be_speakers_post_options['be_speakers_designation'] : '';
	$be_speakers_social_info  = isset( $be_speakers_post_options['be_speakers_social_info'] ) ? $be_speakers_post_options['be_speakers_social_info'] : '';
	$be_speakers_contact_info = isset( $be_speakers_post_options['be_speakers_contact_info'] ) ? $be_speakers_post_options['be_speakers_contact_info'] : '';

endif;
?>

  <div class="col-md-6 col-sm-12 col-xs-12">
    <?php
    if( has_post_thumbnail() ) : ?>

    	<div class="speaker-image">

      		<?php the_post_thumbnail( 'big-event-speaker-three-image', array( 'class' => 'img-responsive' ) ); ?>

    	</div>

    <?php endif; ?>
  </div>
  <div class="col-md-6 col-sm-12 col-xs-12">
    <div class="speaker-content">

      <?php
      the_title( '<h4>', '</h4>' ); ?>

      <?php
      if( ! empty( $be_speakers_designation ) ) :

        echo '<span>' . esc_html( $be_speakers_designation ) . '</span>';

      endif; ?>

      <?php the_content(); ?>

		<?php
		if( ! empty( $be_speakers_social_info ) ) : ?>

	      <ul class="speaker-social">

	      	<?php
	      	foreach( $be_speakers_social_info as $be_speakers_single_social_info ) :

	        	echo '<li><a href="' . esc_url( $be_speakers_single_social_info['be_speakers_social_info_url'] ) . '"><i class="' . esc_attr( $be_speakers_single_social_info['be_speakers_social_info_icon'] ) . '" aria-hidden="true"></i></a></li>';

	        endforeach; ?>
	      </ul>

		<?php endif; ?>

      <?php
      if( ! empty( $be_speakers_contact_info ) ) : ?>
	      <ul class="speaker-address">

	      	<?php
	      	foreach( $be_speakers_contact_info as $be_single_contact_info ) :

	        	echo '<li><span><i class="' . $be_single_contact_info['be_speakers_contact_info_icon'] . '" aria-hidden="true"></i></span>' . $be_single_contact_info['be_speakers_contact_info_text'] . '</li>';

	    	endforeach; ?>
	      </ul>
  	  <?php endif; ?>
    </div>
  </div>
