<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

?>

<div class="blog-item">
  <div class="blog-content">
    <div class="<?php echo ( ! has_post_thumbnail() ) ? 'empty-image' : ''; ?>">
		<?php big_event_posted_on();

		if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			echo '<li class="comments-link"><span class="icon flaticon-chat"></span>';
			comments_popup_link(
				sprintf(
					wp_kses(
						/* translators: %s: post title */
						__( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'big-event' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					get_the_title()
				)
			);
			echo '</li>';
		}
		?>

		</ul> <!-- This ul start from template-tags.php line no #39 -->
      <div class="content">
		<?php
		if ( is_singular() ) :
			the_title( '<h4 class="entry-title">', '</h4>' );
		else :
			the_title( '<h4 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' );
		endif; ?>
		<?php the_excerpt(); ?>
		<?php echo '<a href="' . esc_url( get_permalink() ) . '" class="default-button">' . esc_html( 'Read More', 'big-event' ) . '</a>'; ?>
      </div><!-- content -->
    </div>
  </div><!-- blog-content -->
</div><!-- blog item -->

