<?php
/**
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
$be_is_page_coundown = $be_coundown_date = $be_coundown_month = $be_coundown_year = $be_coundown_subtitle = $be_coundown_title = $be_coundown_time = $be_time_offset = $be_coundown_booking_text = $be_coundown_booking_url = $be_page_header_bg = '';
$be_is_page_header = 1;


if( function_exists( 'cs_get_option' ) ):
    $be_custom_header_counter = '';
    if( is_page() ) :
        $page_options = get_post_meta( get_the_ID(), '_be_custom_page_options', true );
        $be_custom_header_counter  = isset( $page_options['be_custom_header_counter'] ) ? $page_options['be_custom_header_counter'] : '';
    elseif (is_singular('event')):
        $page_options = get_post_meta( get_the_ID(), '_be_event_options', true );
        $be_custom_header_counter          = isset( $page_options['be_custom_header_counter'] ) ? $page_options['be_custom_header_counter'] : '';
    endif;
    if( $be_custom_header_counter == true ) :
        $be_is_page_header          = isset( $page_options['be_is_page_header'] ) ? $page_options['be_is_page_header'] : '';
        $be_page_header_bg          = isset( $page_options['be_page_header_bg'] ) ? $page_options['be_page_header_bg'] : '';
        $be_is_page_coundown        = isset( $page_options['be_is_page_coundown'] ) ? $page_options['be_is_page_coundown'] : '';
        $be_coundown_date           = isset( $page_options['be_coundown_date'] ) ? $page_options['be_coundown_date'] : '';
        $be_coundown_month          = isset( $page_options['be_coundown_month'] ) ? $page_options['be_coundown_month'] : '';
        $be_coundown_year           = isset( $page_options['be_coundown_year'] ) ? $page_options['be_coundown_year'] : '';
        $be_coundown_subtitle       = isset( $page_options['be_coundown_subtitle'] ) ? $page_options['be_coundown_subtitle'] : '';
        $be_coundown_title          = isset( $page_options['be_coundown_title'] ) ? $page_options['be_coundown_title'] : '';
        $be_coundown_time           = isset( $page_options['be_coundown_time'] ) ? $page_options['be_coundown_time'] : '-5';        
        $be_time_offset             = isset( $page_options['be_time_offset'] ) ? $page_options['be_time_offset'] : '';        
        $be_coundown_booking_text   = isset( $page_options['be_coundown_booking_text'] ) ? $page_options['be_coundown_booking_text'] : '';
        $be_coundown_booking_url    = isset( $page_options['be_coundown_booking_url'] ) ? $page_options['be_coundown_booking_url'] : '';
    else :
        $be_is_page_header          = cs_get_option( 'be_is_page_header' );
        $be_page_header_bg          = cs_get_option( 'be_page_header_bg' );
        $be_is_page_coundown        = cs_get_option( 'be_is_page_coundown' );
        $be_coundown_date           = cs_get_option( 'be_coundown_date' );
        $be_coundown_month          = cs_get_option( 'be_coundown_month' );
        $be_coundown_year           = cs_get_option( 'be_coundown_year' );
        $be_coundown_subtitle       = cs_get_option( 'be_coundown_subtitle' );
        $be_coundown_title          = cs_get_option( 'be_coundown_title' );
        $be_coundown_time           = cs_get_option( 'be_coundown_time' );         
        $be_time_offset             = cs_get_option( 'be_time_offset' );         
        $be_coundown_booking_text   = cs_get_option( 'be_coundown_booking_text' );
        $be_coundown_booking_url    = cs_get_option( 'be_coundown_booking_url' );
    endif;
endif;
?>

<?php if( ! is_front_page() && $be_is_page_header == true && $be_is_page_coundown == true && ! is_404() ) : ?>
<!-- banner start here-->
<section class="banner banner-page-header banner-five" style="background-image: url( <?php echo esc_url( $be_page_header_bg ); ?>">
  <div class="banner-overlay"></div><!-- overlay -->
  <div class="content-left">
    <span class="counter" data-count="<?php echo esc_attr( $be_coundown_date ); ?>"><?php _e( '0', 'big-event' ); ?></span>
    <p><?php echo esc_html( $be_coundown_month ) ?> <?php echo esc_html( $be_coundown_year ) ?></p>
  </div><!-- content-left -->
  <div class="content-right">
    <div class="content">
        <?php
        if( ! empty( $be_coundown_subtitle ) ) :

            echo '<p>' . esc_html( $be_coundown_subtitle ) . '</p>';

        endif; ?>
      
        <?php
        if( ! empty( $be_coundown_title ) ) :

            echo '<h2>' . esc_html( $be_coundown_title ) . '</h2>';

        endif; ?>
      
      <ul id="page-countdown" class="page-countdown countdown" data-coundowntime="<?php echo esc_attr( $be_coundown_time ); ?>" data-day="<?php esc_html_e('Day','big-event'); ?>" data-days="<?php esc_html_e('Days','big-event'); ?>" data-hour="<?php esc_html_e('Hour','big-event'); ?>" data-hours="<?php esc_html_e('Hours','big-event'); ?>" data-minute="<?php esc_html_e('Minute','big-event'); ?>" data-minutes="<?php esc_html_e('Minutes','big-event'); ?>" data-second="<?php esc_html_e('Second','big-event'); ?>" data-seconds="<?php esc_html_e('Seconds','big-event'); ?>" data-timeoffset="<?php echo esc_attr($be_time_offset) ?>">
        <li class="clock-item"><span class="count-number days"><?php esc_html_e('00','big-event') ?></span>
            <p class="days_text count-text"><?php esc_html_e('Days','big-event'); ?></p>
        </li>
        <li class="clock-item"><span class="count-number hours"><?php esc_html_e('00','big-event') ?></span>
            <p class="hours_text count-text"><?php esc_html_e('Hours','big-event'); ?></p>
        </li>
        <li class="clock-item"><span class="count-number minutes"><?php esc_html_e('00','big-event') ?></span>
            <p class="minutes_text count-text"><?php esc_html_e('Minutes','big-event'); ?></p>
        </li>
        <li class="clock-item"><span class="count-number seconds"><?php esc_html_e('00','big-event') ?></span>
            <p class="seconds_text count-text"><?php esc_html_e('Seconds','big-event'); ?></p>
        </li>
      </ul>
      <?php
      if( ! empty( $be_coundown_booking_text ) && ! empty( $be_coundown_booking_url ) ) :

        echo '<a href="' . esc_url( $be_coundown_booking_url ) . '" class="banner-button default-button">' . esc_html( $be_coundown_booking_text ) . '</a>';

      endif; ?>
      
    </div>
  </div><!-- content-right -->
</section>
<!-- banner end here -->
<?php endif; ?>


<?php if( ! is_front_page() && $be_is_page_header == true && ! is_404() ) : ?>
<!-- page-header start here -->
<div class="page-header <?php echo ( empty(  $be_page_header_bg ) ) ? 'no-background' : ''; ?><?php echo ( $be_is_page_coundown == false ) ? ' default-page-header' : ''; ?>" <?php echo ( $be_is_page_coundown == false ) ? 'style="background-image: url(' . esc_url( $be_page_header_bg ) . ')"' : ''; ?>>

  <div class="container">
    <div class="row">
        <div class="content">
          <?php if( ! is_single() ) : ?>
            <h4>
              <?php
              if( is_archive() ) {
                the_archive_title();
              } elseif( is_home() ) {
                wp_title( '' );
              } elseif( is_search() ) {
              printf( esc_html__( 'Search Result for: %s', 'big-event' ), '<span>' . get_search_query() . '</span>' );
              } else {
                the_title();
              } ?>
            </h4>
            <?php endif; ?>
            <?php big_event_breadcrumbs(); ?>
        </div>
    </div>
  </div><!-- container -->
</div><!-- page header -->
<!-- page-header end here -->
<?php endif; ?>