<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package big-event
 * @author CodexCoder
 * @since 2.1.0
 * @version 1.0.0
 */
$be_site_logo = $page_settings = $be_banner_style = $be_is_page_header = $be_is_menu_cart = $be_is_buy_button = $be_buy_button_text = $be_buy_button_url = $be_transparent_menu = '';

if( function_exists( 'cs_get_option' ) ) :
    $page_options     = get_post_meta( get_the_ID(), '_be_custom_page_options', true );
    $page_settings    = isset( $page_options['be_custom_page_settings'] ) ? $page_options['be_custom_page_settings'] : '';
    
    if($page_settings == 1):
        $be_site_logo  = isset( $page_options['be_site_logo'] ) ? $page_options['be_site_logo'] : cs_get_option( 'be_site_logo' );
    else:
        $be_site_logo               = cs_get_option( 'be_site_logo' );
    endif;
            
    $be_is_menu_cart            = cs_get_option( 'be_is_menu_cart' );
    $be_is_buy_button           = cs_get_option( 'be_is_buy_button' );
    $be_buy_button_text         = cs_get_option( 'be_buy_button_text' );
    $be_buy_button_url          = cs_get_option( 'be_buy_button_url' );
    $be_h3_contact_text          = cs_get_option( 'be_h3_contact_text' );
    $logo_url                   = wp_get_attachment_url( $be_site_logo );
    $logo_alt                   = get_post_meta( $be_site_logo, '_wp_attachment_image_alt', true);
endif;
?>
<header class="header-style-9 header-no-margin">
    <div class="header-top">
        <div class="container">
            <div class="header-top-left">
                <?php 
                if(!empty($be_h3_contact_text)):
                    echo '<p>'. wp_kses_post($be_h3_contact_text).'</p>';
                endif;
                ?>
            </div>
            <div class="header-top-right">
            <?php
                if( $be_is_buy_button == TRUE && ! empty( $be_buy_button_text ) && ! empty( $be_buy_button_url ) ) :

                  echo '<a href="' . esc_url( $be_buy_button_url ) . '">' . wp_kses_post( $be_buy_button_text ) . '</a></li>';

                endif;
            ?>
            </div>
        </div>
    </div>
    <nav class="main-menu">
        <div class="container">
            <div class="menuV9">
                <!-- Brand and toggle get grouped for better mobile display -->
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-expanded="false">
                        <span class="sr-only"><?php esc_html('Toggle navigation','big-event')?></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                    <?php
                        if( ! empty( $be_site_logo ) ) :

                            echo '<a class="navbar-brand" href="' . esc_url( home_url( '/' ) ) . '"><img src="' . esc_url( $logo_url ) . '" alt="' . esc_attr( $logo_alt ) . '" class="img-responsive"></a>';
                        else : 
                            echo '<h3><a href="'.esc_url( home_url() ).'">'.bloginfo( 'name' ).'</a></h3>';

                        endif; 
                    ?>
                </div>

                <!-- Collect the nav links, forms, and other content for toggling -->
                <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
                    <div class="row">
                        <?php if( $be_is_menu_cart == TRUE) : ?>
                        <ul class="header-cart-ticket-option pull-right">
                            <?php if( class_exists( 'WooCommerce' ) && $be_is_menu_cart == TRUE ) : ?>
                              <li class="menu_cart dropdown">
                                <?php big_event_wc_cart_dropdown(); ?>
                              </li>
                            <?php endif; ?>                            
                        </ul>
                        <?php
                        endif;
                            if( has_nav_menu( 'primary' ) ) :
                                wp_nav_menu( array(
                                    'menu_class'        => 'nav navbar-nav navbar-right',
                                    'container'         => false,
                                    'walker'            => new Big_Event_Bootstrap_Nav_Walker(),
                                    'theme_location'    => 'primary'
                                ) );
                            endif; 
                        ?>                        
                    </div>
                </div><!-- /.navbar-collapse -->
            </div>
        </div><!-- /.container -->
    </nav>
</header>