<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
$be_one_page_logo           = '';
$be_is_buy_button           = '';
$be_buy_button_text         = '';
$be_buy_button_url          = '';

if( function_exists( 'cs_get_option' ) ) :
    $page_options     = get_post_meta( get_the_ID(), '_be_custom_page_options', true );
    $page_settings    = isset( $page_options['be_custom_page_settings'] ) ? $page_options['be_custom_page_settings'] : '';
    if( is_page() && $page_settings == true ) :
        $be_transparent_menu    = isset( $page_options['be_transparent_menu'] ) ? $page_options['be_transparent_menu'] : '';
        $be_site_logo  = isset( $page_options['be_site_logo'] ) ? $page_options['be_site_logo'] : cs_get_option( 'be_site_logo' );
    else :
        $be_transparent_menu    = cs_get_option( 'be_transparent_menu' );
        $be_site_logo               = cs_get_option( 'be_site_logo' );
    endif;

    $be_one_page_logo           = cs_get_option( 'be_one_page_logo' );
    $be_is_buy_button           = cs_get_option( 'be_is_buy_button' );
    $be_buy_button_text         = cs_get_option( 'be_buy_button_text' );
    $be_buy_button_url          = cs_get_option( 'be_buy_button_url' );
    $logo_url                   = wp_get_attachment_url( $be_one_page_logo );
    $logo_alt                   = get_post_meta( $be_one_page_logo, '_wp_attachment_image_alt', true);

endif;
?>

<header class="<?php echo ( $be_transparent_menu == 'true' ) ? 'header-no-margin header-transparent' : ''; ?>">
  <nav class="main-menu menu-fixed <?php echo ( $be_transparent_menu == 'true' ) ? 'transparent-menu' : ''; ?>">
    <div class="container">
      <!-- Brand and toggle get grouped for better mobile display -->
      <div class="navbar-header">
        <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-expanded="false">
          <span class="sr-only"><?php esc_html('Toggle navigation','big-event')?></span>
          <span class="icon-bar"></span>
          <span class="icon-bar"></span>
          <span class="icon-bar"></span>
        </button>
          <?php
          if( ! empty( $be_one_page_logo ) ) :

              echo '<a class="navbar-brand" href="' . esc_url( home_url( '/' ) ) . '"><img src="' . esc_url( $logo_url ) . '" alt="' . esc_attr( $logo_alt ) . '" class="img-responsive"></a>';

          else : ?>

              <h3><a href="<?php echo esc_url( home_url() ); ?>"><?php echo bloginfo( 'name' ); ?></a></h3>

          <?php
          endif; ?>
      </div>

      <!-- Collect the nav links, forms, and other content for toggling -->
      <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
        <ul class="miti pull-right">

          <?php
          if( $be_is_buy_button == TRUE ) :

            echo '<li><a href="' . esc_url( $be_buy_button_url ) . '" class="menu-button">' . esc_html( $be_buy_button_text ) . '</a></li>';

          endif; ?>

        </ul>
        <?php
        if( has_nav_menu( 'one-page' ) ) :
            wp_nav_menu( array(
                'menu_class'        => 'nav navbar-nav navbar-right',
                'container'         => false,
                'walker'            => new Big_Event_One_Page_Nav_Walker(),
                'theme_location'    => 'one-page',
                'depth'             => 1
            ) );
        endif; ?>
      </div><!-- /.navbar-collapse -->
    </div><!-- /.container -->
  </nav>
</header>