<?php
/**
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

$be_is_theme_event                        = '';
$be_banner_image                          = '';
$be_banner_subtitle                       = '';
$be_banner_title                          = '';
$be_banner_month                          = '';
$be_banner_location                       = '';
$be_banner_register_text                  = '';
$be_banner_registration_shortcode         = '';
$be_banner_date_duration                  = '';
$be_banner_year                           = '';
$be_banner_coundown_time                  = '';

if( function_exists( 'cs_get_option' ) ) :
    $be_custom_page_options               = get_post_meta( get_the_ID(), '_be_custom_page_options', true );
    $be_is_theme_event                    = isset( $be_custom_page_options['be_is_theme_event'] ) ? $be_custom_page_options['be_is_theme_event'] : '';

    if( is_page() && $be_is_theme_event == true ) :
        $be_banner_image                  = isset( $be_custom_page_options['be_banner_image'] ) ? $be_custom_page_options['be_banner_image'] : '';
        $be_banner_subtitle               = isset( $be_custom_page_options['be_banner_subtitle'] ) ? $be_custom_page_options['be_banner_subtitle'] : '';
        $be_banner_title                  = isset( $be_custom_page_options['be_banner_title'] ) ? $be_custom_page_options['be_banner_title'] : '';
        $be_banner_month                  = isset( $be_custom_page_options['be_banner_month'] ) ? $be_custom_page_options['be_banner_month'] : '';
        $be_banner_year                   = isset( $be_custom_page_options['be_banner_year'] ) ? $be_custom_page_options['be_banner_year'] : '';
        $be_banner_date_duration          = isset( $be_custom_page_options['be_banner_date_duration'] ) ? $be_custom_page_options['be_banner_date_duration'] : '';
        $be_banner_location               = isset( $be_custom_page_options['be_banner_location'] ) ? $be_custom_page_options['be_banner_location'] : '';
        $be_banner_register_text          = isset( $be_custom_page_options['be_banner_register_text'] ) ? $be_custom_page_options['be_banner_register_text'] : '';
        $be_banner_registration_shortcode = isset( $be_custom_page_options['be_banner_registration_shortcode'] ) ? $be_custom_page_options['be_banner_registration_shortcode'] : '';
        $be_banner_coundown_time          = isset( $be_custom_page_options['be_banner_coundown_time'] ) ? $be_custom_page_options['be_banner_coundown_time'] : '';
    else :
        $be_banner_image                  = cs_get_option( 'be_banner_image' );
        $be_banner_title                  = cs_get_option( 'be_banner_title' );
        $be_banner_subtitle               = cs_get_option( 'be_banner_subtitle' );
        $be_banner_month                  = cs_get_option( 'be_banner_month' );
        $be_banner_year                   = cs_get_option( 'be_banner_year' );
        $be_banner_date_duration          = cs_get_option( 'be_banner_date_duration' );
        $be_banner_location               = cs_get_option( 'be_banner_location' );
        $be_banner_coundown_time          = cs_get_option( 'be_banner_coundown_time' );
    endif;
endif;

?>

<!-- banner start here-->
<section class="banner banner-three banner-registration" style="background-image: url( <?php echo esc_url( $be_banner_image ) ?> );">
  <div class="banner-overlay">
    <div class="container">
      <div class="banner-content">
        <div class="content">
        <?php
        if( ! empty( $be_banner_subtitle ) ) :

          echo '<p>' . esc_html( $be_banner_subtitle ) . '</p>';

        endif; ?>
        <?php
        if( ! empty( $be_banner_title ) ) :

          echo '<h2>' . esc_html( $be_banner_title ) . '</h2>';

        endif; ?>
        <?php
        if( ! empty( $be_banner_date_duration ) || ! empty( $be_banner_month ) || ! empty( $be_banner_year ) || ! empty( $be_banner_location ) ) : ?>
          <ul>
            <li><span class="flaticon-tool"></span><?php echo esc_html( $be_banner_date_duration ) ?> <?php echo esc_html( $be_banner_month ) ?>, <?php echo esc_html( $be_banner_year ) ?></li>

            <?php
            if( ! empty( $be_banner_location ) ) : ?>

              <li>
                <span class="flaticon-signs"></span>
                <?php echo esc_html( $be_banner_location ) ?>
              </li>

            <?php endif; ?>

          </ul>
        <?php endif; ?>
        </div><!-- content -->
        <div class="banner-form">
          <?php
          if( ! empty( $be_banner_register_text ) ) :

            echo '<h3>' . esc_html( $be_banner_register_text ) . '</h3>';

          endif; ?>
          
          <?php
          if( ! empty( $be_banner_registration_shortcode ) ) :

            echo do_shortcode( $be_banner_registration_shortcode );

          endif; ?>
        </div>
      </div><!-- banner content -->
    </div><!-- container -->
  </div><!-- overlay -->
</section>
<!-- banner end here -->