<?php
/**
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

$be_is_theme_event                  = '';
$be_banner_video                    = '';
$be_banner_embeded_video            = '';
$be_banner_slider                   = '';
$be_banner_title                    = '';
$be_banner_subtitle                 = '';
$be_banner_date                     = '';
$be_banner_month                    = '';
$be_banner_location                 = '';
$be_banner_date_duration            = '';
$be_banner_year                     = '';
$be_banner_coundown_time            = '';
$be_banner_days_text                = '';
$be_banner_hours_text               = '';
$be_banner_minutes_text             = '';
$be_banner_seconds_text             = '';
$be_banner_booking_now_text         = '';
$be_banner_booking_now_url          = '';

if( function_exists( 'cs_get_option' ) ) :
    $be_custom_page_options         = get_post_meta( get_the_ID(), '_be_custom_page_options', true );
    $be_is_theme_event              = isset( $be_custom_page_options['be_is_theme_event'] ) ? $be_custom_page_options['be_is_theme_event'] : '';

    if( is_page() && $be_is_theme_event == true ) :
        $be_banner_title         = isset( $be_custom_page_options['be_banner_title'] ) ? $be_custom_page_options['be_banner_title'] : '';
        $be_banner_subtitle         = isset( $be_custom_page_options['be_banner_subtitle'] ) ? $be_custom_page_options['be_banner_subtitle'] : '';
        $be_banner_video            = isset( $be_custom_page_options['be_banner_video'] ) ? $be_custom_page_options['be_banner_video'] : '';
        $be_banner_embeded_video    = isset( $be_custom_page_options['be_banner_embeded_video'] ) ? $be_custom_page_options['be_banner_embeded_video'] : '';
        $be_banner_slider           = isset( $be_custom_page_options['be_banner_slider'] ) ? $be_custom_page_options['be_banner_slider'] : '';
        $be_banner_date             = isset( $be_custom_page_options['be_banner_date'] ) ? $be_custom_page_options['be_banner_date'] : '';
        $be_banner_month            = isset( $be_custom_page_options['be_banner_month'] ) ? $be_custom_page_options['be_banner_month'] : '';
        $be_banner_year             = isset( $be_custom_page_options['be_banner_year'] ) ? $be_custom_page_options['be_banner_year'] : '';
        $be_banner_date_duration    = isset( $be_custom_page_options['be_banner_date_duration'] ) ? $be_custom_page_options['be_banner_date_duration'] : '';
        $be_banner_location         = isset( $be_custom_page_options['be_banner_location'] ) ? $be_custom_page_options['be_banner_location'] : '';
        $be_banner_coundown_time    = isset( $be_custom_page_options['be_banner_coundown_time'] ) ? $be_custom_page_options['be_banner_coundown_time'] : '';
        $be_banner_days_text        = isset( $be_custom_page_options['be_banner_days_text'] ) ? $be_custom_page_options['be_banner_days_text'] : '';
        $be_banner_hours_text       = isset( $be_custom_page_options['be_banner_hours_text'] ) ? $be_custom_page_options['be_banner_hours_text'] : '';
        $be_banner_minutes_text     = isset( $be_custom_page_options['be_banner_minutes_text'] ) ? $be_custom_page_options['be_banner_minutes_text'] : '';
        $be_banner_seconds_text     = isset( $be_custom_page_options['be_banner_seconds_text'] ) ? $be_custom_page_options['be_banner_seconds_text'] : '';
        $be_banner_booking_now_text = isset( $be_custom_page_options['be_banner_booking_now_text'] ) ? $be_custom_page_options['be_banner_booking_now_text'] : '';
        $be_banner_booking_now_url  = isset( $be_custom_page_options['be_banner_booking_now_url'] ) ? $be_custom_page_options['be_banner_booking_now_url'] : '';
    else :
        $be_banner_title         = cs_get_option( 'be_banner_title' );
        $be_banner_subtitle         = cs_get_option( 'be_banner_subtitle' );
        $be_banner_date             = cs_get_option( 'be_banner_date' );
        $be_banner_month            = cs_get_option( 'be_banner_month' );
        $be_banner_year             = cs_get_option( 'be_banner_year' );
        $be_banner_date_duration    = cs_get_option( 'be_banner_date_duration' );
        $be_banner_location         = cs_get_option( 'be_banner_location' );
        $be_banner_coundown_time    = cs_get_option( 'be_banner_coundown_time' );
        $be_banner_days_text        = cs_get_option( 'be_banner_days_text' );
        $be_banner_hours_text       = cs_get_option( 'be_banner_hours_text' );
        $be_banner_minutes_text     = cs_get_option( 'be_banner_minutes_text' );
        $be_banner_seconds_text     = cs_get_option( 'be_banner_seconds_text' );
        $be_banner_booking_now_text = cs_get_option( 'be_banner_booking_now_text' );
        $be_banner_booking_now_url  = cs_get_option( 'be_banner_booking_now_url' );
    endif;
endif;

?>

<!-- banner start here-->
<section class="banner banner3 banner-four banner-six banner-ten">
    <?php if (!empty($be_banner_embeded_video)): ?>    
    <div class="videoWrapper">
        <!-- Copy & Pasted from YouTube -->
        <iframe src="https://www.youtube.com/embed/<?php echo esc_html( $be_banner_embeded_video ); ?>?controls=0&showinfo=0&rel=0&autoplay=1&loop=1&mute=1&playlist=<?php echo esc_html( $be_banner_embeded_video ); ?>" frameborder="0" allowfullscreen></iframe>
    </div>
    <?php elseif (!empty($be_banner_video)): ?>
    <video id="videobg" src="<?php echo esc_url( $be_banner_video ); ?>" autoplay loop muted></video>
    <?php endif; ?>  
    <div class="banner-overlay">
        <div class="content-left">
            <div class="day-counter">
                <span class="counter" data-count="<?php echo esc_attr( $be_banner_date ); ?>"><?php _e( '0', 'big-event' ); ?></span>
                <span class="years"><?php echo esc_html( $be_banner_year ) ?></span>
            </div>
            <?php
            if( ! empty( $be_banner_title ) ) :
            echo '<h2>' . esc_html( $be_banner_title ) . '</h2>';
            endif; 

            if( ! empty( $be_banner_date_duration ) || ! empty( $be_banner_location ) ) : 
            ?>
            <ul>
                <li><i class="flaticon-tool"></i><?php echo esc_html( $be_banner_date_duration ) ?></li>
                <?php if( ! empty( $be_banner_location ) ) : ?>
                <li>
                  <i class="flaticon-signs"></i>
                  <?php echo esc_html( $be_banner_location ) ?>
                </li>
                <?php endif; ?>
            </ul>
            <?php endif; ?>
        </div>
        <!-- content-left -->
        <div class="content-right">
            <div class="content">
                <ul id="countdown" class="countdown" data-coundown="<?php echo esc_attr( $be_banner_coundown_time ); ?>">
                    <li class="clock-item">
                        <span class="count-number days">
                            <?php _e( '00', 'big-event' ); ?>
                        </span>
                        <?php
                        if( ! empty( $be_banner_days_text ) ) :

                            echo '<p class="days_text count-text">' . esc_html( $be_banner_days_text ) . '</p>';

                        endif; ?>
                    </li>

                    <li class="clock-item">
                        <span class="count-number hours">
                            <?php _e( '00', 'big-event' ); ?>
                        </span>
                        <?php
                        if( ! empty( $be_banner_hours_text ) ) :

                            echo '<p class="hours_text count-text">' . esc_html( $be_banner_hours_text ) . '</p>';

                        endif; ?>
                    </li>

                    <li class="clock-item">
                        <span class="count-number minutes">
                            <?php _e( '00', 'big-event' ); ?>
                        </span>
                        <?php
                        if( ! empty( $be_banner_minutes_text ) ) :

                            echo '<p class="minutes_text count-text">' . esc_html( $be_banner_minutes_text ) . '</p>';

                        endif; ?>
                    </li>

                    <li class="clock-item">
                        <span class="count-number seconds">
                            <?php _e( '00', 'big-event' ); ?>
                        </span>
                        <?php
                        if( ! empty( $be_banner_seconds_text ) ) :

                            echo '<p class="seconds_text count-text">' . esc_html( $be_banner_seconds_text ) . '</p>';

                        endif; ?>
                    </li>
                </ul>
                <?php
                if( ! empty( $be_banner_subtitle ) ) :
                    echo '<h2>' . esc_html( $be_banner_subtitle ) . '</h2>';
                endif; 
                ?>
            </div>
        </div>
      <!-- content-right -->      
    </div><!-- overlay -->
</section>
<!-- banner end here -->