<?php
/**
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

$be_is_theme_event                  = '';
$be_banner_video                    = '';
$be_banner_embeded_video            = '';
$be_banner_slider                   = '';
$be_banner_subtitle                 = '';
$be_banner_date                     = '';
$be_banner_month                    = '';
$be_banner_location                 = '';
$be_banner_date_duration            = '';
$be_banner_year                     = '';
$be_banner_coundown_time            = '';
$be_banner_days_text                = '';
$be_banner_hours_text               = '';
$be_banner_minutes_text             = '';
$be_banner_seconds_text             = '';
$be_banner_booking_now_text         = '';
$be_banner_booking_now_url          = '';
$be_banner_time_offset            = '';

if( function_exists( 'cs_get_option' ) ) :
    $be_custom_page_options         = get_post_meta( get_the_ID(), '_be_custom_page_options', true );
    $be_is_theme_event              = isset( $be_custom_page_options['be_is_theme_event'] ) ? $be_custom_page_options['be_is_theme_event'] : '';

    if( is_page() && $be_is_theme_event == true ) :
        $be_banner_video            = isset( $be_custom_page_options['be_banner_video'] ) ? $be_custom_page_options['be_banner_video'] : '';
        $be_banner_embeded_video    = isset( $be_custom_page_options['be_banner_embeded_video'] ) ? $be_custom_page_options['be_banner_embeded_video'] : '';
        $be_banner_subtitle         = isset( $be_custom_page_options['be_banner_subtitle'] ) ? $be_custom_page_options['be_banner_subtitle'] : '';
        $be_banner_slider           = isset( $be_custom_page_options['be_banner_slider'] ) ? $be_custom_page_options['be_banner_slider'] : '';
        $be_banner_date             = isset( $be_custom_page_options['be_banner_date'] ) ? $be_custom_page_options['be_banner_date'] : '';
        $be_banner_month            = isset( $be_custom_page_options['be_banner_month'] ) ? $be_custom_page_options['be_banner_month'] : '';
        $be_banner_year             = isset( $be_custom_page_options['be_banner_year'] ) ? $be_custom_page_options['be_banner_year'] : '';
        $be_banner_date_duration    = isset( $be_custom_page_options['be_banner_date_duration'] ) ? $be_custom_page_options['be_banner_date_duration'] : '';
        $be_banner_location         = isset( $be_custom_page_options['be_banner_location'] ) ? $be_custom_page_options['be_banner_location'] : '';
        $be_banner_coundown_time    = isset( $be_custom_page_options['be_banner_coundown_time'] ) ? $be_custom_page_options['be_banner_coundown_time'] : '';        
        $be_banner_booking_now_text = isset( $be_custom_page_options['be_banner_booking_now_text'] ) ? $be_custom_page_options['be_banner_booking_now_text'] : '';
        $be_banner_booking_now_url  = isset( $be_custom_page_options['be_banner_booking_now_url'] ) ? $be_custom_page_options['be_banner_booking_now_url'] : '';
        $be_banner_time_offset    = isset( $be_custom_page_options['be_banner_time_offset'] ) ? $be_custom_page_options['be_banner_time_offset'] : '-5';
    else :
        $be_banner_subtitle         = cs_get_option( 'be_banner_subtitle' );
        $be_banner_date             = cs_get_option( 'be_banner_date' );
        $be_banner_month            = cs_get_option( 'be_banner_month' );
        $be_banner_year             = cs_get_option( 'be_banner_year' );
        $be_banner_date_duration    = cs_get_option( 'be_banner_date_duration' );
        $be_banner_location         = cs_get_option( 'be_banner_location' );
        $be_banner_coundown_time    = cs_get_option( 'be_banner_coundown_time' );        
        $be_banner_booking_now_text = cs_get_option( 'be_banner_booking_now_text' );
        $be_banner_booking_now_url  = cs_get_option( 'be_banner_booking_now_url' );
        $be_banner_time_offset    = cs_get_option( 'be_banner_time_offset' );   
    endif;
endif;

?>

<!-- banner start here-->
<section class="banner banner3 banner-four banner-six">
    <?php if (!empty($be_banner_embeded_video)): ?>    
    <div class="videoWrapper">
        <!-- Copy & Pasted from YouTube -->
        <iframe src="https://www.youtube.com/embed/<?php echo esc_html( $be_banner_embeded_video ); ?>?controls=0&showinfo=0&rel=0&autoplay=1&loop=1&mute=1&playlist=<?php echo esc_html( $be_banner_embeded_video ); ?>" frameborder="0" allowfullscreen></iframe>
    </div>
    <?php elseif (!empty($be_banner_video)): ?>
    <video id="videobg" src="<?php echo esc_url( $be_banner_video ); ?>" autoplay loop muted></video>
    <?php endif; ?>       
    <div class="banner-overlay">
        <div class="banner-content">
            <div class="content-left">
                <span class="counter" data-count="<?php echo esc_attr( $be_banner_date ); ?>">
                    <?php _e( '0', 'big-event' ); ?>
                </span>
                <p><?php echo esc_html( $be_banner_month ) ?> <?php echo esc_html( $be_banner_year ) ?></p>
            </div><!-- content-left -->
            <div class="content-right">
                <div class="content">
                  <?php
                  if( ! empty( $be_banner_subtitle ) ) :

                      echo '<h2>' . esc_html( $be_banner_subtitle ) . '</h2>';

                  endif; ?>
                  <?php
                  if( ! empty( $be_banner_date_duration ) || ! empty( $be_banner_month ) || ! empty( $be_banner_year ) || ! empty( $be_banner_location ) ) : ?>
                    <ul>
                      <li><span class="flaticon-tool"></span><?php echo esc_html( $be_banner_date_duration ) ?> <?php echo esc_html( $be_banner_month ) ?>, <?php echo esc_html( $be_banner_year ) ?></li>

                      <?php
                      if( ! empty( $be_banner_location ) ) : ?>

                        <li>
                          <span class="flaticon-signs"></span>
                          <?php echo esc_html( $be_banner_location ) ?>
                        </li>

                      <?php endif; ?>

                    </ul>
                  <?php endif; ?>
                    <ul id="banner-countdown" class="banner-countdown countdown" data-coundown="<?php echo esc_attr( $be_banner_coundown_time ); ?>" data-day="<?php esc_html_e('Day','big-event'); ?>" data-days="<?php esc_html_e('Days','big-event'); ?>" data-hour="<?php esc_html_e('Hour','big-event'); ?>" data-hours="<?php esc_html_e('Hours','big-event'); ?>" data-minute="<?php esc_html_e('Minute','big-event'); ?>" data-minutes="<?php esc_html_e('Minutes','big-event'); ?>" data-second="<?php esc_html_e('Second','big-event'); ?>" data-seconds="<?php esc_html_e('Seconds','big-event'); ?>" data-timeoffset="<?php echo esc_attr($be_banner_time_offset) ?>">
                        <li class="clock-item"><span class="count-number days"><?php esc_html_e('00','big-event') ?></span>
                            <p class="days_text count-text"><?php esc_html_e('Days','big-event'); ?></p>
                        </li>
                        <li class="clock-item"><span class="count-number hours"><?php esc_html_e('00','big-event') ?></span>
                            <p class="hours_text count-text"><?php esc_html_e('Hours','big-event'); ?></p>
                        </li>
                        <li class="clock-item"><span class="count-number minutes"><?php esc_html_e('00','big-event') ?></span>
                            <p class="minutes_text count-text"><?php esc_html_e('Minutes','big-event'); ?></p>
                        </li>
                        <li class="clock-item"><span class="count-number seconds"><?php esc_html_e('00','big-event') ?></span>
                            <p class="seconds_text count-text"><?php esc_html_e('Seconds','big-event'); ?></p>
                        </li>
                    </ul>
                  <?php
                  if( ! empty( $be_banner_booking_now_text ) && ! empty( $be_banner_booking_now_url ) ) :
                    echo '<a href="' . esc_url( $be_banner_booking_now_url ) . '" class="banner-button default-button">' . esc_html( $be_banner_booking_now_text ) . '</a>';
                  endif; ?>
                </div>
            </div><!-- content-right -->
        </div><!-- banner-content -->
    </div><!-- overlay -->
</section>
<!-- banner end here -->