<?php
/**
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
$be_is_theme_event                  = '';
$be_banner_image                    = '';
$be_banner_subtitle                 = '';
$be_banner_date                     = '';
$be_banner_month                    = '';
$be_banner_location                 = '';
$be_banner_date_duration            = '';
$be_banner_year                     = '';
$be_banner_coundown_time            = '';
$be_banner_time_offset            = '';

if( function_exists( 'cs_get_option' ) ) :
    $be_custom_page_options         = get_post_meta( get_the_ID(), '_be_custom_page_options', true );
    $be_is_theme_event              = isset( $be_custom_page_options['be_is_theme_event'] ) ? $be_custom_page_options['be_is_theme_event'] : '';

    if( is_page() && $be_is_theme_event == true ) :
        $be_banner_image            = isset( $be_custom_page_options['be_banner_image'] ) ? $be_custom_page_options['be_banner_image'] : '';
        $be_banner_subtitle         = isset( $be_custom_page_options['be_banner_subtitle'] ) ? $be_custom_page_options['be_banner_subtitle'] : '';
        $be_banner_date             = isset( $be_custom_page_options['be_banner_date'] ) ? $be_custom_page_options['be_banner_date'] : '';
        $be_banner_month            = isset( $be_custom_page_options['be_banner_month'] ) ? $be_custom_page_options['be_banner_month'] : '';
        $be_banner_year             = isset( $be_custom_page_options['be_banner_year'] ) ? $be_custom_page_options['be_banner_year'] : '';
        $be_banner_date_duration    = isset( $be_custom_page_options['be_banner_date_duration'] ) ? $be_custom_page_options['be_banner_date_duration'] : '';
        $be_banner_location         = isset( $be_custom_page_options['be_banner_location'] ) ? $be_custom_page_options['be_banner_location'] : '';
        $be_banner_coundown_time    = isset( $be_custom_page_options['be_banner_coundown_time'] ) ? $be_custom_page_options['be_banner_coundown_time'] : '';
        $be_banner_time_offset    = isset( $be_custom_page_options['be_banner_time_offset'] ) ? $be_custom_page_options['be_banner_time_offset'] : '-5';
    else :
        $be_banner_image            = cs_get_option( 'be_banner_image' );
        $be_banner_subtitle         = cs_get_option( 'be_banner_subtitle' );
        $be_banner_date             = cs_get_option( 'be_banner_date' );
        $be_banner_month            = cs_get_option( 'be_banner_month' );
        $be_banner_year             = cs_get_option( 'be_banner_year' );
        $be_banner_date_duration    = cs_get_option( 'be_banner_date_duration' );
        $be_banner_location         = cs_get_option( 'be_banner_location' );
        $be_banner_coundown_time    = cs_get_option( 'be_banner_coundown_time' );
        $be_banner_time_offset    = cs_get_option( 'be_banner_time_offset' );
    endif;
endif;
?>

<!-- banner start here-->
<section class="banner banner-six" style="background-image: url( <?php echo esc_url( $be_banner_image ); ?> );">
  <div class="banner-overlay">
    <div class="container">
      <div class="banner-six-content">
        <div class="row">
          <div class="col-md-6">
            <div class="banner-six-left-bg">
              <div class="banner-six-left">
                <div class="content">
                    <span class="counter" data-count="<?php echo esc_attr( $be_banner_date ); ?>">
                        <?php echo esc_attr( $be_banner_date ); ?>
                    </span>
                    <p><?php echo esc_html( $be_banner_month ) ?> <?php echo esc_html( $be_banner_year ) ?></p>
                    <ul id="banner-countdown" class="countdown banner-countdown" data-coundown="<?php echo esc_attr( $be_banner_coundown_time ); ?>" data-day="<?php esc_html_e('Day','big-event'); ?>" data-days="<?php esc_html_e('Days','big-event'); ?>" data-hour="<?php esc_html_e('Hour','big-event'); ?>" data-hours="<?php esc_html_e('Hours','big-event'); ?>" data-minute="<?php esc_html_e('Minute','big-event'); ?>" data-minutes="<?php esc_html_e('Minutes','big-event'); ?>" data-second="<?php esc_html_e('Second','big-event'); ?>" data-seconds="<?php esc_html_e('Seconds','big-event'); ?>" data-timeoffset="<?php echo esc_attr($be_banner_time_offset) ?>">
                        <li class="clock-item"><span class="count-number days"><?php esc_html_e('00','big-event') ?></span>
                            <p class="days_text count-text"><?php esc_html_e('Days','big-event'); ?></p>
                        </li>
                        <li class="clock-item"><span class="count-number hours"><?php esc_html_e('00','big-event') ?></span>
                            <p class="hours_text count-text"><?php esc_html_e('Hours','big-event'); ?></p>
                        </li>
                        <li class="clock-item"><span class="count-number minutes"><?php esc_html_e('00','big-event') ?></span>
                            <p class="minutes_text count-text"><?php esc_html_e('Minutes','big-event'); ?></p>
                        </li>
                        <li class="clock-item"><span class="count-number seconds"><?php esc_html_e('00','big-event') ?></span>
                            <p class="seconds_text count-text"><?php esc_html_e('Seconds','big-event'); ?></p>
                        </li>
                    </ul>
                </div>
              </div><!-- content-left -->
            </div><!-- content-left bg -->
          </div>
          <div class="col-md-6 col-sm-12 col-xs-12">
            <div class="banner-six-right-bg">
                <div class="banner-six-right">
                  <?php
                  if( ! empty( $be_banner_subtitle ) ) :

                      echo '<h2>' . esc_html( $be_banner_subtitle ) . '</h2>';

                  endif; ?>

                  <?php
                  if( ! empty( $be_banner_date_duration ) || ! empty( $be_banner_month ) || ! empty( $be_banner_year ) || ! empty( $be_banner_location ) ) : ?>
                    <ul>
                      <li><span class="flaticon-tool"></span><?php echo esc_html( $be_banner_date_duration ) ?> <?php echo esc_html( $be_banner_month ) ?>, <?php echo esc_html( $be_banner_year ) ?></li>

                      <?php
                      if( ! empty( $be_banner_location ) ) : ?>

                        <li>
                          <span class="flaticon-signs"></span>
                          <?php echo esc_html( $be_banner_location ) ?>
                        </li>

                      <?php endif; ?>

                    </ul>
                  <?php endif; ?>
                </div><!-- content-right -->
            </div><!-- content-right bg -->
          </div>
        </div><!-- row -->
      </div><!-- banner-content -->
    </div><!-- container -->
  </div><!-- overlay -->
</section>
<!-- banner end here -->