<?php
/**
 *
 * @package big-event
 * @author CodexCoder
 * @since 2.1.0
 * @version 1.0.0
 */

$be_is_theme_event = $be_banner_image = $be_banner_title = $be_banner_subtitle = $be_banner_date = $be_banner_month = $be_banner_year = $be_banner_coundown_time = $be_banner_time_offset = '';

if( function_exists( 'cs_get_option' ) ) :
    $be_custom_page_options         = get_post_meta( get_the_ID(), '_be_custom_page_options', true );
    $be_is_theme_event              = isset( $be_custom_page_options['be_is_theme_event'] ) ? $be_custom_page_options['be_is_theme_event'] : '';

    if( is_page() && $be_is_theme_event == true ) :
        $be_banner_image            = isset( $be_custom_page_options['be_banner_image'] ) ? $be_custom_page_options['be_banner_image'] : '';
        $be_banner_title            = isset( $be_custom_page_options['be_banner_title'] ) ? $be_custom_page_options['be_banner_title'] : '';
        $be_banner_subtitle         = isset( $be_custom_page_options['be_banner_subtitle'] ) ? $be_custom_page_options['be_banner_subtitle'] : '';
        
    else :
        $be_banner_image            = cs_get_option( 'be_banner_image' );
        $be_banner_title            = cs_get_option( 'be_banner_title' );
        $be_banner_subtitle         = cs_get_option( 'be_banner_subtitle' );        
    endif;
endif;
if (!empty($be_banner_image)):
    $banner_attributes[] = 'class="banner banner-search"';
    $banner_attributes[] = 'style="background-image: url('.esc_url($be_banner_image).')"';
endif;
?>
<!-- banner start here-->
<section <?php echo implode( ' ', $banner_attributes ) ?>>
    <div class="container">
        <div class="banner-content">
            <div class="content">
                <?php
                    if( ! empty( $be_banner_title ) ) :
                        echo '<h1>' . esc_html( $be_banner_title ) . '</h1>';
                    endif; 

                    if( ! empty( $be_banner_subtitle ) ) :
                        echo '<p>' . wp_kses_post( $be_banner_subtitle ) . '</p>';
                    endif; 
                ?>
            </div>
            <div class="search-box">
                <form method="get" action="<?php bloginfo('url');?>">
                    <div class="selectOption">
                        <i class="fa fa-caret-down" aria-hidden="true"></i>
                        <select name="select" id="select">
                            <option value=""><?php echo esc_html__('All Categories', 'event-term') ?></option>
                            <?php 
                            $categories = get_terms( array(
                                'taxonomy' => 'event_categories',
                                'hide_empty' => false,
                            ) );
                            foreach ($categories as $category) {
                                echo '<option value="'.$category->slug.'">', $category->name, "</option>\n";
                            }                                    
                            ?>
                        </select>
                    </div>
                    <input type="text" name="s" value="" placeholder="<?php esc_html_e('Search Event', 'event-term') ?>" />
                    <input type="hidden" name="post_type" value="event">
                    <button type="submit" class="search-submit"><i class="fa fa-search"></i></button>
                </form>
            </div>
        </div>
        <!-- banner content -->
    </div>
    <!-- container -->
</section>
<!-- banner end here -->

