<?php
/**
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

$be_is_theme_event                  = '';
$be_banner_image                    = '';
$be_banner_title                    = '';
$be_banner_subtitle                 = '';
$be_banner_date                     = '';
$be_banner_month                    = '';
$be_banner_year                     = '';
$be_banner_coundown_time            = '';
$be_banner_days_text                = '';
$be_banner_hours_text               = '';
$be_banner_minutes_text             = '';
$be_banner_seconds_text             = '';

if( function_exists( 'cs_get_option' ) ) :
    $be_custom_page_options         = get_post_meta( get_the_ID(), '_be_custom_page_options', true );
    $be_is_theme_event              = isset( $be_custom_page_options['be_is_theme_event'] ) ? $be_custom_page_options['be_is_theme_event'] : '';

    if( is_page() && $be_is_theme_event == true ) :
        $be_banner_image            = isset( $be_custom_page_options['be_banner_image'] ) ? $be_custom_page_options['be_banner_image'] : '';
        $be_banner_title            = isset( $be_custom_page_options['be_banner_title'] ) ? $be_custom_page_options['be_banner_title'] : '';
        $be_banner_subtitle         = isset( $be_custom_page_options['be_banner_subtitle'] ) ? $be_custom_page_options['be_banner_subtitle'] : '';
        $be_banner_date             = isset( $be_custom_page_options['be_banner_date'] ) ? $be_custom_page_options['be_banner_date'] : '';
        $be_banner_month            = isset( $be_custom_page_options['be_banner_month'] ) ? $be_custom_page_options['be_banner_month'] : '';
        $be_banner_year             = isset( $be_custom_page_options['be_banner_year'] ) ? $be_custom_page_options['be_banner_year'] : '';
        $be_banner_date_duration         = isset( $be_custom_page_options['be_banner_date_duration'] ) ? $be_custom_page_options['be_banner_date_duration'] : '';
        $be_banner_location         = isset( $be_custom_page_options['be_banner_location'] ) ? $be_custom_page_options['be_banner_location'] : '';
        $be_banner_coundown_time    = isset( $be_custom_page_options['be_banner_coundown_time'] ) ? $be_custom_page_options['be_banner_coundown_time'] : '';
        $be_banner_days_text        = isset( $be_custom_page_options['be_banner_days_text'] ) ? $be_custom_page_options['be_banner_days_text'] : '';
        $be_banner_hours_text       = isset( $be_custom_page_options['be_banner_hours_text'] ) ? $be_custom_page_options['be_banner_hours_text'] : '';
        $be_banner_minutes_text     = isset( $be_custom_page_options['be_banner_minutes_text'] ) ? $be_custom_page_options['be_banner_minutes_text'] : '';
        $be_banner_seconds_text     = isset( $be_custom_page_options['be_banner_seconds_text'] ) ? $be_custom_page_options['be_banner_seconds_text'] : '';
    else :
        $be_banner_image            = cs_get_option( 'be_banner_image' );
        $be_banner_title            = cs_get_option( 'be_banner_title' );
        $be_banner_subtitle         = cs_get_option( 'be_banner_subtitle' );
        $be_banner_date             = cs_get_option( 'be_banner_date' );
        $be_banner_month            = cs_get_option( 'be_banner_month' );
        $be_banner_year             = cs_get_option( 'be_banner_year' );
        $be_banner_coundown_time    = cs_get_option( 'be_banner_coundown_time' );
        $be_banner_date_duration         = cs_get_option( 'be_banner_date_duration' );
        $be_banner_location         = cs_get_option( 'be_banner_location' );
        $be_banner_days_text        = cs_get_option( 'be_banner_days_text' );
        $be_banner_hours_text       = cs_get_option( 'be_banner_hours_text' );
        $be_banner_minutes_text     = cs_get_option( 'be_banner_minutes_text' );
        $be_banner_seconds_text     = cs_get_option( 'be_banner_seconds_text' );
    endif;
endif;
?>
<!-- banner start here-->
<section class="banner banner-12" style="background-image: url( <?php echo esc_url( $be_banner_image ); ?> );">
    <div class="banner-overlay">
        <div class="banner-content-area">
            <div class="container">
                <div class="row">
                    <div class="col-md-6 col-sm-12 col-xs-12">
                        <div class="seven-content-left">
                            <div class="content">
                                <?php
                                if( ! empty( $be_banner_title ) ) :
                                    echo '<h2>' . esc_html( $be_banner_title ) . '</h2>';
                                endif; 
                                
                                if( ! empty( $be_banner_date_duration ) ) :
                                    echo '<p>' . esc_html( $be_banner_date_duration ) . '</p>';
                                endif; 
                                
                                if( ! empty( $be_banner_location ) ) :
                                    echo '<p>' . esc_html( $be_banner_location ) . '</p>';
                                endif; 
                                ?>
                            </div>
                        </div><!-- content-left -->
                    </div>
                    <div class="col-md-6 col-sm-12 col-xs-12">
                        <div class="seven-content-right-bg">
                            <div class="seven-content-right">
                                <div class="hexagon-box">
                                    <div class="countdown-box">
                                        <ul id="countdown" class="countdown" data-coundown="<?php echo esc_attr( $be_banner_coundown_time ); ?>">
                                            <li class="clock-item">
                                                <span class="count-number days"><?php _e( '00', 'big-event' ); ?></span>
                                                <?php
                                                if( ! empty( $be_banner_days_text ) ) :
                                                    echo '<p class="days_text count-text">' . esc_html( $be_banner_days_text ) . '</p>';
                                                endif; 
                                                ?>
                                            </li>

                                            <li class="clock-item">
                                                <span class="count-number hours"><?php _e( '00', 'big-event' ); ?></span>
                                                <?php
                                                if( ! empty( $be_banner_hours_text ) ) :
                                                    echo '<p class="hours_text count-text">' . esc_html( $be_banner_hours_text ) . '</p>';
                                                endif; 
                                                ?>
                                            </li>

                                            <li class="clock-item">
                                                <span class="count-number minutes"><?php _e( '00', 'big-event' ); ?></span>
                                                <?php
                                                if( ! empty( $be_banner_minutes_text ) ) :
                                                    echo '<p class="minutes_text count-text">' . esc_html( $be_banner_minutes_text ) . '</p>';
                                                endif; 
                                                ?>
                                            </li>

                                            <li class="clock-item">
                                                <span class="count-number seconds"><?php _e( '00', 'big-event' ); ?></span>
                                                <?php
                                                if( ! empty( $be_banner_seconds_text ) ) :
                                                    echo '<p class="seconds_text count-text">' . esc_html( $be_banner_seconds_text ) . '</p>';
                                                endif; 
                                                ?>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div><!-- content-right -->
                        </div><!-- content-right bg -->
                    </div>
                </div><!-- row -->
            </div><!-- banner-content -->
        </div><!-- container-->
    </div><!-- overlay -->
</section>
<!-- banner end here -->