<?php
/**
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
$be_is_theme_event                  = '';
$be_banner_image                    = '';
$be_banner_video                    = '';
$be_banner_embeded_video            = '';
$be_banner_subtitle                 = '';
$be_banner_date                     = '';
$be_banner_month                    = '';
$be_banner_location                 = '';
$be_banner_date_duration            = '';
$be_banner_year                     = '';
$be_banner_coundown_time            = '';
$be_banner_time_offset            = '';

if( function_exists( 'cs_get_option' ) ) :
    $be_custom_page_options         = get_post_meta( get_the_ID(), '_be_custom_page_options', true );
    $be_is_theme_event              = isset( $be_custom_page_options['be_is_theme_event'] ) ? $be_custom_page_options['be_is_theme_event'] : '';

    if( is_page() && $be_is_theme_event == true ) :
        $be_banner_image            = isset( $be_custom_page_options['be_banner_image'] ) ? $be_custom_page_options['be_banner_image'] : '';
        $be_banner_video            = isset( $be_custom_page_options['be_banner_video'] ) ? $be_custom_page_options['be_banner_video'] : '';
        $be_banner_embeded_video    = isset( $be_custom_page_options['be_banner_embeded_video'] ) ? $be_custom_page_options['be_banner_embeded_video'] : '';
        $be_banner_title         = isset( $be_custom_page_options['be_banner_title'] ) ? $be_custom_page_options['be_banner_title'] : '';
        $be_banner_subtitle         = isset( $be_custom_page_options['be_banner_subtitle'] ) ? $be_custom_page_options['be_banner_subtitle'] : '';
        $be_banner_date             = isset( $be_custom_page_options['be_banner_date'] ) ? $be_custom_page_options['be_banner_date'] : '';
        $be_banner_month            = isset( $be_custom_page_options['be_banner_month'] ) ? $be_custom_page_options['be_banner_month'] : '';
        $be_banner_year             = isset( $be_custom_page_options['be_banner_year'] ) ? $be_custom_page_options['be_banner_year'] : '';
        $be_banner_date_duration    = isset( $be_custom_page_options['be_banner_date_duration'] ) ? $be_custom_page_options['be_banner_date_duration'] : '';
        $be_banner_location         = isset( $be_custom_page_options['be_banner_location'] ) ? $be_custom_page_options['be_banner_location'] : '';
        $be_banner_coundown_time    = isset( $be_custom_page_options['be_banner_coundown_time'] ) ? $be_custom_page_options['be_banner_coundown_time'] : '';
        $be_banner_time_offset    = isset( $be_custom_page_options['be_banner_time_offset'] ) ? $be_custom_page_options['be_banner_time_offset'] : '-5';

        $be_banner_speaker          = isset( $be_custom_page_options['be_banner_speaker'] ) ? $be_custom_page_options['be_banner_speaker'] : '';
        $be_banner_tickets     = isset( $be_custom_page_options['be_banner_tickets'] ) ? $be_custom_page_options['be_banner_tickets'] : '';
        $be_banner_setas     = isset( $be_custom_page_options['be_banner_setas'] ) ? $be_custom_page_options['be_banner_setas'] : '';
    else :
        $be_banner_image            = cs_get_option( 'be_banner_image' );
        $be_banner_title            = cs_get_option( 'be_banner_title' );
        $be_banner_subtitle         = cs_get_option( 'be_banner_subtitle' );
        $be_banner_date             = cs_get_option( 'be_banner_date' );
        $be_banner_month            = cs_get_option( 'be_banner_month' );
        $be_banner_year             = cs_get_option( 'be_banner_year' );
        $be_banner_date_duration    = cs_get_option( 'be_banner_date_duration' );
        $be_banner_location         = cs_get_option( 'be_banner_location' );
        $be_banner_coundown_time    = cs_get_option( 'be_banner_coundown_time' );        
        $be_banner_time_offset    = cs_get_option( 'be_banner_time_offset' );           
        $be_banner_speaker     = cs_get_option( 'be_banner_speaker' );
        $be_banner_tickets     = cs_get_option( 'be_banner_tickets' );
        $be_banner_setas     = cs_get_option( 'be_banner_setas' );
    endif;
endif;
?>

<!-- banner start here-->
<section class="dark-layout">
    <div class="dark-overlay-left banner banner-dark banner-seven banner-six">
        <?php if (!empty($be_banner_embeded_video)): ?>    
        <div class="videoWrapper">
            <!-- Copy & Pasted from YouTube -->
            <iframe src="https://www.youtube.com/embed/<?php echo esc_html( $be_banner_embeded_video ); ?>?controls=0&showinfo=0&rel=0&autoplay=1&loop=1&mute=1&playlist=<?php echo esc_html( $be_banner_embeded_video ); ?>" frameborder="0" allowfullscreen></iframe>
        </div>
        <?php elseif (!empty($be_banner_video)): ?>
        <video id="videobg" src="<?php echo esc_url( $be_banner_video ); ?>" autoplay loop muted></video>
        <?php endif; ?>        
        <div class="banner-overlay">
          <div class="container">
            <div class="banner-seven-content">
              <div class="row">
                <div class="col-md-5">
                  <div class="seven-content-right-bg">
                    <div class="seven-content-right">
                      <div class="content">
                        <span class="counter" data-count="<?php echo esc_attr( $be_banner_date ); ?>">
                            <?php _e( '0', 'big-event' ); ?>
                        </span>
                        <p><?php echo esc_html( $be_banner_month ) ?> <?php echo esc_html( $be_banner_year ) ?></p>
                        <ul id="banner-countdown" class="banner-countdown countdown" data-coundown="<?php echo esc_attr( $be_banner_coundown_time ); ?>" data-day="<?php esc_html_e('Day','big-event'); ?>" data-days="<?php esc_html_e('Days','big-event'); ?>" data-hour="<?php esc_html_e('Hour','big-event'); ?>" data-hours="<?php esc_html_e('Hours','big-event'); ?>" data-minute="<?php esc_html_e('Minute','big-event'); ?>" data-minutes="<?php esc_html_e('Minutes','big-event'); ?>" data-second="<?php esc_html_e('Second','big-event'); ?>" data-seconds="<?php esc_html_e('Seconds','big-event'); ?>" data-timeoffset="<?php echo esc_attr($be_banner_time_offset) ?>">
                            <li class="clock-item"><span class="count-number days"><?php esc_html_e('00','big-event') ?></span>
                                <p class="days_text count-text"><?php esc_html_e('Days','big-event'); ?></p>
                            </li>
                            <li class="clock-item"><span class="count-number hours"><?php esc_html_e('00','big-event') ?></span>
                                <p class="hours_text count-text"><?php esc_html_e('Hours','big-event'); ?></p>
                            </li>
                            <li class="clock-item"><span class="count-number minutes"><?php esc_html_e('00','big-event') ?></span>
                                <p class="minutes_text count-text"><?php esc_html_e('Minutes','big-event'); ?></p>
                            </li>
                            <li class="clock-item"><span class="count-number seconds"><?php esc_html_e('00','big-event') ?></span>
                                <p class="seconds_text count-text"><?php esc_html_e('Seconds','big-event'); ?></p>
                            </li>
                        </ul>
                      </div>
                    </div><!-- content-right -->
                  </div><!-- content-right bg -->
                </div>
                <div class="col-md-7">
                  <div class="seven-content-left">
                    <div class="content">
                      <?php 
                      if (!empty($be_banner_subtitle)):
                        echo '<h3>'.$be_banner_subtitle.'</h3>';
                      endif;

                      if (!empty($be_banner_title)):
                        echo '<h1>'.$be_banner_title.'</h1>';
                      endif;
                      ?>                  
              <?php
              if( ! empty( $be_banner_date_duration ) || ! empty( $be_banner_month ) || ! empty( $be_banner_year ) || ! empty( $be_banner_location ) ) : ?>
                <ul>
                  <li><span class="flaticon-tool"></span><?php echo esc_html( $be_banner_date_duration ) ?> <?php echo esc_html( $be_banner_month ) ?>, <?php echo esc_html( $be_banner_year ) ?></li>

                  <?php if( ! empty( $be_banner_location ) ) : ?>
                    <li>
                      <span class="flaticon-signs"></span>
                      <?php echo esc_html( $be_banner_location ) ?>
                    </li>
                  <?php endif; ?>

                </ul>
              <?php endif; ?>
                    </div>
                    <ul class="event-info">
                      <?php if (!empty($be_banner_speaker)): ?>                  
                      <li>
                        <i class="fa fa-microphone" aria-hidden="true"></i>
                        <?php echo esc_html($be_banner_speaker) ?>
                      </li>
                      <?php endif; ?>
                      <?php if (!empty($be_banner_tickets)): ?> 
                      <li>
                        <i class="fa fa-ticket" aria-hidden="true"></i>
                        <?php echo esc_html($be_banner_tickets) ?>
                      </li>
                      <?php endif; ?>
                      <?php if (!empty($be_banner_setas)): ?> 
                      <li>
                        <i class="fa fa-microphone" aria-hidden="true"></i>
                        <?php echo esc_html($be_banner_setas) ?>
                      </li>
                      <?php endif; ?>                 
                    </ul>
                  </div><!-- content-left -->
                </div>
              </div><!-- row -->                            
            </div><!-- banner-content -->
          </div><!-- container-->
        </div><!-- overlay -->
    </div>
</section>
<!-- banner end here -->