<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
$be_speakers_personal_statement_text	= '';
$be_speakers_personal_statement_desc	= '';
$be_speakers_personal_skill_title		= '';
$be_speakers_personal_skills			= array();
$be_speakers_recognition_title			= '';
$be_speakers_recognitions				= array();

if( function_exists( 'cs_get_option' ) ) :

	$be_speakers_post_options 				= get_post_meta( get_the_ID(), '_be_speakers_post_options', true );
	$be_speakers_personal_statement_text  	= isset( $be_speakers_post_options['be_speakers_personal_statement_text'] ) ? $be_speakers_post_options['be_speakers_personal_statement_text'] : '';
	$be_speakers_personal_statement_desc  	= isset( $be_speakers_post_options['be_speakers_personal_statement_desc'] ) ? $be_speakers_post_options['be_speakers_personal_statement_desc'] : '';
	$be_speakers_personal_skill_title  		= isset( $be_speakers_post_options['be_speakers_personal_skill_title'] ) ? $be_speakers_post_options['be_speakers_personal_skill_title'] : '';
	$be_speakers_personal_skills  			= isset( $be_speakers_post_options['be_speakers_personal_skills'] ) ? $be_speakers_post_options['be_speakers_personal_skills'] : '';
	$be_speakers_recognition_title  		= isset( $be_speakers_post_options['be_speakers_recognition_title'] ) ? $be_speakers_post_options['be_speakers_recognition_title'] : '';
	$be_speakers_recognitions  				= isset( $be_speakers_post_options['be_speakers_recognitions'] ) ? $be_speakers_post_options['be_speakers_recognitions'] : '';

endif;

get_header(); ?>

<!-- speaker-details start here -->
<section class="speaker-details padding-120">
  <div class="container">
    <div class="row">

		<?php
		while ( have_posts() ) : the_post();

			get_template_part( 'template-parts/posts/content', 'speaker' );

			// If comments are open or we have at least one comment, load up the comment template.
			if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif;

		endwhile; // End of the loop.
		?>

    </div><!-- row -->
    <div class="speaker-statement">

      <?php
      if( ! empty( $be_speakers_personal_statement_text ) ) :

      	echo '<h4>' . esc_html( $be_speakers_personal_statement_text ) . '</h4>';

      endif; ?>
      
      <?php
      if( ! empty( $be_speakers_personal_statement_desc ) ) :

      	echo wp_kses_post( $be_speakers_personal_statement_desc );

      endif; ?>
    </div>
    <div class="row">
      <div class="col-md-6 col-sm-12 col-xs-12">
        <div class="speaker-skills">

        	<?php
        	if( ! empty( $be_speakers_personal_skill_title ) ) :

        		echo '<h4>' . esc_html( $be_speakers_personal_skill_title ) . '</h4>';

        	endif; ?>

			<?php
			if( ! empty( $be_speakers_personal_skills ) ) :

				$i = 1;
				foreach( $be_speakers_personal_skills as $be_speakers_personal_skill ) :

				if( $i == 1 ) :
					$class = 'first';
				elseif( $i == 2 ) :
					$class = 'second';
				elseif( $i == 3 ) :
					$class = 'third';
				elseif( $i == 4 ) :
					$class = 'fourth';
				else :
					$class = '';
				endif;

				?>

		          <div class="skill-item">
		            <div class="<?php echo esc_attr( $class ); ?> circle" data-skill-level="<?php echo esc_attr( $be_speakers_personal_skill['percent'] ); ?>">
		              <strong></strong>
		            </div>
		            <p><?php echo esc_html( $be_speakers_personal_skill['title'] ); ?></p>
		          </div><!-- skill-item -->

		        <?php $i++; endforeach; ?>

		    <?php endif; ?>

        </div><!-- speaker-skills -->
      </div>
      <div class="col-md-6 col-sm-12 col-xs-12">
        <div class="speaker-award"><!-- speaker-award -->

        	<?php
        	if( ! empty( $be_speakers_recognition_title ) ) :

        		echo '<h4>' . esc_html( $be_speakers_recognition_title ) . '</h4>';

        	endif; ?>

			<?php
			if( $be_speakers_recognitions ) : ?>
			
	          <ul>
				<?php
				foreach( $be_speakers_recognitions as $be_speakers_recognition ) : ?>

	            <li>
	              <img src="<?php echo esc_url( $be_speakers_recognition['image'] ); ?>" alt="award image" class="img-responsive">
	              <span><?php echo esc_html( $be_speakers_recognition['award_year'] ) ?></span>
	            </li>

				<?php endforeach; ?>
	          </ul>

	        <?php
	        endif; ?>
        </div>
      </div>
    </div>
  </div><!-- container -->
</section><!-- speaker-details -->
<!-- speaker-details end here -->

<?php
get_footer();
