<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
$be_speakers_personal_statement_text	= '';

$countdown_time = $short_desc = $event_info = $event_banner = $event_about = $about_tab_title = $event_schedule = $es_tab_title = $schedule_time = $schedule_session = $schedule_room = $event_schedules = $event_speaker = $speaker_tab_title = $event_speakers = $event_ticket = $ticket_tab_title = $ticket_limit = $ticket_from = $ticket_cat = $ticket_tag = $event_details = $event_detail_title = $event_detail_info = $gmap = $gmap_title = $gmap_latutude = $gmap_longitude = $gmap_zoom = $gmap_icon = $event_organizers = $organizers_title = $organizer_image = $organizer_info = $organizer_desctitle = $organizer_description = $event_sponsors = $sponsors_title = $row1_title = $row1_sponsors = $row2_title = $row2_sponsors = $row3_title = $row3_sponsors = '';
if( function_exists( 'cs_get_option' ) ) :
	$eoptions 	        = get_post_meta( get_the_ID(), '_be_event_options', true );	
    $event_banner       = isset( $eoptions['event_banner'] ) ? $eoptions['event_banner'] : '';
    
    $event_about        = isset( $eoptions['event_about'] ) ? $eoptions['event_about'] : '';
    $about_tab_title    = isset( $eoptions['about_tab_title'] ) ? $eoptions['about_tab_title'] : '';
    
    $event_schedule     = isset( $eoptions['event_schedule'] ) ? $eoptions['event_schedule'] : '';
    $es_tab_title       = isset( $eoptions['es_tab_title'] ) ? $eoptions['es_tab_title'] : '';
    $schedule_time      = isset( $eoptions['schedule_time'] ) ? $eoptions['schedule_time'] : '';
    $schedule_session   = isset( $eoptions['schedule_session'] ) ? $eoptions['schedule_session'] : '';
    $schedule_room      = isset( $eoptions['schedule_room'] ) ? $eoptions['schedule_room'] : '';
    $event_schedules    = isset( $eoptions['event_schedules'] ) ? $eoptions['event_schedules'] : '';
    
    $event_speaker      = isset( $eoptions['event_speaker'] ) ? $eoptions['event_speaker'] : '';
    $speaker_tab_title  = isset( $eoptions['speaker_tab_title'] ) ? $eoptions['speaker_tab_title'] : '';
    $event_speakers     = isset( $eoptions['event_speakers'] ) ? $eoptions['event_speakers'] : '';
    
    $event_ticket       = isset( $eoptions['event_ticket'] ) ? $eoptions['event_ticket'] : '';
    $ticket_tab_title   = isset( $eoptions['ticket_tab_title'] ) ? $eoptions['ticket_tab_title'] : '';
    $ticket_type        = isset( $eoptions['ticket_type'] ) ? $eoptions['ticket_type'] : '';
    $ticket_price       = isset( $eoptions['ticket_price'] ) ? $eoptions['ticket_price'] : '';
    $ticket_buy         = isset( $eoptions['ticket_buy'] ) ? $eoptions['ticket_buy'] : '';
    $event_tickets      = isset( $eoptions['event_tickets'] ) ? $eoptions['event_tickets'] : '';
    
    $event_details      = isset( $eoptions['event_details'] ) ? $eoptions['event_details'] : '';
    $event_detail_title = isset( $eoptions['event_detail_title'] ) ? $eoptions['event_detail_title'] : '';
    $event_detail_info  = isset( $eoptions['event_detail_info'] ) ? $eoptions['event_detail_info'] : '';
    $gmap               = isset( $eoptions['gmap'] ) ? $eoptions['gmap'] : '';
    $gmap_title         = isset( $eoptions['gmap_title'] ) ? $eoptions['gmap_title'] : '';
    $gmap_latutude      = isset( $eoptions['gmap_latutude'] ) ? $eoptions['gmap_latutude'] : '';
    $gmap_longitude     = isset( $eoptions['gmap_longitude'] ) ? $eoptions['gmap_longitude'] : '';
    $gmap_zoom          = isset( $eoptions['gmap_zoom'] ) ? $eoptions['gmap_zoom'] : '';
    $gmap_icon          = isset( $eoptions['gmap_icon'] ) ? $eoptions['gmap_icon'] : '';
    
    $event_organizers   = isset( $eoptions['event_organizers'] ) ? $eoptions['event_organizers'] : '';
    $organizers_title   = isset( $eoptions['organizers_title'] ) ? $eoptions['organizers_title'] : '';
    $organizer_image    = isset( $eoptions['organizer_image'] ) ? $eoptions['organizer_image'] : '';
    $organizer_info     = isset( $eoptions['organizer_info'] ) ? $eoptions['organizer_info'] : '';
    $organizer_desctitle = isset( $eoptions['organizer_desctitle'] ) ? $eoptions['organizer_desctitle'] : '';
    $organizer_description = isset( $eoptions['organizer_description'] ) ? $eoptions['organizer_description'] : '';
    
    $event_sponsors    = isset( $eoptions['event_sponsors'] ) ? $eoptions['event_sponsors'] : '';
    $sponsors_title    = isset( $eoptions['sponsors_title'] ) ? $eoptions['sponsors_title'] : '';
    $row1_title        = isset( $eoptions['row1_title'] ) ? $eoptions['row1_title'] : '';
    $row1_sponsors     = isset( $eoptions['row1_sponsors'] ) ? $eoptions['row1_sponsors'] : '';
    $row2_title        = isset( $eoptions['row2_title'] ) ? $eoptions['row2_title'] : '';
    $row2_sponsors     = isset( $eoptions['row2_sponsors'] ) ? $eoptions['row2_sponsors'] : '';
    $row3_title        = isset( $eoptions['row3_title'] ) ? $eoptions['row3_title'] : '';
    $row3_sponsors     = isset( $eoptions['row3_sponsors'] ) ? $eoptions['row3_sponsors'] : '';
    
    $event_banner_url = wp_get_attachment_url( $event_banner );
    $event_banner_alt = get_post_meta( $event_banner, '_wp_attachment_image_alt', true);
    $organizer_image_url = wp_get_attachment_url( $organizer_image );
    $organizer_image_alt = get_post_meta( $organizer_image, '_wp_attachment_image_alt', true);
endif;

get_header(); 

while ( have_posts() ) : the_post();
?>

<section class="event-details padding-120">
    <div class="container">
        <div class="row">
            <div class="col-md-8 col-sm-12 col-xs-12">
                <div class="event-single">
                    <div class="entry-header">
                        <?php 
                        the_title('<h3>', '</h3>');
                        if( ! empty( $event_banner ) ) :
                            echo '<img src="' . esc_url( $event_banner_url ) . '" alt="' . esc_attr( $event_banner_alt ) . '">';
                        endif;                       
                        ?>
                    </div>
                    <div class="entry-content">
                        <div class="event-single-tab">
                            <!-- Nav tabs -->
                            <ul class="tabs-menu" role="tablist">
                                <?php if( ! empty( $event_about ) ) : ?>
                                <li role="presentation" class="active"><a href="#t-about" aria-controls="t-about" role="tab" data-toggle="tab"><?php echo esc_html($about_tab_title) ?></a></li>
                                <?php endif; ?>
                                <?php if( ! empty( $event_schedule ) ) : ?>
                                <li role="presentation"><a href="#t-schedule" aria-controls="t-schedule" role="tab" data-toggle="tab"><?php echo esc_html($es_tab_title) ?></a></li>
                                <?php endif; ?>
                                <?php if( ! empty( $event_speaker ) ) : ?>
                                <li role="presentation"><a href="#t-speaker" aria-controls="t-speaker" role="tab" data-toggle="tab"><?php echo esc_html($speaker_tab_title) ?></a></li>
                                <?php endif; ?>
                                <?php if( ! empty( $event_ticket ) ) : ?>
                                <li role="presentation"><a href="#t-ticket" aria-controls="t-ticket" role="tab" data-toggle="tab"><?php echo esc_html($ticket_tab_title) ?></a></li>
                                <?php endif; ?>
                            </ul>

                            <!-- Tab panes -->
                            <div class="tab-content">
                                <?php if( ! empty( $event_about ) ) : ?>
                                <div role="tabpanel" class="tab-pane active" id="t-about">
                                    <div class="about-content">
                                        <?php 
                                        the_content( sprintf(
                                            /* translators: %s: Name of current post. */
                                            wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'big-event' ), array( 'span' => array( 'class' => array() ) ) ),
                                            the_title( '<span class="screen-reader-text">"', '"</span>', false )
                                        ) );

                                        wp_link_pages( array(
                                            'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'big-event' ),
                                            'after'  => '</div>',
                                        ) );                                        
                                        ?>
                                    </div>
                                </div>
                                <?php endif; ?>
                                <?php if( ! empty( $event_schedule ) ) : ?>
                                <div role="tabpanel" class="tab-pane" id="t-schedule">
                                    <div class="single-event-schedule">
                                        <div class="event-schedule-wrapper">
                                            <div class="event-schedule-list">
                                                <div class="event-schedule-item">
                                                    <div class="time-part">
                                                        <h5><?php echo esc_html($schedule_time) ?></h5>
                                                    </div>
                                                    <div class="session-part">
                                                        <h5><?php echo esc_html($schedule_session) ?></h5>
                                                    </div>
                                                    <div class="room-part">
                                                        <h5><?php echo esc_html($schedule_room) ?></h5>
                                                    </div>
                                                </div>
                                                <?php 
                                                if(!empty($event_schedules)):
                                                    foreach ($event_schedules as $schedules) : 
                                                ?>
                                                <div class="event-schedule-item">
                                                    <div class="time-part">
                                                        <span><i class="fa fa-clock-o"></i> <?php echo esc_html($schedules['time']) ?></span>
                                                    </div>
                                                    <div class="session-part">
                                                        <span><?php echo esc_html($schedules['session']) ?></span>
                                                    </div>
                                                    <div class="room-part">
                                                        <span><i class="fa fa-home"></i><?php echo esc_html($schedules['room']) ?></span>
                                                    </div>
                                                </div>
                                                <?php endforeach; endif; ?>                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                                <?php if( ! empty( $event_speaker ) ) : ?>
                                <div role="tabpanel" class="tab-pane" id="t-speaker">
                                    <div class="event-member">
                                        <?php 
                                        if(!empty($event_speakers)): 
                                            foreach ($event_speakers as $speakers) : 
                                        ?>
                                        <div class="event-guest">
                                            <?php
                                            if(!empty($speakers['title'])):
                                                echo '<h4>'.esc_html($speakers['title']).'</h4>';
                                            endif;
                                            ?>
                                            <div class="clearfix"></div>
                                            <div class="event-member-list row">
                                                <?php
                                                $speaker_limit = $speakers['speaker_limit'];
                                                $speaker_from = $speakers['speaker_from'];
                                                $speaker_cat = isset( $speakers['speaker_cat'] ) ? $speakers['speaker_cat'] : '';
                                                $speaker_tag = isset( $speakers['speaker_tag'] ) ? $speakers['speaker_tag'] : '';
                                                $order = $speakers['order'];
                                                if ($speaker_from == 'tag' && isset($speaker_tag)) :
                                                    $spekers_query = new WP_Query( array(
                                                        'post_type'				=> 'speakers',
                                                        'posts_per_page'		=> $speaker_limit,
                                                        'ignore_sticky_post'	=> true,
                                                        'post_status'           => 'publish',
                                                        'order'                 => $order,
                                                        'tax_query' => array(
                                                            array (
                                                                'taxonomy' => 'speakers_tag',
                                                                'field' => 'term_id',
                                                                'terms' => $speaker_tag,
                                                            )
                                                        ), 
                                                    ) );
                                                elseif ($speaker_from == 'category' && isset($speaker_cat)) :
                                                    $spekers_query = new WP_Query( array(
                                                        'post_type'				=> 'speakers',
                                                        'posts_per_page'		=> $speaker_limit,
                                                        'ignore_sticky_post'	=> true,
                                                        'post_status'           => 'publish',
                                                        'order'                 => $order,
                                                        'tax_query' => array(
                                                            array (
                                                                'taxonomy' => 'speakers_tag',
                                                                'field' => 'term_id',
                                                                'terms' => $speaker_cat,
                                                            )
                                                        ),
                                                    ) );                                                    
                                                else :
                                                    $spekers_query = new WP_Query( array(
                                                        'post_type'				=> 'speakers',
                                                        'posts_per_page'		=> $speaker_limit,
                                                        'ignore_sticky_post'	=> true,
                                                        'post_status'           => 'publish',
                                                        'order'                 => $order,
                                                    ) );
                                                endif;
                                                
                                                if( $spekers_query->have_posts() ) :
                                                    while( $spekers_query->have_posts() ) : $spekers_query->the_post();
                                                    if( function_exists( 'cs_get_option' ) ) :
                                                        $speakers_options = get_post_meta( get_the_ID(), '_be_speakers_post_options', true );
                                                        $designation  = isset( $speakers_options['be_speakers_designation'] ) ? $speakers_options['be_speakers_designation'] : '';
                                                    endif;                                                
                                                ?>
                                                <div class="event-member-item">
                                                    <div class="event-member-item-inner">
                                                        <div class="event-member-thumb">
                                                            <?php
                                                            if( has_post_thumbnail() ) :
                                                              the_post_thumbnail( 'big-event-speaker-three-image' );
                                                            endif; 
                                                            ?>
                                                        </div>
                                                        <div class="event-member-content">
                                                            <?php 
                                                            the_title( '<h5><a href="' . get_permalink() . '">', '</a></h5>' );
                                                            if(!empty($designation)):
                                                                echo '<p class="desig">'.esc_html($designation).'</p>';
                                                            endif;
                                                            ?>                                                            
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php endwhile; wp_reset_postdata(); endif; ?>                                                
                                            </div>
                                        </div>
                                        <?php endforeach; endif; ?> 
                                    </div>
                                </div>
                                <?php endif; ?>
                                <?php if( ! empty( $event_ticket ) ) : ?>
                                <div role="tabpanel" class="tab-pane" id="t-ticket">
                                    <div class="event-ticket">
                                        <div class="ticket-table">
                                            <table>
                                                <thead>
                                                    <tr>
                                                        <th colspan="2" class="title"><?php echo esc_html($ticket_type) ?></th>
                                                        <th><?php echo esc_html($ticket_price) ?></th>
                                                        <th class="total-cart"><?php echo esc_html($ticket_buy) ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php 
                                                    if(!empty($event_tickets)):
                                                        foreach ($event_tickets as $tickets) :
                                                        $ticket_image_url = wp_get_attachment_url( $tickets['image'] );
                                                        $ticket_image_alt = get_post_meta( $tickets['image'], '_wp_attachment_image_alt', true);
                                                    ?>
                                                    <tr>
                                                        <td colspan="2" class="product-thumbnail">
                                                            <?php if(!empty($tickets['image'])): ?>
                                                            <div class="image">
                                                                <img src="<?php echo esc_url($ticket_image_url) ?>" alt="<?php echo esc_url($ticket_image_alt) ?>" class="img-responsive">
                                                            </div>
                                                            <?php endif; ?>
                                                            <div class="content">
                                                                <?php 
                                                                if(!empty($tickets['title'])):
                                                                    echo '<h5>'.esc_html($tickets['title']).'</h5>';
                                                                endif;
                                                                if(!empty($tickets['limit'])):
                                                                    echo '<p>'.esc_html($tickets['limit']).'</p>';
                                                                endif;
                                                                ?>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <?php 
                                                            if(!empty($tickets['price'])):
                                                                echo '<span>'.esc_html($tickets['price']).'</span>';
                                                            endif;
                                                            ?>                                                            
                                                        </td>                                                        
                                                        <td class="total-cart">
                                                            <?php 
                                                            if(!empty($tickets['btn_text'])):
                                                                echo '<a href="'.esc_url($tickets['btn_url']).'">'.esc_html($tickets['btn_text']).'</a>';
                                                            endif;
                                                            ?> 
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; endif; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>                                
                            </div>
                        </div>
                    </div>
                    <div class="entry-footer">
                        <ul class="share event-social style2">
                            <li><span class="share-icon"><img src="<?php echo get_template_directory_uri() ?>/images/share-icon.png" alt=""></span></li>
                            <li><a href="http://www.facebook.com/sharer.php?u=<?php echo urlencode(get_permalink($post->ID)); ?>"><i class="fa fa-facebook" aria-hidden="true"></i><span><?php esc_html_e('Facebook','big-event')?></span></a></li>
                            <li><a href="http://twitter.com/home?status=<?php the_title(); ?> <?php echo urlencode(get_permalink($post->ID)); ?>"><i class="fa fa-twitter" aria-hidden="true"></i><span><?php esc_html_e('Twitter','big-event')?></span></a></li>
                            <li><a href="https://plusone.google.com/_/+1/confirm?hl=en&amp;url=<?php echo urlencode(get_permalink($post->ID)); ?>&amp;name=<?php the_title(); ?>"><i class="fa fa-google-plus" aria-hidden="true"></i><span><?php esc_html_e('Google Plus','big-event')?></span></a></li>
                        </ul>
                    </div>                    
                </div>
                <!-- blog item -->



            </div>
            <div class="col-md-4 col-sm-12 col-xs-12">
                <div class="event-sidebar">
                    <div>
                        <?php if ($event_details == 1) : ?>
                        <div class="sidebar-item">
                            <?php if(!empty($event_detail_title)): ?>
                            <h4 class="sidebar-title"><?php echo esc_html($event_detail_title) ?></h4>
                            <?php endif; ?>
                            <div class="sidebar-content">
                                
                                <ul class="event-detail">
                                    <?php 
                                    if(!empty($event_detail_info)):
                                    foreach ($event_detail_info as $info): 
                                    ?>
                                    <li>
                                        <span class="event-details-left-text"><?php echo esc_html($info['title']) ?></span>:
                                        <span class="event-details-right-text"><?php echo esc_html($info['description']) ?></span>
                                    </li>
                                    <?php endforeach; endif; ?>
                                    <?php if ($gmap == 1) : ?>
                                    <li>
                                        <span class="map-title"><?php echo esc_html($gmap_title) ?></span>
                                        <span id="event-map" class="map" data-map-icon="<?php echo esc_url( $gmap_icon ); ?>" data-map-latitute="<?php echo esc_attr( $gmap_latutude ) ?>" data-map-longitude="<?php echo esc_attr( $gmap_longitude ) ?>" data-map-zoom="<?php echo esc_attr( $gmap_zoom ) ?>"></span>
                                    </li>
                                    <?php endif; ?>
                                </ul>
                                
                            </div>
                        </div>
                        <?php endif; ?>
                        <?php if ($event_organizers == 1) : ?>
                        <div class="sidebar-item">
                            <?php if(!empty($organizers_title)): ?>
                            <h4 class="sidebar-title"><?php echo esc_html($organizers_title) ?></h4>
                            <?php endif; ?>
                            <div class="sidebar-content event-orgainizer-info">
                                <?php if(!empty($organizer_image)): ?>
                                <div class="eo-thumb">
                                    <img src="<?php echo esc_url($organizer_image_url) ?>" alt="<?php echo esc_attr($organizer_image_alt) ?>">
                                </div>
                                <?php endif; ?>
                                <ul>
                                    <?php
                                    if(!empty($organizer_info)):
                                    foreach ($organizer_info as $info): 
                                    ?>
                                    <li>
                                        <span class="eo-info-list-left"><?php echo esc_html($info['title']) ?></span>:
                                        <span class="eo-info-list-right"><?php echo esc_html($info['description']) ?></span>
                                    </li>
                                    <?php endforeach; endif; ?> 
                                    <?php if(!empty($organizer_desctitle) || !empty($organizer_description)) : ?>
                                    <li>
                                        <span class="eo-info-desc"><?php echo esc_html($organizer_desctitle) ?></span>
                                        <p><?php echo esc_html($organizer_description) ?></p>
                                    </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <?php if ($event_sponsors == 1) : ?>
                        <div class="sidebar-item">
                            <?php if(!empty($sponsors_title)): ?>
                            <h4 class="sidebar-title"><?php echo esc_html($sponsors_title) ?></h4>
                            <?php endif; ?>
                            <div class="sidebar-content event-sponsors">
                                <div class="event-sponsor-list">
                                    <?php if(!empty($row1_sponsors)): ?>
                                    <div class="es-type-item">
                                        <h5><?php echo esc_html($row1_title) ?></h5>
                                        <div class="clearfix"></div>
                                        <?php 
                                        if(!empty($row1_sponsors)):
                                        foreach ($row1_sponsors as $sponsors):
                                            $logo_url = wp_get_attachment_url( $sponsors['logo'] );
                                            $logo_alt = get_post_meta( $sponsors['logo'], '_wp_attachment_image_alt', true);
                                        ?>
                                        <div class="emsponsor-item">
                                            <div class="emsponsor-item-inner">
                                                <img src="<?php echo esc_url($logo_url) ?>" alt="<?php echo esc_attr($logo_alt) ?>">
                                            </div>
                                        </div>                                        
                                        <?php endforeach; endif; ?> 
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if(!empty($row2_sponsors)): ?>
                                    <div class="es-type-item">
                                        <h5><?php echo esc_html($row2_title) ?></h5>
                                        <div class="clearfix"></div>
                                        <?php 
                                        if(!empty($row2_sponsors)):
                                        foreach ($row2_sponsors as $sponsors):
                                            $logo_url = wp_get_attachment_url( $sponsors['logo'] );
                                            $logo_alt = get_post_meta( $sponsors['logo'], '_wp_attachment_image_alt', true);
                                        ?>
                                        <div class="emsponsor-item">
                                            <div class="emsponsor-item-inner">
                                                <img src="<?php echo esc_url($logo_url) ?>" alt="<?php echo esc_attr($logo_alt) ?>">
                                            </div>
                                        </div>                                        
                                        <?php endforeach; endif; ?> 
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if(!empty($row3_sponsors)): ?>
                                    <div class="es-type-item">
                                        <h5><?php echo esc_html($row3_title) ?></h5>
                                        <div class="clearfix"></div>
                                        <?php
                                        if(!empty($row3_sponsors)):
                                        foreach ($row3_sponsors as $sponsors):
                                            $logo_url = wp_get_attachment_url( $sponsors['logo'] );
                                            $logo_alt = get_post_meta( $sponsors['logo'], '_wp_attachment_image_alt', true);
                                        ?>
                                        <div class="emsponsor-item">
                                            <div class="emsponsor-item-inner">
                                                <img src="<?php echo esc_url($logo_url) ?>" alt="<?php echo esc_attr($logo_alt) ?>">
                                            </div>
                                        </div>                                        
                                        <?php endforeach; endif; ?> 
                                    </div>
                                    <?php endif; ?>                                    
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        <!-- sidebar item -->
                    </div>
                </div>
                <!-- sidebar -->
            </div>
        </div>
        <!-- row -->
    </div>
    <!-- container -->
</section>

<?php
endwhile; // End of the loop.
get_footer();