<?php

/**
 * The sidebar containing the main widget area
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

/**
 * Add Big Event Popular Posts Widget
 */

class Widget_Popular_Posts extends Big_Event_Widget {

	/**
	 * Register Heal Pro Theme Popular Posts Widget with WordPress
	 */
	public function __construct() {
		parent::__construct(
			'big_event_popular_posts',	// Base ID
			esc_html__( 'Big Event::Popular Posts', 'big-event' ),
			array( 'description' => 'Popular Posts widget to display post categories', 'big-event' )
		);
	}


	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	 public function widget( $args, $instance ) {
		echo $args['before_widget'];
			if( ! empty( $instance['title'] ) ) :
				echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
			endif;

			$popular_posts = new WP_Query( array(
				'posts_type'			=> 'post',
				'posts_status'			=> 'plublish',
				'posts_per_page'		=> $instance['post_count'],
				'meta_key'				=> 'post_views_count',
				'orderby'				=> 'meta_value_num',
				'ignore_sticky_posts'	=> true
			) );
			if( $popular_posts->have_posts() ) :
			?>	

			<ul class="popular-posts">

				<?php

				/* Start the Loop */
				while( $popular_posts->have_posts() ) : $popular_posts->the_post(); ?>

					<li class="blog-item">
						<?php if( ! empty( $instance['is_image'] ) ) : ?>
							<?php if( has_post_thumbnail() ) : ?>
								<div class="image">
									<a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_post_thumbnail( 'big-event-blog-page-popular', array( 'class' => 'img-responsive' ) ); ?></a>
								</div>
							<?php endif; ?>
						<?php endif; ?>
						<div class="content">
							<?php the_title( '<h5><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h5>' ); ?>
							<?php if( ! empty( $instance['is_post_info'] ) ) : ?>
								
								<span><?php the_time( 'j F Y' ) ?></span>

							<?php endif; ?>
						</div>
					</li>

				<?php
				endwhile;

				wp_reset_postdata(); ?>

			</ul>

		<?php
		endif;

		echo $args['after_widget'];
	 }



	/**
	 * Heal Pro Popular Posts Widget field with Codestar Framework
	 */
	function get_options() {
		return array(
			array(
				'id'	=> 'title',
				'type'	=> 'text',
				'title'	=> esc_html__( 'Title', 'big-event' )
			),
			array(
				'id'	  => 'post_count',
				'type'	  => 'number',
                'default' => '4',
				'title'	  => esc_html__( 'Number of posts to show:', 'big-event' )
			),
			array(
				'id'	=> 'is_image',
				'type'	=> 'checkbox',
				'label'	=> esc_html__( 'Display Post Image?', 'big-event' )
			),
			array(
				'id'	=> 'is_post_info',
				'type'	=> 'checkbox',
				'label'	=> esc_html__( 'Display Date?', 'big-event' )
			)
		);
	}
}