<?php
/**
 * The sidebar containing the main widget area
 *
 * @package big-event
 * @since 1.0.0
 * @version 1.0.0
 * @author CodexCoder
 */

/**
 * Add Recent Posts Widget
 */

class Widget_Latest_News extends Big_Event_Widget {
	/**
	 * Register widget with WordPress
	 */
	public function __construct() {
		parent::__construct(
			'big_event_recent_posts',	// Base ID
			esc_html__( 'Big Event:: Latest News', 'big-event' ),	// Name
			array( 'description' => __( 'Widgets to display latest news', 'big-event' ) )	// Args
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		echo $args['before_widget'];
		if( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
		}

		$recent_posts = new WP_Query( array(
			'posts_type'		=> 'post',
            'posts_status'			=> 'plublish',
			'posts_per_page'	=> $instance['postcount']
		) );
		if( $recent_posts->have_posts() ) : ?>

		<div class="latest-posts">

			<?php while( $recent_posts->have_posts() ) : $recent_posts->the_post(); ?>

			<div class="blog-item">
				<div class="image">
					<?php 
					if( ! empty( $instance['showimage'] ) ) :

						if( has_post_thumbnail() ) :

							echo '<a href="'. esc_url( get_permalink() ) .'" class="post-thumb">'. get_the_post_thumbnail( '', 'big-event-latest-post' ) .'</a>';
						
						endif;

					endif; ?>
				</div>
				<div class="content">
					<?php the_title( '<h4><a href="'. esc_url(get_permalink()) .'" class="title">', '</a></h4>' ); ?>
					<ul class="meta-post">
						<?php
						if( ! empty( $instance['postinfo'] ) ) : 
						
		                    if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
		                            echo '<li class="comment"><span class="icon flaticon-chat"></span>';
		                            /* translators: %s: post title */
		                            comments_popup_link( 'Leave a comment', '1 comment', '% comments');
		                            echo '</li>';
		                    }
		                endif;
		                ?>
					</ul>
				</div>
			</div>

			<?php
			endwhile;

			wp_reset_postdata();

			?>

		</div>
		
		<?php 
		
		endif;
		echo $args['after_widget'];
	}

	/**
	 * Recent Posts field with Codestar Framework
	 */
	function get_options() {
		return array(
			array(
				'id'			=> 'title',
				'type'			=> 'text',
				'title'			=> esc_html__( 'Title:', 'big-event' )
			),
			array(
				'id'			=> 'postcount',
				'type'			=> 'number',
				'title'			=> esc_html__( 'Number of posts to show:', 'big-event' ),
				'attributes'	=> array(
					'style'		=> 'width: 60px;'
				)
			),
			array(
				'id'			=> 'postinfo',
				'type'			=> 'checkbox',
				'label'			=> esc_html__( 'Display post info?', 'big-event' )
			),
			array(
				'id'			=> 'showimage',
				'type'			=> 'checkbox',
				'label'			=> esc_html__( 'Display post image?', 'big-event' )
			)
		);
	}
}

