<?php
/**
 * The sidebar containing the main widget area
 *
 * @package big-event
 * @since 1.0.0
 * @version 1.0.0
 * @author CodexCoder
 */

/**
 * Add Recent Posts Widget
 */

class Widget_Latest_News_2 extends Big_Event_Widget {
	/**
	 * Register widget with WordPress
	 */
	public function __construct() {
		parent::__construct(
			'big_event_recent_posts_2',	// Base ID
			esc_html__( 'Big Event:: Latest News 2', 'big-event' ),	// Name
			array( 'description' => __( 'Widgets to display latest news', 'big-event' ) )	// Args
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		echo $args['before_widget'];
		if( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
		}

		$recent_posts = new WP_Query( array(
			'posts_type'		=> 'post',
            'posts_status'			=> 'plublish',
			'posts_per_page'	=> $instance['postcount']
		) );
		if( $recent_posts->have_posts() ) : ?>

		<ul class="popular-posts">

			<?php while( $recent_posts->have_posts() ) : $recent_posts->the_post(); ?>

            <li class="blog-item">
                <?php if( ! empty( $instance['showimage'] ) ) : ?>
                    <?php if( has_post_thumbnail() ) : ?>
                        <div class="image">
                            <a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_post_thumbnail( 'big-event-blog-page-popular', array( 'class' => 'img-responsive' ) ); ?></a>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
                <div class="content">
                    <?php the_title( '<h5><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h5>' ); ?>
                    <?php if( ! empty( $instance['postinfo'] ) ) : ?>

                        <span><?php esc_html_e('Date: ','big-event').the_time( 'j F Y' ) ?></span>

                    <?php endif; ?>
                </div>
            </li>

			<?php
			endwhile;

			wp_reset_postdata();

			?>

		</ul>
		
		<?php 
		
		endif;
		echo $args['after_widget'];
	}

	/**
	 * Recent Posts field with Codestar Framework
	 */
	function get_options() {
		return array(
			array(
				'id'			=> 'title',
				'type'			=> 'text',
				'title'			=> esc_html__( 'Title:', 'big-event' )
			),
			array(
				'id'			=> 'postcount',
				'type'			=> 'number',
				'default'		=> '4',
				'title'			=> esc_html__( 'Number of posts to show:', 'big-event' ),
				'attributes'	=> array(
					'style'		=> 'width: 60px;'
				)
			),
			array(
				'id'			=> 'postinfo',
				'type'			=> 'checkbox',
				'label'			=> esc_html__( 'Display post info?', 'big-event' )
			),
			array(
				'id'			=> 'showimage',
				'type'			=> 'checkbox',
				'label'			=> esc_html__( 'Display post image?', 'big-event' )
			)
		);
	}
}

