<?php

/**
 * The sidebar containing the main widget area
 *
 * @package big-event
 * @since 1.0.0
 * @version 1.0.0
 * @author CodexCoder
 */

/**
 * Add Big Event categories widget
 */

class Widget_Categories extends Big_Event_Widget {

	/**
	 * Register widget with WordPress
	 */
	public function __construct() {
		parent::__construct(
			'big_event_categories',		// Base ID
			esc_html__( 'Big Event:: Categories', 'big-event' ),	// Name
			array( 'description' => __( 'Categories widget to display post categories', 'big-event' ) )
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		echo $args['before_widget'];
		if( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
		}
		?>
        <ul class="categores">
            <?php $categories = get_terms( 'category', array( 
            	'orderby'		=> 'name',
            	'hide_empty'	=> true,
            ) );

            foreach( $categories as $category ) :
            	$category_link = get_term_link( $category, $category->slug ); ?>
				<li>
					<a href="<?php echo esc_url( $category_link ); ?>">
						<i class="fa fa-angle-double-right" aria-hidden="true"></i>
						<?php echo esc_html( $category->name ); ?>
					</a>
					<?php if( ! empty( $instance['postcount'] ) ) : ?>
					<span><?php echo esc_html( $category->count ); ?></span>
					<?php endif; ?>
				</li>
            <?php endforeach; ?>
        </ul>
        <?php
		echo $args['after_widget'];
	}

	/**
	 * Categories field with Codestar Framework
	 */
	function get_options() {
		return array(
			array(
				'id'		=> 'title',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Title: ', 'big-event' )
			),
			array(
				'id'		=> 'postcount',
				'type'		=> 'checkbox',
				'label'		=> esc_html__( 'Show post count', 'big-event' )
			)
		);
	}

}
