<?php
class Widget_About_Us extends Big_Event_Widget {
	public function __construct()
	{
		parent::__construct(
            'et_about_us',
            esc_html__('Big Event:: About Us', 'big-event'),
            array('description' => 'About us widget to display your logo content and social profiles.' )
        );
	}

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget($args, $instance) {
        echo $args['before_widget'];
        if ( ! empty( $instance['title'] ) ) {
            echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
        }
        ?>
        <?php if( ! empty($instance['logo']) ) : ?>
        <div class="footer-widget-title">
            <div class="footer-logo">
                <img src="<?php echo wp_get_attachment_url($instance['logo']);?>" alt="<?php echo get_the_title($instance['logo']); ?>">
            </div>
        </div>
        <?php endif; ?>
        <div class="footer-widget-body widget-about">
            <?php if( ! empty($instance['content']) ) : ?>
                <p><?php echo wp_kses_post($instance['content']); ?></p>
            <?php endif; ?>            
                                   
            <ul class="contact-item-list">
                <?php if( ! empty($instance['contactno']) ) : ?>
                <li>
                    <?php if( ! empty($instance['contacticon']) ) : ?>
                    <div class="event-date">
                        <div class="event-date-inner">
                            <i class="<?php echo esc_attr($instance['contacticon']) ?>" aria-hidden="true"></i>
                        </div>
                    </div><!--event-date end-->
                    <?php 
                    endif; 
                    if( ! empty($instance['contactno']) ) :
                        echo '<span>'.esc_html($instance['contactno']).'</span>';
                    endif;
                    ?>                                                            
                </li>
                <?php endif; ?> 
                <?php if( ! empty($instance['email']) ) : ?>
                <li>
                    <?php if( ! empty($instance['emailicon']) ) : ?>
                    <div class="event-date">
                        <div class="event-date-inner">
                            <i class="<?php echo esc_attr($instance['emailicon']) ?>" aria-hidden="true"></i>
                        </div>
                    </div><!--event-date end-->
                    <?php 
                    endif; 
                    if( ! empty($instance['email']) ) :
                        echo '<span>'.esc_html($instance['email']).'</span>';
                    endif;
                    ?>                                                            
                </li>
                <?php endif; ?> 
                <?php if( ! empty($instance['socialusername']) ) : ?>
                <li>
                    <?php if( ! empty($instance['socialicon']) ) : ?>
                    <div class="event-date">
                        <div class="event-date-inner">
                            <i class="<?php echo esc_attr($instance['socialicon']) ?>" aria-hidden="true"></i>
                        </div>
                    </div><!--event-date end-->
                    <?php 
                    endif; 
                    if( ! empty($instance['socialusername']) ) :
                        echo '<span>'.esc_html($instance['socialusername']).'</span>';
                    endif;
                    ?>                                                            
                </li>
                <?php endif; ?> 
            </ul>
        </div>
<?php
        echo $args['after_widget'];
	}

    function get_options() {
        return array(
            array(
                'id'      => 'title',
                'type'    => 'text',
                'title'   => esc_html__('Title:', 'big-event'),
            ),
            array(
                'id'      => 'logo',
                'type'    => 'image',
                'title'   => esc_html__('Logo:', 'big-event'),
            ),
            array(
                'id'      => 'content',
                'type'    => 'textarea',
                'title'   => esc_html__('Content:', 'big-event'),
            ),
            array(
                'id'      => 'contacticon',
                'type'    => 'icon',
                'title'   => esc_html__('Contact Icon:', 'big-event'),
            ),
            array(
                'id'      => 'contactno',
                'type'    => 'text',
                'title'   => esc_html__('Contact No:', 'big-event'),
            ),
            array(
                'id'      => 'emailicon',
                'type'    => 'icon',
                'title'   => esc_html__('Email Icon:', 'big-event'),
            ),
            array(
                'id'      => 'email',
                'type'    => 'text',
                'title'   => esc_html__('Email:', 'big-event'),
            ),
            array(
                'id'      => 'socialicon',
                'type'    => 'icon',
                'title'   => esc_html__('Social Icon:', 'big-event'),
            ),
            array(
                'id'      => 'socialusername',
                'type'    => 'text',
                'title'   => esc_html__('Social Username:', 'big-event'),
            ),            
        );
    }
}