<?php
/**
 * Big Event functions and definitions
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function big_event_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'big-event' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'big-event' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s sidebar-item">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="sidebar-title">',
		'after_title'   => '</h4>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer', 'big-event' ),
		'id'            => 'Footer',
		'description'   => esc_html__( 'Add widgets here.', 'big-event' ),
		'before_widget' => '<div id="%1$s" class="col-md-4 col-sm-12 widget %2$s sidebar-item">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="footer-widget-title"><h4 class="sidebar-title">',
		'after_title'   => '</h4></div>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'MailPoet Newsletter', 'big-event' ),
		'id'            => 'mailpoet',
		'description'   => esc_html__( 'Add widgets here.', 'big-event' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s sidebar-item">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4>',
		'after_title'   => '</h4>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'WooCommerce Sidebar', 'big-event' ),
		'id'            => 'woo-sidebar',
		'description'   => esc_html__( 'Add widgets here.', 'big-event' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s por-sidebar-item">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="sidebar-title">',
		'after_title'   => '</h4>',
	) );
}
add_action( 'widgets_init', 'big_event_widgets_init' );