<?php
/**
 * Big Event functions and definitions
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

if ( ! function_exists( 'big_event_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function big_event_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on Big Event, use a find and replace
	 * to change 'big-event' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'big-event', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );
	add_image_size( 'big-event-blog-image', 750, 350, true );
	add_image_size( 'big-event-speaker-three-image', 360, 360, true );
	add_image_size( 'big-event-blog-three-column', 360, 263, true );
	add_image_size( 'big-event-gallery-three-column', 376, 314, true );
	add_image_size( 'big-event-blog-two-column', 555, 340, true );
	add_image_size( 'big-event-blog-page-popular', 80, 80, true );
	add_image_size( 'big-event-340-400', 340, 400, true );
    add_image_size( 'big-event-260-300', 260, 300, true );
    add_image_size( 'big-event-370-400', 370, 400, true );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' 	=> esc_html__( 'Primary', 'big-event' ),
		'one-page' 	=> esc_html__( 'One Page', 'big-event' ),
		'mobile-menu' 	=> esc_html__( 'Mobile Menu', 'big-event' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'big_event_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support( 'custom-logo', array(
		'height'      => 250,
		'width'       => 250,
		'flex-width'  => true,
		'flex-height' => true,
	) );

	/**
	 * WooCommerce Support
	 */
	add_theme_support( 'woocommerce' );
}
endif;
add_action( 'after_setup_theme', 'big_event_setup' );


/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function big_event_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'big_event_content_width', 640 );
}
add_action( 'after_setup_theme', 'big_event_content_width', 0 );


/**
 * Registers an editor stylesheet for the theme.
 */
function big_event_theme_add_editor_styles() {
    add_editor_style( 'custom-editor-style.css' );
}
add_action( 'admin_init', 'big_event_theme_add_editor_styles' );