<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Big_Event
 */

if ( ! function_exists( 'big_event_posted_on' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time and author.
 */
function big_event_posted_on() {
	$time_string = '%2$s';
	if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
		$time_string = '%4$s';
	}

	$time_string = sprintf( $time_string,
		esc_attr( get_the_date( 'c' ) ),
		esc_html( get_the_date() ),
		esc_attr( get_the_modified_date( 'c' ) ),
		esc_html( get_the_modified_date() )
	);



	$date_format = get_option( 'date_format' );

	if( $date_format == 'F j, Y' ) {
		$time_string = explode( ' ', $time_string );

		$date = str_replace(',', '', $time_string[1]);
		$date = '<span>' . $date . '</span>';

		$month = $time_string[0];
		$year = $time_string[2];
		$posted_on = sprintf(
			/* translators: %s: post date. */
			'<li><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $date . $month . ', ' . $year . '</a></li>'
		);
	} else {
		$posted_on = sprintf(
			/* translators: %s: post date. */
			'<li class="time-format"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . get_the_date() . '</a></li>'
		);
	}

	$byline = sprintf(
		/* translators: %s: post author. */
		esc_html_x( 'by %s', 'post author', 'big-event' ),
		'<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
	);


	echo '<ul class="post-meta">' . $posted_on . '<li class="byline"><span class="icon flaticon-user"></span>' . $byline . '</li>'; // WPCS: XSS OK.

}
endif;

if ( ! function_exists( 'big_event_entry_footer' ) ) :
/**
 * Prints HTML with meta information for the categories, tags and comments.
 */
function big_event_entry_footer() {
	// Hide category and tag text for pages.
	if ( 'post' === get_post_type() ) {

		/* translators: used between list items, there is a space after the comma */
		$tags_list = get_the_tag_list( '', esc_html_x( ' ', 'list item separator', 'big-event' ) );
		if ( $tags_list ) {
			/* translators: 1: list of tags. */
			printf( '<div class="tags">' . esc_html__( 'Tags %1$s', 'big-event' ) . '</div>', $tags_list ); // WPCS: XSS OK.
		}
	}
}
endif;
