<?php
/**
 * Big Event functions and definitions
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

/**
 * Register Google Fonts
 */

function big_event_fonts_url() {
	$fonts_url = '';

	/* Translators: If there are characters in your language that are not
	* supported by Lora, translate this to 'off'. Do not translate
	* into your own language.
	*/

	$lora = _x( 'on', 'Lora font: on or off', 'big-event' );

	/* Translators: If there are characters in your language that are not
	* supported by Open Sans, translate this to 'off'. Do not translate
	* into your own language.
	*/

	$poppins = _x( 'on', 'Poppins font: on or off', 'big-event' );

	if( 'off' !== $lora || 'off' !== $poppins ) {
		$font_families = array();

		if( 'off' !== $lora ) {
			$font_families[] = 'Lora:400,400i,700,700i';
		}

		if( 'off' !== $poppins ) {
			$font_families[] = 'Poppins:300,400,500,600,700';
		}

		$query_args = array(
			'family'	=> urlencode( implode( '|', $font_families ) ),
			'subset'	=> urlencode( 'latin,latin-ext' ),
		);

		$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
	}

	return esc_url_raw( $fonts_url );;
}

function big_event_default_font_load() {
	wp_enqueue_style( 'big-event-default-fonts', big_event_fonts_url(), array(), null );
}

/**
 * Big Event Fonts
 */


function big_event_fonts_url_load() {
	$be_body_font 			= cs_get_option( 'be_body_font_family' );
	$be_font_body_family 	= $be_body_font['family'];
	
	$be_title_font 			= cs_get_option( 'be_title_font_family' );
	$be_title_font_family 	= $be_title_font['family'];

	$be_menu_font 			= cs_get_option( 'be_menu_font_family' );
	$be_menu_font_family 	= $be_menu_font['family'];

	$font_url = '';

    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
     */
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'big-event' ) ) :

    	$font_families = array();
    	$font_families[] = 'Poppins';

    	// Checking Body Font
    	if( ! empty( $be_font_body_family ) ) :
    		$font_families[] = $be_font_body_family . ':400,500,600,700,900';
    	endif;

    	// Checking Title Font
    	if( ! empty( $be_title_font_family ) && ( $be_title_font_family != $be_font_body_family ) ) :
    		$font_families[] = $be_title_font_family . ':400,500,600,700,900';
    	endif;

    	// Checking Menu Font
    	if( ! empty( $be_menu_font_family ) && ( $be_menu_font_family != $be_font_body_family ) && ( $be_menu_font_family != $be_title_font_family ) ) :
    		$font_families[] = $be_menu_font_family . ':400,500,600,700,900';
    	endif;

    	$query_args = implode( '|', $font_families );
    	$font_url = add_query_arg( 'family', urlencode( '' . $query_args . '&subset=latin,latin-ext' ), '//fonts.googleapis.com/css' );

    endif;
    return $font_url;
}


function big_event_extra_font_load() {
	wp_enqueue_style( 'big-event-extra-fonts-load', big_event_fonts_url_load(), array(), null );
}

if( function_exists( 'cs_get_option' ) ) :
	add_action( 'wp_enqueue_scripts', 'big_event_extra_font_load', 90 );
else :
	add_action( 'wp_enqueue_scripts', 'big_event_default_font_load', 90 );
endif;


/**
 * Enqueue scripts and styles.
 */
function big_event_scripts() {
	/**
	 * Enqueue styles.
	 */
	wp_enqueue_style( 'big-event-style', get_stylesheet_uri() );
	wp_enqueue_style( 'bootstrap', BIGEVENT_ASSETS . '/css/bootstrap.min.css', false, '3.3.7', 'all' );
	wp_enqueue_style( 'font-awesome', BIGEVENT_ASSETS . '/css/font-awesome.min.css', false, '4.7.0', 'all' );
	wp_enqueue_style( 'flaticon', BIGEVENT_ASSETS . '/flaticon/flaticon.css', false, '1.0.0', 'all' );
	wp_enqueue_style( 'swiper', BIGEVENT_ASSETS . '/css/swiper.min.css', false, '3.4.1', 'all' );
	wp_enqueue_style( 'lightcase', BIGEVENT_ASSETS . '/css/lightcase.css', false, '2.3.6', 'all' );
	wp_enqueue_style( 'quick-view', BIGEVENT_ASSETS . '/css/quick-view.css', false, '1.0.0', 'all' );
	wp_enqueue_style( 'nstSlider', BIGEVENT_ASSETS . '/css/jquery.nstSlider.css', false, '1.0.0', 'all' );
	wp_enqueue_style( 'flexslider', BIGEVENT_ASSETS . '/css/flexslider.css', false, '2.6.3', 'all' );	
	wp_enqueue_style( 'big-event-main', BIGEVENT_ASSETS . '/css/style.css', false, '1.0.0', 'all' );
	wp_enqueue_style( 'big-event-responsive', BIGEVENT_ASSETS . '/css/responsive.css', false, '1.0.0', 'all' );

	/**
	 * Enqueue scripts.
	 */
	wp_enqueue_script( 'bootstrap', BIGEVENT_ASSETS . '/js/bootstrap.min.js', array( 'jquery' ), '3.3.7', true );	
	wp_enqueue_script( 'swiper', BIGEVENT_ASSETS . '/js/swiper.jquery.min.js', array( 'jquery' ), '3.4.1', true );
	wp_enqueue_script( 'lightcase', BIGEVENT_ASSETS . '/js/lightcase.js', array( 'jquery' ), '2.3.6', true );	
	wp_enqueue_script( 'circle-progress', BIGEVENT_ASSETS . '/js/circle-progress.min.js', array( 'jquery' ), '1.2.1', true );
	wp_enqueue_script( 'circle-progress-functions', BIGEVENT_ASSETS . '/js/circle-progress-functions.js', array( 'jquery' ), '1.0.0', true );
	wp_enqueue_script( 'modernizr', BIGEVENT_ASSETS . '/js/modernizr.js', array( 'jquery' ), '2.8.3', true );
	wp_enqueue_script( 'velocity', BIGEVENT_ASSETS . '/js/velocity.min.js', array( 'jquery' ), '1.0.0', true );
	wp_enqueue_script( 'quick-view', BIGEVENT_ASSETS . '/js/quick-view.js', array( 'jquery' ), '1.0.0', true );
	wp_enqueue_script( 'nstSlider', BIGEVENT_ASSETS . '/js/jquery.nstSlider.js', array( 'jquery' ), '1.0.0', true );
	wp_enqueue_script( 'nstfunctions', BIGEVENT_ASSETS . '/js/nstfunctions.js', array( 'jquery' ), '1.0.0', true );
	wp_enqueue_script( 'flexslider', BIGEVENT_ASSETS . '/js/flexslider-min.js', array( 'jquery' ), '2.6.3', true );
	wp_enqueue_script( 'flexfunctions', BIGEVENT_ASSETS . '/js/flexfunctions.js', array( 'jquery' ), '1.0.0', true );
	wp_enqueue_script( 'directional-hover', BIGEVENT_ASSETS . '/js/directional-hover.js', array( 'jquery' ), '1.0.0', true );
	wp_enqueue_script( 'jquery-easing', BIGEVENT_ASSETS . '/js/jquery.easing.min.js', array( 'jquery' ), '1.3.0', true );
    wp_enqueue_script( 'countdown', BIGEVENT_ASSETS . '/js/jquery.countdown.min.js', array( 'jquery' ), '1.0.1', true );
	wp_enqueue_script( 'big-event-custom', BIGEVENT_ASSETS . '/js/custom.js', array( 'jquery' ), '1.0.0', true );

	wp_enqueue_script( 'big-event-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20151215', true );
	wp_enqueue_script( 'big-event-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20151215', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'big_event_scripts', 90 );


/**
 * Big Event Custom Styles
 */

if( ! function_exists( 'big_event_custom_styles' ) ) :
	function big_event_custom_styles() {
		if( function_exists( 'cs_get_option' ) ) :
		$be_body_font 				= cs_get_option( 'be_body_font_family' );
		$be_font_body_family 		= $be_body_font['family'];
		$be_body_font_size 			= cs_get_option( 'be_body_font_size' );

		$be_title_font 				= cs_get_option( 'be_title_font_family' );
		$be_title_font_family 		= $be_title_font['family'];
		$be_title_font_style		= cs_get_option( 'be_title_font_style' );
		$be_title_text_transform		= cs_get_option( 'be_title_text_transform' );

		$be_menu_font 				= cs_get_option( 'be_menu_font_family' );
		$be_menu_font_family 		= $be_menu_font['family'];
		$be_menu_font_style			= cs_get_option( 'be_menu_font_style' );
		$be_menu_text_transform		= cs_get_option( 'be_menu_text_transform' );

	    $be_custom_page_options     = get_post_meta( get_the_ID(), '_be_custom_page_options', true );
	    $be_custom_page_settings    = isset( $be_custom_page_options['be_custom_page_settings'] ) ? $be_custom_page_options['be_custom_page_settings'] : '';

	    if( is_page() && $be_custom_page_settings == true ) :
	        $be_transparent_menu_bg     = isset( $be_custom_page_options['be_transparent_menu_bg'] ) ? $be_custom_page_options['be_transparent_menu_bg'] : '';
	        $be_theme_color   = isset( $be_custom_page_options['be_menu_background_color'] ) ? $be_custom_page_options['be_menu_background_color'] : '';
	        $be_secondary_color   = isset( $be_custom_page_options['be_secondary_color'] ) ? $be_custom_page_options['be_secondary_color'] : '';
	    else :

	    	$be_transparent_menu_bg     = cs_get_option( 'be_transparent_menu_bg' );
			$be_theme_color   = cs_get_option( 'be_menu_background_color' );
			$be_secondary_color   = cs_get_option( 'be_secondary_color' );
		endif;

    endif;

	    wp_enqueue_style(
	        'custom-style', get_template_directory_uri() . '/assets/css/custom-style.css'
	    );

		$custom_css = "
			body,button,input,select,textarea,code,kbd,tt,var,samp,pre,button,button[disabled]:hover,button[disabled]:focus,input[type='button'],input[type='button'][disabled]:hover,input[type='button'][disabled]:focus,input[type='reset'],input[type='reset'][disabled]:hover,input[type='reset'][disabled]:focus,input[type='submit'],input[type='submit'][disabled]:hover,input[type='submit'][disabled]:focus {
				font-family: {$be_font_body_family};
			}
			body {
				font-size: {$be_body_font_size}px;
			}
			h1,h2,h3,h4,h5,h6 {
				font-family: {$be_title_font_family};
				font-style: {$be_title_font_style};
                text-transform: {$be_title_text_transform}
			}
			header .main-menu ul li a {
				font-family: {$be_menu_font_family};
				font-style: {$be_menu_font_style};
				text-transform: {$be_menu_text_transform}
			}
		    .main-menu.menu-fixed,.mobile-menu-area,header .main-menu.transparent-menu .menu-button,header .main-menu.transparent-menu .menu-button:hover,.main-menu .header-mini-cart .woocommerce-mini-cart__buttons .wc-forward, .main-menu .header-mini-cart .woocommerce-mini-cart__buttons .wc-forward,.main-menu.transparent-menu .header-mini-cart .woocommerce-mini-cart__buttons .wc-forward, .main-menu .header-mini-cart .woocommerce-mini-cart__buttons .wc-forward:hover,.pagination-area .page-numbers li span,.page-numbers li a:hover ,.pricing.pricing-uhv .col-md-4 .pricing-item .pricing-header,.pricing.pricing-uhv .pricing-item:hover .pricing-button > a,.schedules-3.schedules-uhv .nav-tabs,.schedules-3.schedules-uhv .nav-tabs li a,.dark-overlay-left::after,.dark-layout .banner-seven-content .content h3,.dark-layout .banner-seven-content .event-info li,.dark-price.pricing .pricing-item .pricing-header .amount,.speakers-nine .speaker-item:hover .speaker-image,.home-blog-two .content > a,#scroll-top .newsletter, #scroll-top .newsletter form input:first-child,.esc-item .section-time p,.esc-item.right::before,.esc-item.left::before,.schedules .nav-tabs li a:hover,.schedules .nav-tabs li.active a:active,.schedules .nav-tabs li a:focus,.schedules .tab-content table th,.banner.banner-five .content-left::before,.banner.banner-five .content-right .clock-item span,.speakers-eleven .speaker-item:hover,.schedules-5 .nav-tabs li.active a,.banner-eleven .content-right .clock-item span,.pricing-eight .pricing-item:hover,.home-blog-eight .blog-item:hover,.get-touch .register-form input[type='submit'],.schedules-2.schedules-uhv .nav-tabs li a,.schedules-2.schedules-uhv .nav-tabs,.schedules.schedules-uhv .nav-tabs,.banner .content-right .default-button,.schedules .nav-tabs li.active a,.schedules-two .nav-tabs li a:before,.speakers-five .speaker-content,.speakers-seven .speaker-overlay,.speakers-six .speaker-content,.banner .content-left::before,.banner .content-right .clock-item span,.speakers .speaker-item .speaker-content .details,.pricing .col-md-4:nth-child(3) .pricing-item .pricing-header,.pricing .col-md-4:nth-child(6) .pricing-item .pricing-header,.pricing .col-md-4:nth-child(9) .pricing-item .pricing-header,.pricing .col-md-4:nth-child(3) .pricing-item .pricing-options p span,.pricing .col-md-4:nth-child(6) .pricing-item .pricing-options p span,.pricing .col-md-4:nth-child(9) .pricing-item .pricing-options p span,.speakers.speakers-two .speaker-item .speaker-content .icon,.pricing-two .col-md-4:nth-child(3) .pricing-item .pricing-button,.pricing-two .col-md-4:nth-child(6) .pricing-item .pricing-button,.pricing-two .col-md-4:nth-child(9) .pricing-item .pricing-button,.banner-three form .banner-submit,.pricing.pricing-uhv .col-md-4 .pricing-item:hover .pricing-button a,.schedules-17 .large-image,.schedules-17 .modal-content .close:after,.schedules-two .tab-content table tbody tr:hover,.pricing.pricing-eight .col-md-4 .pricing-item .pricing-options p span,.product .pro-button a:hover,.schedules-15 .col-md-4 .schedule-item .schedule-item-head,.fs-thumb .fs-date,.uc-show-list .uc-show-item .uc-show-content .uc-show-date,.uc-show-list .uc-show-item .uc-show-button a.custom-btn,.uc-event-live-info-section .button-group a.ticket,.uc-event-live-info-section .button-group a.details:hover,.speakers-eleven.seccolor .speaker-item:hover,.header-style-9,header .main-menu .menuV9 .menu_cart > span,.ticket-section .festival-button,.event-date,.footer-section,header.header-style-9 .main-menu,.banner-content .search-box{
		        background-color: {$be_theme_color};
		    }
		    .main-menu.menu-fixed.transparent-menu {
		        background: {$be_transparent_menu_bg};
		    }
		    .main-menu.menu-fixed.menu-background-bg {
		        background: {$be_theme_color};
		    }
		    .main-menu.menu-fixed #bs-example-navbar-collapse-1 #menu-primary-menu li ul.dropdown-menu,.navbar-right .dropdown-menu {
		        background: {$be_theme_color};
		    }
		    .newsletter,
		    .newsletter form input:first-child {
		    	background: {$be_theme_color};
		    }
		    a:focus,a:hover,.newsletter form input:last-child,.newsletter form input:first-child,.countdown-box .countdown .clock-item .count-number,.schedules-4 .schedule-item .schedule-heading .speaker-name h6,.schedule-content .venue,.page-numbers li a,.speakers.speakers-eight .speaker-item .speaker-content h4 a:hover,.schedules-2.schedules-uhv .nav-tabs li.active a,.schedule-list .schedule-heading .hall,.home-blog-six .blog-item .content h4 a:hover, .home-blog-six .blog-item .content h4 a:focus,.dark-layout .banner-seven-content .content ul li span,.dark-price.pricing .pricing-item .pricing-header .name,.post-meta li a:hover, .post-meta li a:focus,.speakers-nine .speaker-content .name a:hover,.home-blog-two .post-meta li:first-child a span,.banner-ten .content-left h2,.banner-ten .content-left ul li i,.dark-layout .play,.speakers-ten .speaker-item:hover .speaker-content h4 a,.banner-ten .content-right h2,.dark-layout .schedules-3.schedules-uhv .nav-tabs li.active a,.schedules-5 .nav-tabs li a,.banner-eleven .content-left .day-counter .counter,.banner-eleven .content-left .day-counter .years,.pricing-eight .pricing-item .pricing-header .amount, .pricing-eight .pricing-item .pricing-header .name,header .main-menu ul li ul li > a:hover, header .main-menu ul li ul li > a:focus, header .main-menu ul li ul li.active > a, header .main-menu ul li ul li.active > a:hover,.main-menu ul.dropdown-menu li.current-menu-ancestor > a,.speakers-three .speaker-item:hover .speaker-content h4 a,.schedules .nav-tabs li a,.schedules-17 .nav-tabs li.active a,.speakers .speaker-item .speaker-content .icon,.pricing .col-md-4:nth-child(3) .pricing-item .pricing-button a,
.pricing .col-md-4:nth-child(6) .pricing-item .pricing-button a, .pricing .col-md-4:nth-child(9) .pricing-item .pricing-button a,.pricing.pricing-uhv .col-md-4 .pricing-item .pricing-button a,.banner-six .banner-six-left p,.banner-nine a,.schedules-seven .tab-content table th,.schedules-seven .tab-content table td:hover,.schedules.schedules-uhv.schedules-17  .nav-tabs li.active a,.schedules .tab-content table td:hover,.schedules-six .tab-content table td:nth-child(1) span,.product .product-header .icon .grid-active, .product .product-header .icon span:hover, .product .product-header .icon .grid-active, .product .product-header .icon .list-active,.fs-content h5 > a:hover,.uc-event-live-info-section .countdown .clock-item .count-number,.event-single .tabs-menu li a:hover, .event-single .tabs-menu li.active a:focus, .event-single .tabs-menu li.active a,.ticket-section .ticket-item h2,.ticket-section .ticket-item-list li i,header .main-menu .menuV9 ul.navbar-nav li ul li > a:hover,.time-location li span,.organizer-intro .organizer-name,.ticket-price,header .main-menu .menuV9 ul.navbar-nav li ul li.active > a,.breadcrumb li span{
		    	color: {$be_theme_color};
		    }
            .pagination-area .page-numbers li span,.page-numbers li a, .page-numbers li span,.page-numbers li a:hover ,.pricing.pricing-uhv .pricing-item:hover .pricing-button > a,.pricing.pricing-uhv .pricing-item .pricing-button a,.schedules .nav-tabs li a:hover, .schedules .nav-tabs li a:focus,.schedules .nav-tabs li:last-child.active a,.schedules .nav-tabs li.active a,.product .pro-button a,.product .pro-button a:hover,.uc-event-live-info-section .button-group a.details:hover{
                border-color: {$be_theme_color};
            }
            .speakers.speakers-eight.newyear .speaker-image:after,.speakers.speakers-eight .speaker-image:after {
                border-color: {$be_theme_color} transparent;
            }
            .esc-item.right .section-time p::after {
                border-left: 8px solid {$be_theme_color};
            }
            .esc-item.left .section-time p::after{
                border-right: 8px solid {$be_theme_color};
            }
            .pricing-two .col-md-4:nth-child(3) .pricing-item .pricing-options,
            .pricing-two .col-md-4:nth-child(6) .pricing-item .pricing-options,
            .pricing-two .col-md-4:nth-child(9) .pricing-item .pricing-options {
                border-left: 10px solid {$be_theme_color};
                border-right: 10px solid {$be_theme_color};
            }
            .fs-content .custom-btn,.uc-event-live-info-section .button-group a.ticket {
                border: 2px solid {$be_theme_color};
            }
            
            .speakers-eleven.seccolor .speaker-item,.header-3 .newsletter,.events-type-list li a:hover, .events-type-list li a:focus, .events-type-list li a:active,.events-type-list li.active a,.event-item .event-date-inner,.ticket-section .col-ticket:nth-child(2) .festival-button, .ticket-section .col-ticket:nth-child(3) .festival-button,.event-date-inner span::after,.banner-content .search-box form .search-submit{
                background-color: {$be_secondary_color};
            }
            .header .main-menu .menuV9 .menu_cart > span,.banner-search .content h1,.ticket-section .col-ticket:nth-child(2) .ticket-item h2, .ticket-section .col-ticket:nth-child(3) .ticket-item h2,.ticket-section .col-ticket:nth-child(2) .ticket-item-list li i, .ticket-section .col-ticket:nth-child(3) .ticket-item-list li i,.quote-icon,.member-content h4,.newsletter form input:last-child, .newsletter form input:first-child,.newsletter form input:last-child, .footer-2 .newsletter form input:first-child,.header-top-right a span, .header-top-right a span:hover,.header-top-left p span{
                color: {$be_secondary_color};
            }
            .member-thumb-inner,.quote-icon{
                border-color: {$be_secondary_color}; 
            }
		";

		wp_add_inline_style( 'custom-style', $custom_css );
	}
endif;





/**
 * Google Map
 */
if( ! function_exists( 'big_event_gmap_init' ) ) :
	function big_event_gmap_init() {
		$gmap_api = cs_get_option( 'be_google_map_api' );
		wp_enqueue_script( 'map-custom', BIGEVENT_ASSETS . '/js/map-custom.js', array( 'jquery' ), '1.0.0', true );
		wp_enqueue_script( 'map-custom-travel', BIGEVENT_ASSETS . '/js/map-custom-travel.js', array( 'jquery' ), '1.0.0', true );
		if( ! empty( $gmap_api ) ) :
			wp_enqueue_script( 'gmaps-api', 'https://maps.google.com/maps/api/js?key='.$gmap_api, null, null, true );
		endif;
	}
endif;

/**
 * banner six slider
 */
function big_event_bg_slider(){
    if( function_exists( 'cs_get_option' ) ) :
        $be_custom_page_options     = get_post_meta( get_the_ID(), '_be_custom_page_options', true );
        $be_banner_slider           = isset( $be_custom_page_options['be_banner_slider'] ) ? $be_custom_page_options['be_banner_slider'] : '';
        $be_sliders = explode( ',', $be_banner_slider );
        $sliders = array();
        foreach($be_sliders as $slider):
            $slider_attachment = wp_get_attachment_image_src( $slider, 'full' );
            $sliders[] = array(
                'src'        => $slider_attachment[0],
            );
        endforeach;
        return $sliders;
    endif; 
}

if( function_exists( 'cs_get_option' ) ) :
    add_action( 'wp_enqueue_scripts', 'big_event_custom_styles', 90 );
    add_action( 'wp_enqueue_scripts', 'big_event_gmap_init', 90 );   

    $be_custom_page_options     = get_post_meta( get_the_ID(), '_be_custom_page_options', true ); 
    $be_is_banner           = isset( $be_custom_page_options['be_is_banner'] ) ? $be_custom_page_options['be_is_banner'] : '';
    if(is_page()):        
        $be_banner_style           = isset( $be_custom_page_options['be_banner_style'] ) ? $be_custom_page_options['be_banner_style'] : ''; 
        if($be_is_banner == 1 && ($be_banner_style == 4 || $be_banner_style == 5 || $be_banner_style == 6 || $be_banner_style == 11)):
            wp_enqueue_style( 'vegas', BIGEVENT_ASSETS . '/css/vegas.css', false, '2.4.0', 'all' );
            wp_enqueue_script( 'vegas', BIGEVENT_ASSETS . '/js/vegas.js', array( 'jquery' ), '2.4.0', true );
            wp_enqueue_script( 'big-event-vegas-slides', BIGEVENT_ASSETS . '/js/vegas-slides.js', array( 'jquery' ), '2.4.0', true );
            wp_localize_script('big-event-vegas-slides', 'slides', array(       
                'vegas_slider' => json_encode(big_event_bg_slider()),               
            ));
        endif;        
    endif;
        
endif;