<?php
/**
 * Big Event Google Map Shortcode
 *
 * Visual Composer of Google Map
 *
 * @package big-event
 * @author CodexCoder
 * @since 2.0.0
 * @version 1.0.0
 */

if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_video_image_gallery extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'bgimage'		=> '',
			'overlay'		=> '',
			'title'         => '',
			'subtitle'		=> '',
			'isvideo'		=> 'yes',
			'video_tab_icon' => '',
			'video_play_icon' => '',
			'event_videos'	=> '',
			'isimage'		=> 'yes',
			'image_tab_icon'=> '',
			'event_images'	=> '',
			'be_class'		=> ''
		), $atts ) );
		$event_videos 	= ( array ) vc_param_group_parse_atts( $event_videos );
		$event_images 	= ( array ) vc_param_group_parse_atts( $event_images );
		ob_start();
			big_event_video_image_gallery( $bgimage, $overlay, $title, $subtitle, $isvideo, $video_tab_icon, $video_play_icon, $event_videos, $isimage, $image_tab_icon, $event_images, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'		=> esc_html__( 'Video and Image Gallery Tab', 'big-event' ),
	'base'		=> 'big_event_video_image_gallery',
	'class'		=> '',
	'category'	=> esc_html__( 'Big Event', 'big-event' ),
	'params'	=> array(
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Background Image', 'big-event' ),
			'param_name'	=> 'bgimage',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
        array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html( 'Overlay Color', 'big-event' ),
			'param_name'	=> 'overlay',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'subtitle',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
        array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Is Video Gallery?', 'big-event' ),
			'param_name'	=> 'isvideo',
			'value'			=> array(
				esc_html__( 'Select a Option', 'big-event' )	=> '',
				esc_html__( 'Yes', 'big-event' )	=> 'yes',
				esc_html__( 'No', 'big-event' )		=> 'no'
			),
            'std'	=> 'yes',
			'group'			=> esc_html__( 'Video Gallery', 'big-event' ),
		),
        array(
            'type'			=> 'attach_image',
            'heading'		=> esc_html__( 'Tab Icon', 'big-event' ),
            'param_name'	=> 'video_tab_icon',
            'group'			=> esc_html__( 'Video Gallery', 'big-event' ),
        ),
        array(
            'type'			=> 'attach_image',
            'heading'		=> esc_html__( 'Play Icon', 'big-event' ),
            'param_name'	=> 'video_play_icon',
            'group'			=> esc_html__( 'Video Gallery', 'big-event' ),
        ),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Video Gallery', 'big-event' ),
			'param_name'	=> 'event_videos',
			'group'			=> esc_html__( 'Video Gallery', 'big-event' ),
			'description'	=> esc_html__( 'Recommended size for first image is 770*400', 'big-event' ),
			'params'		=> array(
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Image', 'big-event' ),
					'param_name'	=> 'image'
				),
				array(
					'type'			=> 'textfield',
					'heading'		=> esc_html__( 'Embed URL', 'big-event' ),
					'param_name'	=> 'url'
				),
			)
		),
        
        array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Is Image Gallery?', 'big-event' ),
			'param_name'	=> 'isimage',
			'value'			=> array(
				esc_html__( 'Select a Option', 'big-event' )	=> '',
				esc_html__( 'Yes', 'big-event' )	=> 'yes',
				esc_html__( 'No', 'big-event' )		=> 'no'
			),
            'std'	=> 'yes',
			'group'			=> esc_html__( 'Image Gallery', 'big-event' ),
		),
        array(
            'type'			=> 'attach_image',
            'heading'		=> esc_html__( 'Tab Icon', 'big-event' ),
            'param_name'	=> 'image_tab_icon',
            'group'			=> esc_html__( 'Image Gallery', 'big-event' ),
        ),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Image Gallery', 'big-event' ),
			'param_name'	=> 'event_images',
			'group'			=> esc_html__( 'Image Gallery', 'big-event' ),
            'description'	=> esc_html__( 'Recommended size for second image is 770*400', 'big-event' ),
			'params'		=> array(
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Image', 'big-event' ),
					'param_name'	=> 'image'
				)
			)
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class Name', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' )
		)
	)
) );
endif;

function big_event_video_image_gallery( $bgimage, $overlay, $title, $subtitle, $isvideo, $video_tab_icon, $video_play_icon, $event_videos, $isimage, $image_tab_icon, $event_images, $be_class ) {
	$bgimageurl = wp_get_attachment_url( $bgimage, 'full' );
	$video_tab_icon_url 	= wp_get_attachment_url( $video_tab_icon );
    $video_play_icon_url 	= wp_get_attachment_url( $video_play_icon );
    $video_play_icon_alt = get_post_meta( $video_play_icon, '_wp_attachment_image_alt', true);
	$image_tab_icon_url 	= wp_get_attachment_url( $image_tab_icon );
	
    
    
    $section_attribute[] = 'class="gallery-section video-image-gallery"';
    if(!empty($bgimage)):
        $section_attribute[] = 'style="background-image: url('.esc_attr($bgimageurl).')"';
    endif;
    
    $overlay_classes = array(
        'overlay',
        'padding-120'
    );
    if(!empty($be_class)):
        $overlay_classes[] = $be_class;
    endif;
    $overlay_class = implode( ' ', $overlay_classes );
    $overlay_attribute = array();
    $overlay_attribute[] = 'class="' . esc_attr( $overlay_class ) . '"';
    if(!empty($overlay)):
        $overlay_attribute[] = 'style="background-color: '.esc_attr($overlay).'"';
    endif; 
    
    if( $isvideo == 'yes' && $isimage == 'yes' ) :
        $videotabclass = 'tab-pane active';
        $imagetabclass = 'tab-pane';
    elseif($isvideo == 'yes' && $isimage != 'yes'):
        $videotabclass = 'tab-pane active';
        $imagetabclass = 'tab-pane';
    elseif($isvideo != 'yes' && $isimage == 'yes'):
        $videotabclass = 'tab-pane';
        $imagetabclass = 'tab-pane active';
    else:
        
    endif;
	?>
    <div <?php echo implode( ' ', $section_attribute ) ?>>
        <div <?php echo implode( ' ', $overlay_attribute ) ?>>
            <div class="container">
                <div class="row">
                    <?php if( ! empty( $title ) || ! empty( $subtitle ) ) : ?>
                    <div class="section-header text-center">
                        <?php
                        if( ! empty( $title ) ) :
                            echo '<h3>' . esc_html( $title ) . '</h3>';
                        endif;

                        if( ! empty( $subtitle ) ) :
                            echo '<p><em>' . esc_html( $subtitle ) . '</em></p>';
                        endif; 
                        ?>
                    </div>
                    <?php endif; ?>
                    <div class="section-wrapper">
                        <div class="gallery-tab-option">
                            <!-- Nav tabs -->
                            <?php if( $isvideo == 'yes' && $isimage == 'yes' ) : ?>
                            <ul class="tabs-menu" role="tablist">
                                <?php if( $isvideo == 'yes' ) : ?>
                                <li role="presentation" class="active"><a href="#gallery-video" aria-controls="gallery-video" role="tab" data-toggle="tab">
                                        <?php 
                                        if($video_tab_icon) :
                                            echo '<img src="'.esc_url($video_tab_icon_url).'" alt="">';
                                        else:
                                            echo esc_html('Video','big-event');
                                        endif;
                                        ?>                                        
                                    </a>
                                </li>
                                <?php endif; ?>
                                <?php if( $isimage == 'yes' ) : ?>
                                <li role="presentation"><a href="#gallery-image" aria-controls="gallery-image" role="tab" data-toggle="tab">
                                        <?php 
                                        if($image_tab_icon) :
                                            echo '<img src="'.esc_url($image_tab_icon_url).'" alt="">';
                                        else:
                                            echo esc_html('Image','big-event');
                                        endif;
                                        ?>
                                    </a>
                                </li>
                                <?php endif; ?>
                            </ul>
                            <?php endif; ?>

                            <!-- Tab panes -->
                            <div class="tab-content row">
                                <?php if( $isvideo == 'yes' ) : ?>
                                <div role="tabpanel" class="<?php echo esc_attr($videotabclass) ?>" id="gallery-video">
                                    <div class="gallery-container">
                                        <?php 
                                        $i = 0;
                                        foreach ($event_videos as $video) : $i++;
                                        if(!empty($video['image'])) :
                                        $videoimagefull = wp_get_attachment_url( $video['image'], 'full' );
                                        $videoimage_alt = get_post_meta( $video['image'], '_wp_attachment_image_alt', true);
                                        $videourl = isset($video['url']) ? $video['url'] : $videoimagefull;
                                        if($i == 1) {
                                            $colclass = 'col-md-8';
                                            $videoimageurl = $videoimagefull;
                                        } else {
                                            $colclass = 'col-md-4';
                                            $videoimageurl = wp_get_attachment_url( $video['image'], 'big-event-370-400' );
                                        }
                                        
                                        ?>
                                        <div class="<?php echo esc_attr($colclass) ?>">
                                            <div class="gallery-thumb">
                                                <a data-rel="lightcase" href="<?php echo esc_url($videourl); ?>"><img src="<?php echo esc_url($videoimageurl); ?>" alt="<?php echo esc_attr($videoimage_alt); ?>"></a>
                                                <?php if(!empty($videourl)): ?>
                                                <a class="play-icon" data-rel="lightcase" href="<?php echo esc_url($videourl); ?>"><img src="<?php echo esc_url($video_play_icon_url); ?>" alt="<?php echo esc_attr($video_play_icon_alt); ?>"></a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <?php endif; endforeach; ?>                                        
                                    </div>
                                </div>
                                <?php endif; ?> 
                                <?php if( $isimage == 'yes' ) : ?>
                                <div role="tabpanel" class="<?php echo esc_attr($imagetabclass) ?>" id="gallery-image">
                                    <div class="gallery-container">
                                        <?php 
                                        $j = 0;
                                        foreach ($event_images as $image) : $j++;
                                        if(!empty($image['image'])) :
                                        $imagefull = wp_get_attachment_url( $image['image'], 'full' );
                                        $image_alt = get_post_meta( $image['image'], '_wp_attachment_image_alt', true);
                                        if($j == 2) {
                                            $colclass = 'col-md-8';
                                            $imageurl = wp_get_attachment_url( $image['image'], 'full' );
                                        } else {
                                            $colclass = 'col-md-4';
                                            $imageurl = wp_get_attachment_url( $image['image'], 'big-event-370-400' );
                                        }
                                        ?>
                                        <div class="<?php echo esc_attr($colclass) ?>">
                                            <div class="gallery-thumb">
                                                <a data-rel="lightcase" href="<?php echo esc_url($imagefull); ?>"><img src="<?php echo esc_url($imageurl); ?>" alt="<?php echo esc_attr($image_alt); ?>"></a>
                                            </div>
                                        </div>
                                        <?php endif; endforeach; ?>   
                                    </div>
                                </div>
                                <?php endif; ?> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
	<?php
}

