<?php
/**
 * Big Event Google Map Shortcode
 *
 * Visual Composer of Google Map
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_video_embed extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'bg_image'		=> '',
			'video_icon'	=> '',
			'video_link'	=> '',
			'be_class'		=> ''
		), $atts ) );
		ob_start();
			big_event_video_embed( $bg_image, $video_icon, $video_link, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'		=> esc_html__( 'Video Embed', 'big-event' ),
	'base'		=> 'big_event_video_embed',
	'class'		=> '',
	'category'	=> esc_html__( 'Big Event', 'big-event' ),
	'params'	=> array(
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Background Image', 'big-event' ),
			'param_name'	=> 'bg_image',
			'group'			=> esc_html__( 'Video Embed', 'big-event' )
		),
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Video Icon', 'big-event' ),
			'param_name'	=> 'video_icon',
			'group'			=> esc_html__( 'Video Embed', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Video Link', 'big-event' ),
			'param_name'	=> 'video_link',
			'group'			=> esc_html__( 'Video Embed', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class Name', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' )
		)
	)
) );
endif;