<?php
/**
 * big-event Campaign and Programs
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 2.0.0
 * @version 1.0.0
 */

if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_upcoming_event extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'titleleft'		=> '',
			'countdown'		=> '',
			'timeoffset'	=> '',
			'titleright'	=> '',
			'calendericon'	=> '',
			'date'          => '',			
			'month'         => '',			
			'addressicon'	=> '',			
			'address1'		=> '',			
			'address2'		=> '',			
			'btn1text'		=> 'Buy Ticker',			
			'btn1url'		=> '#',			
			'btn2text'		=> 'View Detail',			
			'btn2url'		=> '#',					
			'bgimage'		=> '',
			'overlay'		=> '',
			'be_class'		=> ''
		), $atts ) );
		ob_start();
        big_event_upcoming_event( $titleleft, $countdown, $timeoffset, $titleright, $calendericon, $date, $month, $addressicon, $address1, $address2,$btn1text, $btn1url, $btn2text, $btn2url, $bgimage, $overlay, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Upcoming Event Countdown', 'big-event' ),
	'base'			=> 'big_event_upcoming_event',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
        
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title Left', 'big-event' ),
			'param_name'	=> 'titleleft',
			'group'			=> esc_html__( 'Left Col', 'big-event' )
		),
        array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Countdown Date', 'big-event' ),
			'param_name'	=> 'countdown',
			'description'	=> esc_html__( 'Date Format: mm/dd/yyyy 17:00:00', 'big-event' ),
			'group'			=> esc_html__( 'Left Col', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Time Offset', 'big-event' ),
			'param_name'	=> 'timeoffset',
			'group'			=> esc_html__( 'Left Col', 'big-event' )
		),        
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title Right', 'big-event' ),
			'param_name'	=> 'titleright',
			'group'			=> esc_html__( 'Right Col', 'big-event' )
		),        
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Calender Icon', 'big-event' ),
			'param_name'	=> 'calendericon',
			'group'			=> esc_html__( 'Right Col', 'big-event' )
		),
        array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Date', 'big-event' ),
			'param_name'	=> 'date',
			'group'			=> esc_html__( 'Right Col', 'big-event' )
		),
        array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Month', 'big-event' ),
			'param_name'	=> 'month',
			'group'			=> esc_html__( 'Right Col', 'big-event' )
		),
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Address Icon', 'big-event' ),
			'param_name'	=> 'addressicon',
			'group'			=> esc_html__( 'Right Col', 'big-event' )
		),
        array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Address 1', 'big-event' ),
			'param_name'	=> 'address1',
			'group'			=> esc_html__( 'Right Col', 'big-event' )
		),
        array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Address 2', 'big-event' ),
			'param_name'	=> 'address2',
			'group'			=> esc_html__( 'Right Col', 'big-event' )
		),
        array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Button 1 Text', 'big-event' ),
			'param_name'	=> 'btn1text',
			'std'           => 'Buy Ticket',
			'group'			=> esc_html__( 'Right Col', 'big-event' )
		),
        array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Button 1 URL', 'big-event' ),
			'param_name'	=> 'btn1url',
            'std'           => '#',
			'group'			=> esc_html__( 'Right Col', 'big-event' )
		),
        array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Button 2 Text', 'big-event' ),
			'param_name'	=> 'btn2text',
            'std'           => 'View Detail',
			'group'			=> esc_html__( 'Right Col', 'big-event' )
		),
        array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Button 2 URL', 'big-event' ),
			'param_name'	=> 'btn2url',
            'std'           => '#',
			'group'			=> esc_html__( 'Right Col', 'big-event' )
		),
        array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Background Image', 'big-event' ),
			'param_name'	=> 'bgimage',
			'group'			=> esc_html__( 'Style', 'big-event' )
		),
        array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html( 'Overlay Color', 'big-event' ),
			'param_name'	=> 'overlay',
			'group'			=> esc_html__( 'Style', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' ),
			'group'			=> esc_html__( 'Style', 'big-event' )
		)
	)
) );
endif;
function big_event_upcoming_event( $titleleft, $countdown, $timeoffset, $titleright, $calendericon, $date, $month, $addressicon, $address1, $address2,$btn1text, $btn1url, $btn2text, $btn2url, $bgimage, $overlay, $be_class ) {
    $bgimageurl = wp_get_attachment_url( $bgimage, 'full' );
    $ci_url = wp_get_attachment_url( $calendericon, 'full' );
    $ci_alt = get_post_meta( $calendericon, '_wp_attachment_image_alt', true);
    $adi_url = wp_get_attachment_url( $addressicon, 'full' );
    $adi_alt = get_post_meta( $addressicon, '_wp_attachment_image_alt', true);
    
    $section_attribute[] = 'class="uc-event-live-info-section"';
    if(!empty($bgimage)):
        $section_attribute[] = 'style="background-image: url('.esc_attr($bgimageurl).')"';
    endif;
    
    $overlay_classes = array(
        'overlay'
    );
    if(!empty($be_class)):
        $overlay_classes[] = $be_class;
    endif;
    $overlay_class = implode( ' ', $overlay_classes );
    $overlay_attribute = array();
    $overlay_attribute[] = 'class="' . esc_attr( $overlay_class ) . '"';
    if(!empty($overlay)):
        $overlay_attribute[] = 'style="background-color: '.esc_attr($overlay).'"';
    endif; 
    ?>
    <div <?php echo implode( ' ', $section_attribute ) ?>>
        <div <?php echo implode( ' ', $overlay_attribute ) ?>>
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <?php if( ! empty( $titleleft ) ) : ?>
                        <div class="section-header">
                            <h3><?php echo esc_html($titleleft) ?></h3>
                        </div>
                        <?php endif; ?>
                        <div class="section-wrapper1">
                            <div class="event-countdown">
                                <?php if( ! empty( $countdown ) ) : ?>
                                <ul id="upe-countdown" class="countdown upe-countdown clearfix" data-coundowntime="<?php echo esc_attr($countdown) ?>" data-day="<?php esc_html_e('Day','big-event'); ?>" data-days="<?php esc_html_e('Days','big-event'); ?>" data-hour="<?php esc_html_e('Hour','big-event'); ?>" data-hours="<?php esc_html_e('Hours','big-event'); ?>" data-minute="<?php esc_html_e('Minute','big-event'); ?>" data-minutes="<?php esc_html_e('Minutes','big-event'); ?>" data-second="<?php esc_html_e('Second','big-event'); ?>" data-seconds="<?php esc_html_e('Seconds','big-event'); ?>" data-timeoffset="<?php echo esc_attr($timeoffset) ?>" class="countdown clearfix">
                                    <li class="clock-item"><span class="count-number days"><?php esc_html_e('00','big-event') ?></span>
                                        <p class="days_text count-text"><?php esc_html_e('Days','big-event'); ?></p>
                                    </li>

                                    <li class="clock-item"><span class="count-number hours"><?php esc_html_e('00','big-event') ?></span>
                                        <p class="hours_text count-text"><?php esc_html_e('Hours','big-event'); ?></p>
                                    </li>

                                    <li class="clock-item"><span class="count-number minutes"><?php esc_html_e('00','big-event') ?></span>
                                        <p class="minutes_text count-text"><?php esc_html_e('Minutes','big-event'); ?></p>
                                    </li>

                                    <li class="clock-item"><span class="count-number seconds"><?php esc_html_e('00','big-event') ?></span>
                                        <p class="seconds_text count-text"><?php esc_html_e('Seconds','big-event'); ?></p>
                                    </li>
                                </ul>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <?php if( ! empty( $titleright ) ) : ?>
                        <div class="section-header">
                            <h3><?php echo esc_html($titleright) ?></h3>
                        </div>
                        <?php endif; ?>
                        <div class="section-wrapper1">
                            <ul class="event-date-address">
                                <li>
                                    <?php if( ! empty( $calendericon ) ) : ?>
                                    <div class="icon-image">
                                        <img src="<?php echo esc_url($ci_url) ?>" alt="<?php echo esc_attr($ci_alt) ?>">
                                    </div>
                                    <?php endif; ?>
                                    <div class="event-date-address-content">
                                        <?php 
                                        if( ! empty( $date ) ) : 
                                            echo '<span>'.esc_html($date).'</span>';
                                        endif;
                                        if( ! empty( $month ) ) : 
                                            echo '<span>'.esc_html($month).'</span>';
                                        endif;
                                        ?>
                                    </div>
                                </li>
                                <li>
                                    <?php if( ! empty( $addressicon ) ) : ?>
                                    <div class="icon-image">
                                        <img src="<?php echo esc_url($adi_url) ?>" alt="<?php echo esc_attr($adi_alt) ?>">
                                    </div>
                                    <?php endif; ?>
                                    <div class="event-date-address-content">
                                        <?php 
                                        if( ! empty( $address1 ) ) : 
                                            echo '<span>'.esc_html($address1).'</span>';
                                        endif;
                                        if( ! empty( $address2 ) ) :
                                            echo '<span>'.esc_html($address2).'</span>';
                                        endif;
                                        ?>
                                    </div>
                                </li>
                            </ul>
                            <div class="button-group">
                                <?php 
                                if (!empty($btn1text)) :
                                    echo '<a href="'.esc_url($btn1url).'" class="ticket">'.esc_html($btn1text).'</a>';
                                endif;
                                if (!empty($btn2text)) :
                                    echo '<a href="'.esc_url($btn2url).'" class="details">'.esc_html($btn2text).'</a>';
                                endif;
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php }