<?php
/**
 * Big Event Travel Info With Shortcode
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

function big_event_travel_info_with_map( $bg_color, $title, $subtitle, $travel_infos, $latitude, $longitude, $map_icon, $map_zoom, $be_class ) {
  $map_icon = wp_get_attachment_url( $map_icon );
  ?>
<!-- Travel start here -->
<section class="travel travel-six padding-120<?php echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>">
  <div class="container">

      <?php
      if( ! empty( $title ) || ! empty( $subtitle ) ) : ?>

      <div class="section-header text-center">

        <?php
        if( ! empty( $title ) ) :

          echo '<h3>' . esc_html( $title ) . '</h3>';

        endif; ?>

        <?php
        if( ! empty( $subtitle ) ) :

          echo '<p><em>' . esc_html( $subtitle ) . '</em></p>';

        endif; ?>
        
      </div>

      <?php endif; ?>
      
        <div class="row">
            <div class="col-md-6">
                <div class="travel-information">

                  <?php
                  if( ! empty( $travel_infos ) ) :

                    $i = 1;

                    foreach( $travel_infos as $travel_info ) :

                    $travel_image = wp_get_attachment_url( $travel_info['image'] );
                    $image_alt = get_post_meta( $travel_image, '_wp_attachment_image_alt', true);
                    $travel_image = isset( $travel_image ) ? $travel_image : '';

                    if( $i == 1 ) :
                      $travel = ' first';
                    elseif( $i == 2 ) :
                      $travel = ' second';
                    else :
                      $travel = ' third';
                    endif;
                    ?>

                    <div class="info-item<?php echo esc_attr( $travel ); ?>">

                      <?php
                      if( ! empty( $travel_image ) ) : ?>

                        <div class="icon">
                          <img src="<?php echo esc_url( $travel_image ); ?>" alt="<?php echo esc_attr($image_alt) ?>">
                        </div>

                      <?php else: ?>
                        
                        <div class="icon <?php echo esc_attr( $travel_info['icon'] ); ?>"></div>

                      <?php endif; ?>
                      
                      <?php
                      if( ! empty( $travel_info['heading'] ) || ! empty( $travel_info['description'] ) ) : ?>

                        <div class="details">

                          <?php
                          if( ! empty( $travel_info['heading'] ) ) :

                            echo '<h4>' . esc_html( $travel_info['heading'] ) . '</h4>';

                          endif; ?>
                          
                          <?php
                          if( ! empty( $travel_info['description'] ) ) :

                            echo '<p>' . esc_html( $travel_info['description'] ) . '</p>';

                          endif; ?>

                        </div>

                      <?php endif; ?>
                    </div><!-- info-item -->

                    <?php $i++; endforeach; ?>

                  <?php endif; ?>

                </div><!-- travel-information -->

            </div>
            <div class="col-md-6">
                <div id="map_canvas" class="travel-map" data-map-icon="<?php echo esc_url( $map_icon ); ?>" data-map-latitute="<?php echo esc_attr( $latitude ) ?>" data-map-longitude="<?php echo esc_attr( $longitude ) ?>" data-map-zoom="<?php echo esc_attr( $map_zoom ) ?>"></div><!-- travel-map -->
            </div>
        </div>
    </div><!-- container -->
</section><!-- travel -->
<!-- Travel end here -->
<?php }