<?php
/**
 * Big Event Travel With Map Info Shorcode
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_travel_info_with_map extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'bg_color'		=> '',
			'title'			=> '',
			'subtitle'		=> '',
			'travel_infos'	=> '',
			'latitude'		=> '',
			'longitude'		=> '',
			'map_icon'		=> '',
			'map_zoom'		=> '',
			'be_class'		=> ''
		), $atts ) );
		$travel_infos 	= ( array ) vc_param_group_parse_atts( $travel_infos );
		ob_start();
			big_event_travel_info_with_map( $bg_color, $title, $subtitle, $travel_infos, $latitude, $longitude, $map_icon, $map_zoom, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Travel Info With Map', 'big-event' ),
	'base'			=> 'big_event_travel_info_with_map',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
		array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Section Background', 'big-event' ),
			'param_name'	=> 'bg_color',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'subtitle',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Information', 'big-event' ),
			'param_name'	=> 'travel_infos',
			'group'			=> esc_html__( 'Travel Info', 'big-event' ),
			'params'		=> array(
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Info Image', 'big-event' ),
					'param_name'	=> 'image'
				),
				array(
					'type'			=> 'iconpicker',
					'heading'		=> esc_html__( 'Info icon', 'big-event' ),
					'param_name'	=> 'icon'
				),
				array(
					'type'			=> 'textfield',
					'heading'		=> esc_html__( 'Info Heading', 'big-event' ),
					'param_name'	=> 'heading'
				),
				array(
					'type'			=> 'textarea',
					'heading'		=> esc_html__( 'Info Description', 'big-event' ),
					'param_name'	=> 'description'
				)
			)
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Map Latitude', 'big-event' ),
			'param_name'	=> 'latitude',
			'group'			=> esc_html__( 'Map Info', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Map Longitude', 'big-event' ),
			'param_name'	=> 'longitude',
			'group'			=> esc_html__( 'Map Info', 'big-event' )
		),
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Map Icon', 'big-event' ),
			'param_name'	=> 'map_icon',
			'group'			=> esc_html__( 'Map Info', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Map Zoom', 'big-event' ),
			'param_name'	=> 'map_zoom',
			'group'			=> esc_html__( 'Map Info', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' ),
			'group'			=> esc_html__( 'Extra Class', 'big-event' )
		)
	)
) );
endif;