<?php 
/**
 * Big Event Shortcodes
 *
 * Visual Composer of Speakers Four Column
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.3.0
 * @version 1.0.0
 */

function big_event_timeline($bg_image,$sec_title,$sec_subtitle,$timeline,$el_class) {        
    $bgImage = wp_get_attachment_image_src($bg_image, "full");
?>
    <!-- schedule-eight timeline-->
    <section class="schedule-eight<?php echo ( $el_class ) ? ' ' . esc_attr($el_class) : ''; ?>" <?php if (!empty($bg_image)): ?>style="background-image: url('<?php echo esc_url($bgImage[0]) ?>')"<?php endif; ?>>
        <div class="overlay">
            <div class="container">
                <?php if (!empty($sec_title) || !empty($sec_subtitle)) : ?>
                    <div class="section-header text-center">
                        <?php
                        if (!empty($sec_title)) :
                            echo '<h3>' . esc_html($sec_title) . '</h3>';
                        endif;

                        if (!empty($sec_subtitle)) :
                            echo '<p><em>' . esc_html($sec_subtitle) . '</em></p>';
                        endif;
                        ?>            
                    </div>
                <?php endif; ?>
                <div class="section-wrapper">
                    <div class="event-schedule-timeline">
                        <?php 
                        if (!empty($timeline)):
                            $count = 0;
                            foreach ($timeline as $time): $count++;
                            if ($count % 2 == 0):
                                $class = 'left';
                            else:
                                $class = 'right';
                            endif;
                        ?> 
                        <div class="event-schedule-item">
                            <div class="esc-item <?php echo esc_attr($class) ?>">
                                <div class="esc-item-content">
                                    <div class="section-content-inner">                                        
                                        <div class="section-content">
                                            <?php                                             
                                            if (!empty($time['title'])):
                                                echo '<h4>'.esc_html($time['title']).'</h4>';
                                            endif; 
                                            if (!empty($time['description'])):
                                                echo '<p>'.esc_html($time['description']).'</p>';
                                            endif; 
                                            ?>                                             
                                        </div>
                                    </div>
                                </div>
                                <div class="section-time">
                                    <?php
                                    if (!empty($time['time'])):
                                        echo '<p>'.esc_html($time['time']).'</p>';
                                    endif; 
                                    ?>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; endif; ?>
                    </div>
                </div>
            </div>
        </div>        
    </section>
    <!-- event-schedule eight style ends here -->
<?php
}


if (function_exists('vc_map')) :
class WPBakeryShortCode_big_event_timeline extends WPBakeryShortCode {

    protected function content($atts, $content = null) {
        extract(shortcode_atts(array(
            'bg_image'      => '',
            'sec_title'     => '',
            'sec_subtitle'  => '',                        
            'timeline'      => '',            
            'el_class'      => '',                             
        ), $atts));        
    	$timeline = (array) vc_param_group_parse_atts( $timeline );
        ob_start();
        big_event_timeline($bg_image,$sec_title,$sec_subtitle,$timeline,$el_class);
        return ob_get_clean();	         
    }
}

vc_map( array(
    "base"                  => "big_event_timeline",
    "name"                  => esc_html__("Timeline", "big-event"),
    "class"                 => "",
    "category"              => esc_html__('Big Event', "big-event"),
    "params" => array(
        array(
            "type"          => "attach_image",
            "heading"       => esc_html__("Section Background Image:", "big-event"),
            "param_name"    => "bg_image",
            "description"       => esc_html__("Attach an image as background image of this section", "big-event"),
        ),
        array(
            "type"          => "textfield",
            "heading"       => esc_html__("Title:", "big-event"),
            "param_name"    => "sec_title",
        ),               
        array(
            "type"          => "textfield",
            "heading"       => esc_html__("Subtitle:", "big-event"),
            "param_name"    => "sec_subtitle",
        ),                       
        array(
            "type" => "param_group",
            "heading"    => esc_html__("Timeline:", "big-event"),
            "param_name" => "timeline",
            "group" => esc_html__("Timeline", "big-event"),
            "params" => array(
                array(
                    "type"          => "textfield",
                    "heading"       => esc_html__("Time:", "big-event"),
                    "param_name"    => "time",
                ),
                array(
                    "type"          => "textfield",
                    "heading"       => esc_html__("Title:", "big-event"),
                    "param_name"    => "title",
                ), 
                array(
                    "type"          => "textarea",
                    "heading"       => esc_html__("Description:", "big-event"),
                    "param_name"    => "description",
                ),                
            ),
        ),                                
        array(
            "type"              => "textfield",
            "heading"           => esc_html__("Extra Class Name:", "big-event"),
            "param_name"        => "el_class",
            "group" => esc_html__("Extra Class", "big-event"),
            "description"       => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "big-event"),
        ),
    )
) );
endif;