<?php
/**
 * Big Event Testimonial Shortcode
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_testimonial extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'title'			=> '',
			'sub_title'		=> '',
			'testimonials'	=> '',
			'be_class'		=> ''
		), $atts ) );
		$testimonials 	= ( array ) vc_param_group_parse_atts( $testimonials );
		ob_start();
			big_event_testimonial( $title, $sub_title, $testimonials, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'		=> esc_html__( 'Testimonial', 'big-event' ),
	'base'		=> 'big_event_testimonial',
	'class'		=> '',
	'category'	=> esc_html__( 'Big Event', 'big-event' ),
	'params'	=> array(
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'sub_title',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Testimonials', 'big-event' ),
			'param_name'	=> 'testimonials',
			'group'			=> esc_html__( 'Testimonials', 'big-event' ),
			'params'		=> array(
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Thumbnail Image', 'big-event' ),
					'param_name'	=> 'timage',
                    'description'	=> esc_html__( 'Recommended image size 200*200', 'big-event' )
				),
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Background Image', 'big-event' ),
					'param_name'	=> 'bgimage',
				),
                array(
                    'type'			=> 'textfield',
                    'heading'		=> esc_html__( 'Name', 'big-event' ),
                    'param_name'	=> 'name',
                ),
                array(
                    'type'			=> 'textfield',
                    'heading'		=> esc_html__( 'Designation', 'big-event' ),
                    'param_name'	=> 'designation',
                ),
                array(
                    'type'			=> 'textarea',
                    'heading'		=> esc_html__( 'Quote', 'big-event' ),
                    'param_name'	=> 'quote',
                ),
                
			)
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class Name', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' )
		)
	)
) );
endif;

function big_event_testimonial( $title, $sub_title, $testimonials, $be_class ) {    
    $css_classes = array(
        'community-section',
        'padding-120'
    );
    if(!empty($be_class)):
        $css_classes[] = $be_class;
    endif;
	?>
    <!-- Gallery start here -->
    <section class="<?php echo implode( ' ', $css_classes ) ?>">
        <div class="container">
            <div class="row">
                <?php if( ! empty( $title ) || ! empty( $sub_title ) ) : ?>

                <div class="section-header text-center">

                    <?php
                    if( ! empty( $title ) ) :

                        echo '<h3>' . esc_html( $title ) . '</h3>';

                    endif; ?>

                    <?php
                    if( ! empty( $sub_title ) ) :

                        echo '<p><em>' . esc_html( $sub_title ) . '</em></p>';

                    endif; ?>

                </div>
                <?php endif; ?>
                <div class="section-wrapper">
                    <div class="members">
                        <ul class="members-list">
                            <?php 
                            $i = 0;
                            foreach( $testimonials as $testimonial ) : $i++;
                            $timage_src = wp_get_attachment_image_src($testimonial['timage'], 'thumbnail');
                            $timage_alt = get_post_meta($testimonial['timage'], '_wp_attachment_image_alt', true);
                            ?>
                            <li><a href="#ttab<?php echo $i; ?>" title="" data-toggle="tab">
                                <?php if (!empty($testimonial['timage'])): ?>                                                       
                                <div class="event-date">                                  
                                    <div class="event-date-inner">
                                      <span>
                                        <img src="<?php echo esc_url( $timage_src[0] ); ?>" alt="<?php echo esc_attr($timage_alt) ?>">
                                      </span>
                                    </div>
                                </div>
                                <?php endif; ?>                            
                                <div class="member-intro">
                                    <?php 
                                    if (!empty($testimonial['name'])):
                                        echo '<span class="member-name">'.esc_html($testimonial['name']).'</span>';
                                    endif;

                                    if (!empty($testimonial['designation'])):
                                        echo '<span class="member-pos">'.esc_html($testimonial['designation']).'</span>';
                                    endif; 
                                    ?>
                                </div>
                            </a></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <div class="tab-content">
                        <?php 
                        $j = 0;
                        foreach( $testimonials as $testimonial ) : $j++;
                        $timage_src = wp_get_attachment_image_src($testimonial['timage'], 'full');                    
                        $timage_alt = get_post_meta($testimonial['timage'], '_wp_attachment_image_alt', true);
                        $bgimage_url = wp_get_attachment_url( $testimonial['bgimage'] );

                        $tab_classes = array(
                            'community-member-quote',
                            'tab-pane',
                            'fade'
                        );
                        if($j == 1):
                            $tab_classes[] = 'active';
                            $tab_classes[] = 'in';
                        endif;

                        $tab_attribute = array();
                        $tab_attribute[] = 'id="ttab'.$j.'"';
                        $tab_attribute[] = 'class="' . implode( ' ', $tab_classes ) . '"';
                        if(!empty($testimonial['bgimage'])):
                            $tab_attribute[] = 'style="background-image: url('.esc_attr($bgimage_url).')"';
                        endif;
                        ?>
                        <div <?php echo implode( ' ', $tab_attribute ) ?>>
                            <?php if (!empty($testimonial['timage'])): ?>  
                            <div class="member-thumb">
                                <div class="member-thumb-inner">
                                    <img src="<?php echo esc_url( $timage_src[0] ); ?>" alt="<?php echo esc_attr($timage_alt) ?>">
                                </div>
                                <div class="quote-icon">
                                  <i class="fa fa-quote-right" aria-hidden="true"></i>
                                </div>
                            </div>
                            <?php endif; ?>   
                          <div class="member-content">
                            <div class="member-title">
                                <?php 
                                if (!empty($testimonial['name'])):
                                    echo '<h4>'.esc_html($testimonial['name']).'</h4>';
                                endif;

                                if (!empty($testimonial['designation'])):
                                    echo '<span>'.esc_html($testimonial['designation']).'</span>';
                                endif; 
                                ?>
                            </div>
                            <?php 
                            if (!empty($testimonial['quote'])):
                                echo '<p>'.esc_html($testimonial['quote']).'</p>';
                            endif; 
                            ?>
                          </div>
                        </div>                    
                        <?php endforeach; ?>
                    </div>
                </div>
            </div><!-- row -->
        </div><!-- container -->
    </section><!-- gallery -->
    <!-- Gallery end here -->
	<?php
}