<?php
/**
 * Event Hub Shortcodes
 *
 * Visual Composer of Faq Style
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_sponsors_7 extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'title'             => '',
			'sub_title'         => '',
			'sponsor_btn_text'	=> '',
			'sponsor_btn_url'	=> '',			
			'sponsor_btn_color'	=> '',			
			'sponsor_btn_bgc'	=> '',			
			'platinum_title'	=> '',
			'platinum_info'		=> '',
			'gold_title'		=> '',
			'gold_info'         => '',			
			'silver_title'		=> '',
			'silver_info'		=> '',
			'be_class'          => ''
		), $atts ) );
		$platinum_info 	= ( array ) vc_param_group_parse_atts( $platinum_info );
		$gold_info	= ( array ) vc_param_group_parse_atts( $gold_info );
		$silver_info	= ( array ) vc_param_group_parse_atts( $silver_info );
		ob_start();
			big_event_sponsors_7( $title, $sub_title, $sponsor_btn_text, $sponsor_btn_url, $sponsor_btn_color, $sponsor_btn_bgc,  $platinum_title, $platinum_info, $gold_title, $gold_info, $silver_title, $silver_info, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Sponsors 07', 'big-event' ),
	'base'			=> 'big_event_sponsors_7',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(		
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'Sponsors', 'big-event' ),
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'sub_title',
			'group'			=> esc_html__( 'Sponsors', 'big-event' ),
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Become Sponsor Button Text', 'big-event' ),
			'param_name'	=> 'sponsor_btn_text',
			'group'			=> esc_html__( 'Sponsors', 'big-event' ),
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Become Sponsor Button URL', 'big-event' ),
			'param_name'	=> 'sponsor_btn_url',
			'group'			=> esc_html__( 'Sponsors', 'big-event' ),
		),
                array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Become Sponsor Button Color', 'big-event' ),
			'param_name'	=> 'sponsor_btn_color',
			'group'			=> esc_html__( 'Sponsors', 'big-event' )
		),
		array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Become Sponsor Button Background', 'big-event' ),
			'param_name'	=> 'sponsor_btn_bgc',
			'group'			=> esc_html__( 'Sponsors', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Package Title', 'big-event' ),
			'param_name'	=> 'platinum_title',
			'group'			=> esc_html__( 'Platinum', 'big-event' ),
		),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Platinum', 'big-event' ),
			'param_name'	=> 'platinum_info',
			'group'			=> esc_html__( 'Platinum', 'big-event' ),
			'params'		=> array(
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Sponsor Image', 'big-event' ),
					'param_name'	=> 'image'
				),
				array(
					'type'			=> 'textfield',
					'heading'		=> esc_html__( 'Sponsor URL', 'big-event' ),
					'param_name'	=> 'url'
				)
			)
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Package Title', 'big-event' ),
			'param_name'	=> 'gold_title',
			'group'			=> esc_html__( 'Gold', 'big-event' ),
		),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Gold', 'big-event' ),
			'param_name'	=> 'gold_info',
			'group'			=> esc_html__( 'Gold', 'big-event' ),
			'params'		=> array(
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Sponsor Image', 'big-event' ),
					'param_name'	=> 'image'
				),
				array(
					'type'			=> 'textfield',
					'heading'		=> esc_html__( 'Sponsor URL', 'big-event' ),
					'param_name'	=> 'url'
				)
			)
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Package Title', 'big-event' ),
			'param_name'	=> 'silver_title',
			'group'			=> esc_html__( 'Silver', 'big-event' ),
		),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Silver', 'big-event' ),
			'param_name'	=> 'silver_info',
			'group'			=> esc_html__( 'Silver', 'big-event' ),
			'params'		=> array(
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Sponsor Image', 'big-event' ),
					'param_name'	=> 'image'
				),
				array(
					'type'			=> 'textfield',
					'heading'		=> esc_html__( 'Sponsor URL', 'big-event' ),
					'param_name'	=> 'url'
				)
			)
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' )
		)
	)
) );
endif;

function big_event_sponsors_7( $title, $sub_title, $sponsor_btn_text, $sponsor_btn_url, $sponsor_btn_color, $sponsor_btn_bgc,  $platinum_title, $platinum_info, $gold_title, $gold_info, $silver_title, $silver_info, $be_class ) {
    ?>
    <section class="em-sponsors-section padding-120 text-center">
        <div class="container">
            <div class="row">
                <?php if( ! empty( $title ) || ! empty( $sub_title ) ) : ?>
                    <div class="section-header text-center">
                      <?php
                      if( ! empty( $title ) ) :
                        echo '<h3>' . esc_html( $title ) . '</h3>';
                      endif;
                      
                      if( ! empty( $sub_title ) ) :
                        echo '<p><em>' . esc_html( $sub_title ) . '</em></p>';
                      endif; 
                      ?>
                    </div>
                <?php endif; ?>
                <div class="section-wrapper1">
                    <div class="em-sponsor-type-item presentedby">
                        <?php
                        if( ! empty( $platinum_title ) ) :
                            echo '<div class="em-sponsor-head"><h4>' . esc_html( $platinum_title ) . '</h4></div>';
                        endif; 
                        ?>
                        <div class="em-sponsor-wrapper">
                            <?php 
                            foreach( $platinum_info as $platinum_info_detail ) :
                            $sponsor_image 	= wp_get_attachment_image_src( $platinum_info_detail['image'], 'full' );
                            $sponsor_url 	= isset( $platinum_info_detail['url'] ) ? $platinum_info_detail['url'] : '';
                            ?>
                            <div class="emsponsor-item">
                                <div class="emsponsor-item-inner">
                                    <?php
                                    if( ! empty( $sponsor_url ) ) :
                                        echo '<a href="' . esc_url( $sponsor_url ) . '"><img src="' . esc_url( $sponsor_image[0] ) . '" alt="sponsor image"></a>';
                                    else :
                                        echo '<img src="' . esc_url( $sponsor_image[0] ) . '" alt="sponsor image">';

                                    endif; 
                                    ?>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>

                    <div class="em-sponsor-type-item poweredby">
                        <?php
                        if( ! empty( $gold_title ) ) :
                            echo '<div class="em-sponsor-head"><h4>' . esc_html( $gold_title ) . '</h4></div>';
                        endif; 
                        ?>
                        <div class="em-sponsor-wrapper">
                            <?php 
                            foreach( $gold_info as $gold_info_detail ) :
                            $sponsor_image 	= wp_get_attachment_image_src( $gold_info_detail['image'], 'full' );
                            $sponsor_url 	= isset( $gold_info_detail['url'] ) ? $gold_info_detail['url'] : '';
                            ?>  
                            <div class="emsponsor-item">
                                <div class="emsponsor-item-inner">
                                    <?php
                                    if( ! empty( $sponsor_url ) ) :
                                        echo '<a href="' . esc_url( $sponsor_url ) . '"><img src="' . esc_url( $sponsor_image[0] ) . '" alt="sponsor image"></a>';
                                    else :
                                        echo '<img src="' . esc_url( $sponsor_image[0] ) . '" alt="sponsor image">';
                                    endif; 
                                    ?>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>

                    <div class="em-sponsor-type-item partnerby">
                        <?php
                        if( ! empty( $silver_title ) ) :
                            echo '<div class="em-sponsor-head"><h4>' . esc_html( $silver_title ) . '</h4></div>';
                        endif; 
                        ?>
                        <div class="em-sponsor-wrapper">
                            <?php 
                            foreach( $silver_info as $silver_info_detail ) :
                            $sponsor_image = wp_get_attachment_image_src( $silver_info_detail['image'], 'full' ); 
                            $sponsor_url 	= isset( $silver_info_detail['url'] ) ? $silver_info_detail['url'] : ''; 
                            ?>
                            <div class="emsponsor-item">
                                <div class="emsponsor-item-inner">
                                    <?php
                                    if( ! empty( $sponsor_url ) ) :
                                        echo '<a href="' . esc_url( $sponsor_url ) . '"><img src="' . esc_url( $sponsor_image[0] ) . '" alt="sponsor image"></a>';
                                    else :
                                        echo '<img src="' . esc_url( $sponsor_image[0] ) . '" alt="sponsor image">';

                                    endif; 
                                    ?> 
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
                
                <?php
                if( ! empty( $sponsor_btn_text ) && ! empty( $sponsor_btn_url ) ) :
                    echo '<div class="col-md-12 text-center">';
                    echo '<a href="'. esc_url( $sponsor_btn_url ) .'" class="sponsor-button default-button" style="background-color: ' . esc_attr( $sponsor_btn_bgc ) . '; color: ' . esc_attr( $sponsor_btn_color ) . '">' . esc_html( $sponsor_btn_text ) . '</a>';
                    echo '</div>';
                endif; 
                ?>                                
            </div>
        </div>
    </section>    
<?php }