<?php
/**
 * Event Hub Shortcodes
 *
 * Visual Composer of Faq Style
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_sponsors_6 extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'bg_image'          => '',
			'bg_color'          => '#001A29',
			'title'             => '',
			'sub_title'         => '',
			'sponsor_btn_text'	=> '',
			'sponsor_btn_url'	=> '',			
			'sponsor_btn_color'	=> '',			
			'sponsor_btn_bgc'	=> '',			
			'platinum_title'	=> '',
			'platinum_color'	=> '#FF0033',
			'platinum_info'		=> '',
			'gold_title'		=> '',
            'gold_color'        => '#FFCC33',
			'gold_info'         => '',			
			'silver_title'		=> '',
			'silver_color'		=> '#00CCCC',
			'silver_info'		=> '',
			'be_class'          => ''
		), $atts ) );
		$platinum_info 	= ( array ) vc_param_group_parse_atts( $platinum_info );
		$gold_info	= ( array ) vc_param_group_parse_atts( $gold_info );
		$silver_info	= ( array ) vc_param_group_parse_atts( $silver_info );
		ob_start();
			big_event_sponsors_6( $bg_image, $bg_color, $title, $sub_title, $sponsor_btn_text, $sponsor_btn_url, $sponsor_btn_color, $sponsor_btn_bgc,  $platinum_title, $platinum_color, $platinum_info, $gold_title, $gold_color, $gold_info, $silver_title, $silver_color, $silver_info, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Sponsors 06', 'big-event' ),
	'base'			=> 'big_event_sponsors_6',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Background Image', 'big-event' ),
			'param_name'	=> 'bg_image',
			'group'			=> esc_html__( 'Sponsors', 'big-event' )
		),
        array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Section Background Color', 'big-event' ),
			'param_name'	=> 'bg_color',
			'std'           => '#001A29',
			'group'			=> esc_html__( 'Sponsors', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'Sponsors', 'big-event' ),
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'sub_title',
			'group'			=> esc_html__( 'Sponsors', 'big-event' ),
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Become Sponsor Button Text', 'big-event' ),
			'param_name'	=> 'sponsor_btn_text',
			'group'			=> esc_html__( 'Sponsors', 'big-event' ),
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Become Sponsor Button URL', 'big-event' ),
			'param_name'	=> 'sponsor_btn_url',
			'group'			=> esc_html__( 'Sponsors', 'big-event' ),
		),
                array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Become Sponsor Button Color', 'big-event' ),
			'param_name'	=> 'sponsor_btn_color',
			'group'			=> esc_html__( 'Sponsors', 'big-event' )
		),
		array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Become Sponsor Button Background', 'big-event' ),
			'param_name'	=> 'sponsor_btn_bgc',
			'group'			=> esc_html__( 'Sponsors', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Package Title', 'big-event' ),
			'param_name'	=> 'platinum_title',
			'group'			=> esc_html__( 'Platinum', 'big-event' ),
		),
        array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Title Background Color', 'big-event' ),
			'param_name'	=> 'platinum_color',
			'std'           => '#FF0033',
			'group'			=> esc_html__( 'Platinum', 'big-event' )
		),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Platinum', 'big-event' ),
			'param_name'	=> 'platinum_info',
			'group'			=> esc_html__( 'Platinum', 'big-event' ),
			'params'		=> array(
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Sponsor Image', 'big-event' ),
					'param_name'	=> 'image'
				),
				array(
					'type'			=> 'textfield',
					'heading'		=> esc_html__( 'Sponsor URL', 'big-event' ),
					'param_name'	=> 'url'
				)
			)
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Package Title', 'big-event' ),
			'param_name'	=> 'gold_title',
			'group'			=> esc_html__( 'Gold', 'big-event' ),
		),
        array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Title Background Color', 'big-event' ),
			'param_name'	=> 'gold_color',
			'std'           => '#FFCC33',
			'group'			=> esc_html__( 'Gold', 'big-event' )
		),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Gold', 'big-event' ),
			'param_name'	=> 'gold_info',
			'group'			=> esc_html__( 'Gold', 'big-event' ),
			'params'		=> array(
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Sponsor Image', 'big-event' ),
					'param_name'	=> 'image'
				),
				array(
					'type'			=> 'textfield',
					'heading'		=> esc_html__( 'Sponsor URL', 'big-event' ),
					'param_name'	=> 'url'
				)
			)
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Package Title', 'big-event' ),
			'param_name'	=> 'silver_title',
			'group'			=> esc_html__( 'Silver', 'big-event' ),
		),
        array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Title Background Color', 'big-event' ),
			'param_name'	=> 'silver_color',
			'std'           => '#00CCCC',
			'group'			=> esc_html__( 'Silver', 'big-event' )
		),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Silver', 'big-event' ),
			'param_name'	=> 'silver_info',
			'group'			=> esc_html__( 'Silver', 'big-event' ),
			'params'		=> array(
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Sponsor Image', 'big-event' ),
					'param_name'	=> 'image'
				),
				array(
					'type'			=> 'textfield',
					'heading'		=> esc_html__( 'Sponsor URL', 'big-event' ),
					'param_name'	=> 'url'
				)
			)
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' )
		)
	)
) );
endif;

function big_event_sponsors_6( $bg_image, $bg_color, $title, $sub_title, $sponsor_btn_text, $sponsor_btn_url, $sponsor_btn_color, $sponsor_btn_bgc,  $platinum_title, $platinum_color, $platinum_info, $gold_title, $gold_color, $gold_info, $silver_title, $silver_color, $silver_info, $be_class ) {
    $sbg_image = wp_get_attachment_image_src( $bg_image, 'full' );
    ?>
    <!-- Schedules start here -->
    <section id="sponsor " class="sponsor sponsor-six sponsor-uhv<?php echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>" style="<?php echo (!empty($sbg_image)) ? 'background-image:url('.esc_url( $sbg_image[0] ).')':'background-color:'.$bg_color.'' ?>">
        <div class="overlay padding-120">
            <div class="container">
                <?php if( ! empty( $title ) || ! empty( $sub_title ) ) : ?>
                    <div class="section-header text-center">

                      <?php
                      if( ! empty( $title ) ) :

                        echo '<h3>' . esc_html( $title ) . '</h3>';

                      endif; ?>

                      <?php
                      if( ! empty( $sub_title ) ) :

                        echo '<p><em>' . esc_html( $sub_title ) . '</em></p>';

                      endif; ?>

                    </div>

                <?php endif; ?>

                <div class="section-wrapper">
                    <?php if( ! empty( $platinum_info ) ) : ?>
                    <!-- platinum sponsor -->
                    <div class="sponsor-type-item platinum-sponsor">
                        <?php
                        if( ! empty( $platinum_title ) ) :
                            echo '<div class="sponsor-type"><h6 style="background-color:'.$platinum_color.'">' . esc_html( $platinum_title ) . '</h6></div>';
                        endif; 
                        ?>
                        <div class="sponsor-list">
                            <?php 
                            foreach( $platinum_info as $platinum_info_detail ) :
                            $sponsor_image 	= wp_get_attachment_image_src( $platinum_info_detail['image'], 'full' );
                            $sponsor_url 	= isset( $platinum_info_detail['url'] ) ? $platinum_info_detail['url'] : '';
                            ?>                            
                            <div class="sponsor-item">
                                <div class="sponsor-item-inner">
                                    <?php
                                    if( ! empty( $sponsor_url ) ) :
                                        echo '<a href="' . esc_url( $sponsor_url ) . '"><img src="' . esc_url( $sponsor_image[0] ) . '" alt="sponsor image" class="img-responsive"></a>';
                                    else :
                                        echo '<img src="' . esc_url( $sponsor_image[0] ) . '" alt="sponsor image" class="img-responsive">';

                                    endif; 
                                    ?>
                                </div>
                            </div> 
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if( ! empty( $gold_info ) ) : ?>
                    <!-- gold sponsor -->
                    <div class="sponsor-type-item gold-sponsor">
                        <?php
                        if( ! empty( $gold_title ) ) :
                            echo '<div class="sponsor-type"><h6 style="background-color:'.$gold_color.'">' . esc_html( $gold_title ) . '</h6></div>';
                        endif; 
                        ?>                        
                        <div class="sponsor-list">
                            <?php 
                            foreach( $gold_info as $gold_info_detail ) :
                            $sponsor_image 	= wp_get_attachment_image_src( $gold_info_detail['image'], 'full' );
                            $sponsor_url 	= isset( $gold_info_detail['url'] ) ? $gold_info_detail['url'] : '';
                            ?>                            
                            <div class="sponsor-item">
                                <div class="sponsor-item-inner">
                                    <?php
                                    if( ! empty( $sponsor_url ) ) :
                                        echo '<a href="' . esc_url( $sponsor_url ) . '"><img src="' . esc_url( $sponsor_image[0] ) . '" alt="sponsor image" class="img-responsive"></a>';
                                    else :
                                        echo '<img src="' . esc_url( $sponsor_image[0] ) . '" alt="sponsor image" class="img-responsive">';
                                    endif; ?>                                    
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if( ! empty( $silver_info ) ) : ?>
                    <!-- silver sponsor -->
                    <div class="sponsor-type-item silver-sponsor">
                        <?php
                        if( ! empty( $silver_title ) ) :
                            echo '<div class="sponsor-type"><h6 style="background-color:'.$silver_color.'">' . esc_html( $silver_title ) . '</h6></div>';
                        endif; 
                        ?>
                        <div class="sponsor-list">
                            <?php 
                            foreach( $silver_info as $silver_info_detail ) :
                            $sponsor_image = wp_get_attachment_image_src( $silver_info_detail['image'], 'full' ); 
                            $sponsor_url 	= isset( $silver_info_detail['url'] ) ? $silver_info_detail['url'] : ''; 
                            ?>                            
                            <div class="sponsor-item">
                                <div class="sponsor-item-inner">
                                    <?php
                                    if( ! empty( $sponsor_url ) ) :
                                        echo '<a href="' . esc_url( $sponsor_url ) . '"><img src="' . esc_url( $sponsor_image[0] ) . '" alt="sponsor image" class="img-responsive"></a>';
                                    else :
                                        echo '<img src="' . esc_url( $sponsor_image[0] ) . '" alt="sponsor image" class="img-responsive">';

                                    endif; 
                                    ?>                                    
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="col-md-12 text-center">
                        <?php
                        if( ! empty( $sponsor_btn_text ) && ! empty( $sponsor_btn_url ) ) :

                            echo '<a href="'. esc_url( $sponsor_btn_url ) .'" class="sponsor-button default-button" style="background-color: ' . esc_attr( $sponsor_btn_bgc ) . '; color: ' . esc_attr( $sponsor_btn_color ) . '">' . esc_html( $sponsor_btn_text ) . '</a>';

                        endif; ?>                       
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php }