<?php
/**
 * Big Event Sponsors Shortcode
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
function big_event_sponsors_5( $title, $subtitle, $sponsors, $be_class ) {    
    ?>
    <section class="become-sponsor padding-120">
        <div class="container">
            <div class="row">
                <?php if( ! empty( $title ) || ! empty( $subtitle ) ) : ?>
                    <div class="section-header text-center">
                      <?php
                      if( ! empty( $title ) ) :
                        echo '<h3>' . esc_html( $title ) . '</h3>';
                      endif;
                      
                      if( ! empty( $subtitle ) ) :
                        echo '<p><em>' . esc_html( $subtitle ) . '</em></p>';
                      endif; ?>
                    </div>
                <?php endif; ?>  
                
                <?php if (!empty($sponsors)): ?>
                <div class="become-sponsor-list">
                    <?php 
                    foreach($sponsors as $sponsor): 
                        $sponsorsImage = wp_get_attachment_image_src( $sponsor['image'], 'full' );
                    ?>
                    <div class="col-md-4 col-sm-6">
                        <div class="become-sponsor-item">
                            <div class="sponsor-thumb">
                                <img src="<?php echo esc_url($sponsorsImage[0]) ?>" alt="<?php esc_attr($sponsor['title'])?>">
                            </div>
                            <div class="sponsor-content">
                                <?php
                                if( ! empty( $sponsor['heading'] ) ) :
                                  echo '<h4>' . esc_html( $sponsor['heading'] ) . '</h4>';
                                endif;
                                
                                if( ! empty( $sponsor['description'] ) ) :
                                    echo '<p>'.$sponsor['description'].'</p>';
                                endif;
                                
                                if( ! empty( $sponsor['btn_text'] ) ) :
                                    echo '<a href="'.esc_url($sponsor['btn_url']).'" class="sponsor-btn">'.$sponsor['btn_text'].'</a>';
                                endif;
                                ?>                                
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
<?php }