<?php
/**
 * Event Hub Shortcodes
 *
 * Visual Composer of Faq Style
 *
 * @package big-event
 * @author CodexCoder
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_sponsors_3 extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'bg_image'          => '',
			'bg_color'          => '#001A29',
			'title'             => '',
			'sub_title'         => '',
			'sponsor_btn_text'	=> '',
			'sponsor_btn_url'	=> '',			
			'sponsor_btn_color'	=> '',			
			'sponsor_btn_bgc'	=> '',			
			'platinum_title'	=> '',
			'platinum_info'		=> '',
			'gold_title'		=> '',
			'gold_info'		=> '',
			'silver_title'		=> '',
			'silver_info'		=> '',
			'be_class'		=> ''
		), $atts ) );
		$platinum_info 	= ( array ) vc_param_group_parse_atts( $platinum_info );
		$gold_info	= ( array ) vc_param_group_parse_atts( $gold_info );
		$silver_info	= ( array ) vc_param_group_parse_atts( $silver_info );
		ob_start();
			big_event_sponsors_3( $bg_image, $bg_color, $title, $sub_title, $sponsor_btn_text, $sponsor_btn_url, $sponsor_btn_color, $sponsor_btn_bgc,  $platinum_title, $platinum_info, $gold_title, $gold_info, $silver_title, $silver_info, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Sponsors 03', 'big-event' ),
	'base'			=> 'big_event_sponsors_3',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Background Image', 'big-event' ),
			'param_name'	=> 'bg_image',
			'group'			=> esc_html__( 'Sponsors', 'big-event' )
		),
        array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Section Background Color', 'big-event' ),
			'param_name'	=> 'bg_color',
			'std'           => '#001A29',
			'group'			=> esc_html__( 'Sponsors', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'Sponsors', 'big-event' ),
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'sub_title',
			'group'			=> esc_html__( 'Sponsors', 'big-event' ),
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Become Sponsor Button Text', 'big-event' ),
			'param_name'	=> 'sponsor_btn_text',
			'group'			=> esc_html__( 'Sponsors', 'big-event' ),
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Become Sponsor Button URL', 'big-event' ),
			'param_name'	=> 'sponsor_btn_url',
			'group'			=> esc_html__( 'Sponsors', 'big-event' ),
		),
                array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Become Sponsor Button Color', 'big-event' ),
			'param_name'	=> 'sponsor_btn_color',
			'group'			=> esc_html__( 'Sponsors', 'big-event' )
		),
		array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Become Sponsor Button Background', 'big-event' ),
			'param_name'	=> 'sponsor_btn_bgc',
			'group'			=> esc_html__( 'Sponsors', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Package Title', 'big-event' ),
			'param_name'	=> 'platinum_title',
			'group'			=> esc_html__( 'Platinum', 'big-event' ),
		),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Platinum', 'big-event' ),
			'param_name'	=> 'platinum_info',
			'group'			=> esc_html__( 'Platinum', 'big-event' ),
			'params'		=> array(
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Sponsor Image', 'big-event' ),
					'param_name'	=> 'image'
				),
				array(
					'type'			=> 'textfield',
					'heading'		=> esc_html__( 'Sponsor URL', 'big-event' ),
					'param_name'	=> 'url'
				)
			)
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Package Title', 'big-event' ),
			'param_name'	=> 'gold_title',
			'group'			=> esc_html__( 'Gold', 'big-event' ),
		),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Gold', 'big-event' ),
			'param_name'	=> 'gold_info',
			'group'			=> esc_html__( 'Gold', 'big-event' ),
			'params'		=> array(
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Sponsor Image', 'big-event' ),
					'param_name'	=> 'image'
				),
				array(
					'type'			=> 'textfield',
					'heading'		=> esc_html__( 'Sponsor URL', 'big-event' ),
					'param_name'	=> 'url'
				)
			)
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Package Title', 'big-event' ),
			'param_name'	=> 'silver_title',
			'group'			=> esc_html__( 'Silver', 'big-event' ),
		),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Silver', 'big-event' ),
			'param_name'	=> 'silver_info',
			'group'			=> esc_html__( 'Silver', 'big-event' ),
			'params'		=> array(
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Sponsor Image', 'big-event' ),
					'param_name'	=> 'image'
				),
				array(
					'type'			=> 'textfield',
					'heading'		=> esc_html__( 'Sponsor URL', 'big-event' ),
					'param_name'	=> 'url'
				)
			)
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' )
		)
	)
) );
endif;