<?php
/**
 * Big Event Sponsors Shortcode
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
function big_event_sponsors_2( $bg_color, $color_variation, $title, $sub_title, $sponsor_btn_text, $sponsor_btn_url, $sponsor_btn_color, $sponsor_btn_bgc, $platinum_title, $platinum_info, $gold_title, $gold_info, $silver_title, $silver_info, $be_class ) {
	?>
<!-- Sponsor start here -->
<section class="sponsor sponsor-five padding-120<?php echo ( $color_variation == 'black' ) ? ' ' . 'sponsor-two' : ''; echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>" style="background-color: <?php echo esc_attr( $bg_color ); ?>">
  <div class="container">

  <?php
  if( ! empty( $title ) || ! empty( $sub_title ) ) : ?>

	  <div class="section-header text-center">

	    <?php
	    if( ! empty( $title ) ) :

	      echo '<h3>' . esc_html( $title ) . '</h3>';

	    endif; ?>

	    <?php
	    if( ! empty( $sub_title ) ) :

	      echo '<p><em>' . esc_html( $sub_title ) . '</em></p>';

	    endif; ?>

	  </div>

  <?php endif; ?>

	<?php
	if( ! empty( $platinum_info ) ) : ?>

    <div class="sponsor-item">

  	<?php
  	if( ! empty( $platinum_title ) ) :

  		echo '<h5>' . esc_html( $platinum_title ) . '</h5>';

  	endif; ?>

      <div class="swiper-container sponsor-slider-one">
        <div class="swiper-wrapper">

      	<?php
      	foreach( $platinum_info as $platinum_info_detail ) :
      		
      	$sponsor_image = wp_get_attachment_image_src( $platinum_info_detail['image'], 'full' );
      	$sponsor_url 	= isset( $platinum_info_detail['url'] ) ? $platinum_info_detail['url'] : ''; ?>

            <div class="swiper-slide">

            	<?php
            	if( ! empty( $sponsor_url ) ) :

            		echo '<a href="' . esc_url( $sponsor_url ) . '"><img src="' . esc_url( $sponsor_image[0] ) . '" alt="sponsor image" class="img-responsive"></a>';

              	else :

              		echo '<img src="' . esc_url( $sponsor_image[0] ) . '" alt="sponsor image" class="img-responsive">';

              	endif; ?>

            </div>

         <?php endforeach; ?>

        </div>
      </div>
    </div><!-- sponsor-item -->

    <?php endif; ?>

		<?php
		if( ! empty( $gold_info ) ) : ?>

	      <div class="sponsor-item">

	      	<?php
	      	if( ! empty( $gold_title ) ) :

	      		echo '<h5>' . esc_html( $gold_title ) . '</h5>';

	      	endif; ?>
	        
	        <div class="swiper-container sponsor-slider-two">
	          <div class="swiper-wrapper">

	          	<?php foreach( $gold_info as $gold_info_detail ) :

	          	$sponsor_image 	= wp_get_attachment_image_src( $gold_info_detail['image'], 'full' );
	          	$sponsor_url 	= isset( $gold_info_detail['url'] ) ? $gold_info_detail['url'] : '';
	          	?>

	            <div class="swiper-slide">

	            	<?php
	            	if( ! empty( $sponsor_url ) ) :

	            		echo '<a href="' . esc_url( $sponsor_url ) . '"><img src="' . esc_url( $sponsor_image[0] ) . '" alt="sponsor image" class="img-responsive"></a>';

	              	else :

	              		echo '<img src="' . esc_url( $sponsor_image[0] ) . '" alt="sponsor image" class="img-responsive">';

	              	endif; ?>

	            </div>

				<?php endforeach; ?>
	
	          </div>
	        </div>
	      </div><!-- sponsor-item -->

  		<?php endif; ?>

		<?php
		if( ! empty( $silver_info ) ) : ?>
	      <div class="sponsor-item">

	      	<?php
	      	if( ! empty( $silver_title ) ) :

	      		echo '<h5>' . esc_html( $silver_title ) . '</h5>';

	      	endif; ?>

	        <div class="swiper-container sponsor-slider-three">
	          <div class="swiper-wrapper">

	          	<?php foreach( $silver_info as $silver_info_detail ) :

	          	$sponsor_image = wp_get_attachment_image_src( $silver_info_detail['image'], 'full' ); 
	          	$sponsor_url 	= isset( $silver_info_detail['url'] ) ? $silver_info_detail['url'] : ''; ?>

	            <div class="swiper-slide">
	              	            	<?php
	            	if( ! empty( $sponsor_url ) ) :

	            		echo '<a href="' . esc_url( $sponsor_url ) . '"><img src="' . esc_url( $sponsor_image[0] ) . '" alt="sponsor image" class="img-responsive"></a>';

	              	else :

	              		echo '<img src="' . esc_url( $sponsor_image[0] ) . '" alt="sponsor image" class="img-responsive">';

	              	endif; ?>

	            </div>

				<?php endforeach; ?>

	          </div>
	        </div>
	      </div><!-- sponsor-item -->

	    <?php endif; ?>

	    <?php
	    if( ! empty( $sponsor_btn_text ) && ! empty( $sponsor_btn_url ) ) :

	    	echo '<a href="'. esc_url( $sponsor_btn_url ) .'" class="sponsor-button default-button" style="background-color: ' . esc_attr( $sponsor_btn_bgc ) . '; color: ' . esc_attr( $sponsor_btn_color ) . '">' . esc_html( $sponsor_btn_text ) . '</a>';

	    endif; ?>
  </div><!-- container -->
</section><!-- sponsor -->
<!-- Sponsor end here -->
<?php }