<?php
/**
 * Big Event Shortcodes
 *
 * Visual Composer of Speakers Four Column
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.3.0
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_speaker_9 extends WPBakeryShortcode {
	public function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'bg_color'		=> '',
			'title'			=> '',
			'sub_title'		=> '',
			'isfeatured'	=> 'yes',
			'fcategories'	=> '',
			'fpost_count'	=> '3',
			'forder'		=> '',			
			'isgeneral'		=> 'yes',			
			'categories'	=> '',
			'post_count'	=> '8',			
			'order'			=> '',
			'be_class'		=> ''
		), $atts ) );
		ob_start();
		big_event_speaker_9($bg_color,$title,$sub_title,$isfeatured,$fcategories,$fpost_count,$forder,$isgeneral,$categories,$post_count,$order,$be_class);
		return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Speaker 09', 'big-event' ),
	'base'			=> 'big_event_speaker_9',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
		array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Section Background Color', 'big-event' ),
			'param_name'	=> 'bg_color',
            "std"           => "#000",
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'sub_title',
		),
        array(
            "type"          => "dropdown",
            "heading"       => esc_html__( "Is Featured Speaker?", 'big-event' ),
            "param_name"    => "isfeatured",                
            "value"		=> array(
                esc_html__( "Select a option",'big-event')	=> "",
                esc_html__( "Yes",'big-event')	=> "yes",
                esc_html__( "No", 'big-event' )	=> "no",
            ),
            "std"    => "yes",
            'group'			=> esc_html__( 'Featured Speaker', 'big-event' )
        ),
        array(
            'param_name'    => 'fcategories',
            'type'          => 'dropdown',
            'value'         => big_event_get_terms_vc('speakers_category'),
            'heading'       => esc_html__('Category Filter:', 'big-event'),
			'group'			=> esc_html__( 'Featured Speaker', 'big-event' )
        ),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Number of posts', 'big-event' ),
			'param_name'	=> 'fpost_count',
			'group'			=> esc_html__( 'Featured Speaker', 'big-event' ),
            "std"           => "3",
		),
		array(
            "type"          => "dropdown",
            "heading"       => esc_html__( "Order", 'big-event' ),
            "param_name"    => "forder",                
            "value"		=> array(
                esc_html__( "Select order",'big-event')	=> "",
                esc_html__( "DESC",'big-event')	=> "DESC",
                esc_html__( "ASC", 'big-event' )	=> "ASC",
            ),
            "std"    => "DESC",
            'group'			=> esc_html__( 'Featured Speaker', 'big-event' )
        ),
        
        array(
            "type"          => "dropdown",
            "heading"       => esc_html__( "Is General Speaker?", 'big-event' ),
            "param_name"    => "isgeneral",                
            "value"		=> array(
                esc_html__( "Select a option",'big-event')	=> "",
                esc_html__( "Yes",'big-event')	=> "yes",
                esc_html__( "No", 'big-event' )	=> "no",
            ),
            "std"    => "yes",
            'group'			=> esc_html__( 'General Speaker', 'big-event' )
        ),
        array(
            'param_name'    => 'categories',
            'type'          => 'dropdown',
            'value'         => big_event_get_terms_vc('speakers_category'),
            'heading'       => esc_html__('Category Filter:', 'big-event'),
			'group'			=> esc_html__( 'General Speaker', 'big-event' )
        ),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Number of posts', 'big-event' ),
			'param_name'	=> 'post_count',
			'group'			=> esc_html__( 'General Speaker', 'big-event' ),
            "std"           => "6",
		),
		array(
            "type"          => "dropdown",
            "heading"       => esc_html__( "Order", 'big-event' ),
            "param_name"    => "order",                
            "value"		=> array(
                esc_html__( "Select order",'big-event')	=> "",
                esc_html__( "DESC",'big-event')	=> "DESC",
                esc_html__( "ASC", 'big-event' )	=> "ASC",
            ),
            "std"    => "DESC", 
            'group'			=> esc_html__( 'General Speaker', 'big-event' )
        ),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' )
		)
	)
) );
endif;

function big_event_speaker_9($bg_color,$title,$sub_title,$isfeatured,$fcategories,$fpost_count,$forder,$isgeneral,$categories,$post_count,$order,$be_class) {?>
    <!-- Speakers start here -->
    <section class="speakers speakers-three speakers-four padding-120 speakers-ten<?php echo ( $be_class ) ? ' ' . esc_attr($be_class) : ''; ?>" <?php echo $bg_color ? 'style="background-color: '.esc_attr( $bg_color ).'"':''?>>
        <div class="container">
            <?php if (!empty($title) || !empty($sub_title)) : ?>
            <div class="section-header text-center">
                <?php
                if (!empty($title)) :
                    echo '<h3>' . esc_html($title) . '</h3>';
                endif;

                if (!empty($sub_title)) :
                    echo '<p><em>' . esc_html($sub_title) . '</em></p>';
                endif;
                ?>            
            </div>
            <?php endif; ?>
            <div class="speaker-items">
                <?php //if ($isfeatured == 'yes') : ?>
                <div class="top-speaker">
                    <div class="row">
                        <?php
                        if ($fcategories == '') :
                            $fspeakers = new WP_Query(array(
                                'post_type' => 'speakers',
                                'posts_per_page' => $fpost_count,
                                'post_status' => 'publish',
                                'order'   => $forder,
                            ));
                        else :
                            $fspeakers = new WP_Query(array(
                                'post_type' => 'speakers',
                                'posts_per_page' => $fpost_count,
                                'post_status' => 'publish',
                                'order'   => $forder,
                                'tax_query' => array(
                                    array(
                                        'taxonomy' => 'speakers_category',
                                        'field' => 'term_id',
                                        'terms' => $fcategories,
                                    ),
                                ),
                            ));
                        endif;
                        if ($fspeakers->have_posts()) :

                            /* Start the Loop */
                            while ($fspeakers->have_posts()) : $fspeakers->the_post();
                                $be_fspeakers_designation = '';
                                if (function_exists('cs_get_option')) :

                                    $be_fspeakers_post_options = get_post_meta(get_the_ID(), '_be_speakers_post_options', true);
                                    $be_fspeakers_designation = isset($be_fspeakers_post_options['be_speakers_designation']) ? $be_fspeakers_post_options['be_speakers_designation'] : '';                                    

                                endif;
                        ?>
                        <div class="col-md-4">
                            <div class="speaker-item">
                                <div class="speaker-image">
                                    <?php
                                    if(has_post_thumbnail()):
                                        the_post_thumbnail( 'big-event-speaker-three-image', array( 'class' => 'img-responsive' ) );
                                    endif; 
                                    ?> 
                                </div>
                                <!-- speaker-image -->
                                <div class="speaker-content">
                                    <?php
                                    the_title( '<h4><a href="' . get_permalink() . '">', '</a></h4>' ); 

                                    if( ! empty( $be_fspeakers_designation ) ) :
                                        echo '<span>' . esc_html($be_fspeakers_designation) . '</span>';
                                    endif; 
                                    ?>
                                </div>
                                <!-- speaker-content -->
                            </div>
                        </div>  
                        <?php
                        endwhile;
                        wp_reset_postdata();
                        endif;     
                        ?>
                    </div>
                </div>
                <?php //endif; ?>
                <?php if ($isgeneral == 'yes') : ?>
                <div class="others-speaker">
                    <div class="row">
                        <?php
                        if ($categories == '') :
                            $speakers = new WP_Query(array(
                                'post_type' => 'speakers',
                                'posts_per_page' => $post_count,
                                'post_status' => 'publish',
                                'order'   => $order,
                            ));
                        else :
                            $speakers = new WP_Query(array(
                                'post_type' => 'speakers',
                                'posts_per_page' => $post_count,
                                'post_status' => 'publish',
                                'order'   => $order,
                                'tax_query' => array(
                                    array(
                                        'taxonomy' => 'speakers_category',
                                        'field' => 'term_id',
                                        'terms' => $categories,
                                    ),
                                ),
                            ));
                        endif;
                        if ($speakers->have_posts()) :

                            /* Start the Loop */
                            while ($speakers->have_posts()) : $speakers->the_post();

                                if (function_exists('cs_get_option')) :

                                    $be_speakers_post_options = get_post_meta(get_the_ID(), '_be_speakers_post_options', true);
                                    $be_speakers_designation = isset($be_speakers_post_options['be_speakers_designation']) ? $be_speakers_post_options['be_speakers_designation'] : '';
                                endif;
                        ?>
                        <div class="col-md-3 col-sm-4 col-xs-6">
                            <div class="speaker-item">
                                <div class="speaker-image">
                                    <?php
                                    if(has_post_thumbnail()):
                                        the_post_thumbnail( 'thumbnail', array( 'class' => 'img-responsive' ) );
                                    endif; 
                                    ?> 
                                </div>
                                <!-- speaker-image -->
                                <div class="speaker-content">
                                    <?php
                                    the_title( '<h4><a href="' . get_permalink() . '">', '</a></h4>' ); 

                                    if( ! empty( $be_speakers_designation ) ) :
                                      echo '<span>' . esc_html($be_speakers_designation) . '</span>';
                                    endif; 
                                    ?>
                                </div>
                                <!-- speaker-content -->
                            </div>
                            <!-- speaker-item -->
                        </div>
                        <?php
                        endwhile;
                        wp_reset_postdata();
                        endif;     
                        ?>
                    </div>
                    <!-- row -->
                </div>
                <?php endif; ?>
            </div>
            <!-- speaker-items -->
        </div>
        <!-- container -->
    </section>    
    <!-- Speakers end here -->
<?php }