<?php
/**
 * Event Hub Shortcodes
 *
 * Visual Composer of Speakers Four Column
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_speaker_5 extends WPBakeryShortcode {
	public function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'bg_color'		=> '',
			'title'			=> '',
			'sub_title'		=> '',
			'categories'	=> '',
			'post_count'	=> '6',
			'pagination'	=> '',
			'be_class'		=> ''
		), $atts ) );
		ob_start();
			big_event_speaker_5( $bg_color, $title, $sub_title, $categories, $post_count, $pagination, $pagination, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Speaker 05', 'big-event' ),
	'base'			=> 'big_event_speaker_5',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
		array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Section Background', 'big-event' ),
			'param_name'	=> 'bg_color',
			'group'			=> esc_html__( 'Speakers', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'Speakers', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'sub_title',
			'group'			=> esc_html__( 'Speakers', 'big-event' )
		),
        array(
            'param_name'    => 'categories',
            'type'          => 'dropdown',
            'value'         => big_event_get_terms_vc('speakers_category'),
            'heading'       => esc_html__('Category filter:', 'big-event'),
			'group'			=> esc_html__( 'Speakers', 'big-event' )
        ),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Number of posts', 'big-event' ),
			'param_name'	=> 'post_count',
			'std'           => '6',
			'group'			=> esc_html__( 'Speakers', 'big-event' )
		),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Show Pagination', 'big-event' ),
			'param_name'	=> 'pagination',
			'value'			=> array(
				esc_html__( 'Select Pagination', 'big-event' )	=> '',
				esc_html__( 'Yes', 'big-event' )			=> 'yes',
				esc_html__( 'No', 'big-event' )				=> 'no'
			),
			'group'			=> esc_html__( 'Speakers', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' )
		)
	)
) );
endif;