<?php
/**
 * Big Event Shortcodes
 *
 * Visual Composer of Speakers Four Column
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.3.1
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_speaker_10 extends WPBakeryShortcode {
	public function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'bg_color'		=> '',
			'title'			=> '',
			'sub_title'		=> '',
			'categories'	=> '',
			'post_count'	=> '6',
			'pagination'	=> '',
			'itemstyle'		=> '',
			'be_class'		=> ''
		), $atts ) );
		ob_start();
			big_event_speaker_10( $bg_color, $title, $sub_title, $categories, $post_count, $pagination, $itemstyle, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Speaker 10', 'big-event' ),
	'base'			=> 'big_event_speaker_10',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
		array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Section Background', 'big-event' ),
			'param_name'	=> 'bg_color',
			'std'           => '#1A242F',
			'group'			=> esc_html__( 'Speakers', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'Speakers', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'sub_title',
			'group'			=> esc_html__( 'Speakers', 'big-event' )
		),
        array(
            'param_name'    => 'categories',
            'type'          => 'dropdown',
            'value'         => big_event_get_terms_vc('speakers_category'),
            'heading'       => esc_html__('Category filter:', 'big-event'),
			'group'			=> esc_html__( 'Speakers', 'big-event' )
        ),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Number of posts', 'big-event' ),
			'param_name'	=> 'post_count',
			'std'           => '6',
			'group'			=> esc_html__( 'Speakers', 'big-event' )
		),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Show Pagination', 'big-event' ),
			'param_name'	=> 'pagination',
			'value'			=> array(
				esc_html__( 'Select Pagination', 'big-event' )	=> '',
				esc_html__( 'Yes', 'big-event' )			=> 'yes',
				esc_html__( 'No', 'big-event' )				=> 'no'
			),
			'group'			=> esc_html__( 'Speakers', 'big-event' )
		),
        array(
            "type"      => "checkbox",
            "heading"   => esc_html__( "Item Background", "big-event" ),
            "param_name"=> "itemstyle",
            'value'			=> array(
				esc_html__( 'Use Secondary color in item background', 'big-event' )			=> 'seccolor',
			),
            'group'		=> esc_html__( 'Style', 'big-event' ),
            "description" => esc_html__( "Enter description.", "big-event" )
        ),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Style', 'big-event' ),
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' )
		)
	)
) );
endif;

$be_speakers_designation  = '';
$be_speakers_social_info  = array();

function big_event_speaker_10( $bg_color, $title, $sub_title, $categories, $post_count, $pagination, $itemstyle, $be_class ) {
    $css_classes = array(
        'speakers',
        'speakers-eleven',
        'padding-120'
    );
    if(!empty($itemstyle)):
        $css_classes[] = $itemstyle;
    endif;
    if(!empty($be_class)):
        $css_classes[] = $be_class;
    endif;
    
    $section_attribute = array();
    $section_attribute[] = 'class="' . implode( ' ', $css_classes ) . '"';
    if(!empty($bg_color)):
        $section_attribute[] = 'style="background-color: '.esc_attr($bg_color).'"';
    endif;
    ?>
      <!-- Speakers start here -->
    <section <?php echo implode( ' ', $section_attribute ) ?>>
        <div class="container">
            <?php if (!empty($title) || !empty($sub_title)) : ?>
            <div class="section-header text-center">
                <?php
                if (!empty($title)) :
                    echo '<h3>' . esc_html($title) . '</h3>';
                endif;

                if (!empty($sub_title)) :
                    echo '<p><em>' . esc_html($sub_title) . '</em></p>';
                endif;
                ?>

            </div>
            <?php endif; ?>
            <div class="speaker-items">
                <div class="row">
                    <?php
                        if(is_front_page()):
                            $paged = (get_query_var('page')) ? get_query_var('page') : 1;
                        else:
                            $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                        endif;
                        if( $categories == NULL ) :
                          $speakers = new WP_Query( array(
                            'post_type'       => 'speakers',
                            'posts_per_page'  => $post_count,
                            'paged'           => $paged,
                            'post_status'     => 'publish'
                        ) );
                        else :
                          $speakers = new WP_Query( array(
                            'post_type'     => 'speakers',
                            'posts_per_page'  => $post_count,
                            'paged'           => $paged,
                            'post_status'     => 'publish',
                            'tax_query' => array(
                              array(
                                'taxonomy' => 'speakers_category',
                                'field'    => 'term_id',
                                'terms'    => $categories,
                              ),
                            ),
                          ) );
                        endif;
                        if( $speakers->have_posts() ) :

                        /* Start the Loop */
                        while( $speakers->have_posts() ) : $speakers->the_post();

                        if( function_exists( 'cs_get_option' ) ) :

                          $be_speakers_post_options = get_post_meta( get_the_ID(), '_be_speakers_post_options', true );
                          $be_speakers_designation  = isset( $be_speakers_post_options['be_speakers_designation'] ) ? $be_speakers_post_options['be_speakers_designation'] : '';
                          $be_speakers_social_info  = isset( $be_speakers_post_options['be_speakers_social_info'] ) ? $be_speakers_post_options['be_speakers_social_info'] : '';

                        endif; 
                    ?>                        
                    <div class="col-md-3 col-sm-6 col-xs-12">
                        <div class="speaker-item">
                            <div class="speaker-image">
                                <?php
                                  if( has_post_thumbnail() ) :
                                    the_post_thumbnail( 'big-event-speaker-three-image', array( 'class' => 'img-responsive' ) );
                                  endif; 
                                ?>
                            </div>
                            <!-- speaker-image -->
                            <div class="speaker-content">
                                <?php
                                the_title( '<h4><a href="' . get_permalink() . '">', '</a></h4>' ); 

                                if( ! empty( $be_speakers_designation ) ) :
                                  echo '<span>' . esc_html( $be_speakers_designation ) . '</span>';
                                endif; 
                                ?>
                            </div>
                            <!-- speaker-content -->
                        </div>
                        <!-- speaker-item -->
                    </div> 
                    <?php 
                    endwhile;

                    wp_reset_postdata();

                      if( $pagination == 'yes' ) : ?>

                        <div class="col-md-12">
                          <div class="pagination-area text-center">

                            <?php
                            $total = $speakers->max_num_pages;
                            $args = array(
                              'total'       => $total,
                              'current'     => $paged,
                              'prev_text'   => __('«'),
                              'next_text'   => __('»'),
                              'type'        => 'list'
                            );
                            echo paginate_links( $args );
                            ?>
                          </div><!-- /.pagination-area -->
                        </div><!-- .col-md-12 -->
                      <?php
                      endif;

                  endif; 
                  ?>
                </div>
                <!-- row -->
            </div>
            <!-- speaker-items -->
        </div>
        <!-- container -->
    </section>    
<?php }