<?php
/**
 * Big Event Speaker Shortcode
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

$be_speakers_designation  = '';
$be_speakers_social_info  = array();

function big_event_speaker_7( $bg_color, $title, $sub_title, $categories, $post_count, $pagination, $be_class ) {?>
      <!-- Speakers start here -->
    <section class="dark-layout">
      <div class="dark-overlay-right speakers speakers-nine dark-bg padding-120<?php echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>" <?php echo $bg_color ? 'style="background-color: '.esc_attr( $bg_color ).'"':''?>>
        <div class="container">
          <?php
          if( ! empty( $title ) || ! empty( $sub_title ) ) : ?>

          <div class="section-header text-center">

            <?php
            if( ! empty( $title ) ) :

              echo '<h3>' . esc_html( $title ) . '</h3>';

            endif; ?>

            <?php
            if( ! empty( $sub_title ) ) :

              echo '<p><em>' . esc_html( $sub_title ) . '</em></p>';

            endif; ?>
            
          </div>

          <?php endif; ?>
          <div class="speaker-items">
            <div class="row">
            <?php
                if(is_front_page()):
                    $paged = (get_query_var('page')) ? get_query_var('page') : 1;
                else:
                    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                endif;
                if( $categories == NULL ) :
                  $speakers = new WP_Query( array(
                    'post_type'       => 'speakers',
                    'posts_per_page'  => $post_count,
                    'paged'           => $paged,
                    'post_status'     => 'publish'
                ) );
                else :
                  $speakers = new WP_Query( array(
                    'post_type'     => 'speakers',
                    'posts_per_page'  => $post_count,
                    'paged'           => $paged,
                    'post_status'     => 'publish',
                    'tax_query' => array(
                      array(
                        'taxonomy' => 'speakers_category',
                        'field'    => 'term_id',
                        'terms'    => $categories,
                      ),
                    ),
                  ) );
                endif;
                if( $speakers->have_posts() ) :

                /* Start the Loop */
                while( $speakers->have_posts() ) : $speakers->the_post();

                if( function_exists( 'cs_get_option' ) ) :

                  $be_speakers_post_options = get_post_meta( get_the_ID(), '_be_speakers_post_options', true );
                  $be_speakers_designation  = isset( $be_speakers_post_options['be_speakers_designation'] ) ? $be_speakers_post_options['be_speakers_designation'] : '';
                  $be_speakers_social_info  = isset( $be_speakers_post_options['be_speakers_social_info'] ) ? $be_speakers_post_options['be_speakers_social_info'] : '';

                endif; 
            ?>              
              <div class="col-md-4 col-sm-6 col-xs-12">
                <div class="speaker-item">
                  <div class="speaker-image">
                    <?php
                      if( has_post_thumbnail() ) :
                        the_post_thumbnail( 'big-event-speaker-three-image', array( 'class' => 'img-responsive' ) );
                      endif; 
                    ?>                    
                  </div><!-- speaker-image -->
                  <div class="speaker-content">
                    <?php
                    the_title( '<h6 class="name"><a href="' . get_permalink() . '">', '</a></h6>' ); 
                    
                    if( ! empty( $be_speakers_designation ) ) :
                      echo '<p class="designation">' . esc_html( $be_speakers_designation ) . '</p>';
                    endif; 
                    ?>                    
                  </div>
                </div><!-- speaker-item -->
              </div>
              <?php 
              endwhile;

              wp_reset_postdata();

                if( $pagination == 'yes' ) : ?>

                  <div class="col-md-12">
                    <div class="pagination-area text-center">

                      <?php
                      $total = $speakers->max_num_pages;
                      $args = array(
                        'total'       => $total,
                        'current'     => $paged,
                        'prev_text'   => __('«'),
                        'next_text'   => __('»'),
                        'type'        => 'list'
                      );
                      echo paginate_links( $args );
                      ?>
                    </div><!-- /.pagination-area -->
                  </div><!-- .col-md-12 -->
                <?php
                endif;

            endif; ?>              
            </div><!-- row -->

          </div><!-- speaker-items -->
        </div><!-- container -->
      </div>
    </section>
      <!-- Speakers end here -->
<?php }