<?php
/**
 * Big Event Speaker Shortcode
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
$be_speakers_designation  = '';

function big_event_speaker_4( $bg_image, $title, $sub_title, $categories, $post_count, $pagination, $be_class ) {
    $bg_image = wp_get_attachment_image_src( $bg_image, 'full' );
    ?>
<!-- Speakers start here -->
<section class="speakers speakers-three speakers-four<?php echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>" style="background-image: url( <?php echo esc_url( $bg_image[0] ); ?> );">
  <div class="overlay">
    <div class="container">
      <?php
      if( ! empty( $title ) || ! empty( $sub_title ) ) : ?>
      <div class="section-header text-center">
        <?php
        if( ! empty( $title ) ) :

          echo '<h3>' . esc_html( $title ) . '</h3>';

        endif; ?>

        <?php
        if( ! empty( $sub_title ) ) :

          echo '<p><em>' . esc_html( $sub_title ) . '</em></p>';

        endif; ?>
      </div>
      <?php endif; ?>
      <div class="speaker-items">
        <div class="row">
        <?php
        if(is_front_page()):
            $paged = (get_query_var('page')) ? get_query_var('page') : 1;
        else:
            $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        endif;
        if( $categories == NULL ) :
          $speakers = new WP_Query( array(
            'post_type'       => 'speakers',
            'posts_per_page'  => $post_count,
            'paged'           => $paged,
            'post_status'     => 'publish'
        ) );
        else :
          $speakers = new WP_Query( array(
            'post_type'     => 'speakers',
            'posts_per_page'  => $post_count,
            'paged'           => $paged,
            'post_status'     => 'publish',
            'tax_query' => array(
              array(
                'taxonomy' => 'speakers_category',
                'field'    => 'term_id',
                'terms'    => $categories,
              ),
            ),
          ) );
        endif;
        if( $speakers->have_posts() ) :

          /* Start the Loop */
          while( $speakers->have_posts() ) : $speakers->the_post();

          if( function_exists( 'cs_get_option' ) ) :

            $be_speakers_post_options = get_post_meta( get_the_ID(), '_be_speakers_post_options', true );
            $be_speakers_designation  = isset( $be_speakers_post_options['be_speakers_designation'] ) ? $be_speakers_post_options['be_speakers_designation'] : '';

          endif; ?>

          <div class="col-md-3 col-sm-6 col-xs-12">
            <div class="speaker-item">
              <div class="speaker-image">
                <?php
                if( has_post_thumbnail() ) :

                  the_post_thumbnail( 'big-event-speaker-three-image', array( 'class' => 'img-responsive' ) );

                endif; ?>
              </div><!-- speaker-image -->
              <div class="speaker-content">

                <?php
                the_title( '<h4><a href="' . get_permalink() . '">', '</a></h4>' ); ?>

                <?php
                if( ! empty( $be_speakers_designation ) ) :

                  echo '<span>' . esc_html( $be_speakers_designation ) . '</span>';

                endif; ?>

              </div><!-- speaker-content -->
            </div><!-- speaker-item -->
          </div>

          <?php 
          endwhile;

          wp_reset_postdata();

          if( $pagination == 'yes' ) : ?>

            <div class="col-md-12">
              <div class="pagination-area text-center">

                <?php
                $total = $speakers->max_num_pages;
                $args = array(
                  'total'       => $total,
                  'current'     => $paged,
                  'prev_text'   => __('«'),
                  'next_text'   => __('»'),
                  'type'        => 'list'
                );
                echo paginate_links( $args );
                ?>
              </div><!-- /.pagination-area -->
            </div><!-- .col-md-12 -->
          <?php
          endif;

        endif; ?>
        </div><!-- row -->
      </div><!-- speaker-items -->
    </div><!-- container -->
  </div><!-- overlay --> 
</section>
<!-- Speakers end here -->
<?php }