<?php
/**
 * Big Event Recent Blog
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
function big_event_recent_blog( $bg_color, $title, $sub_title, $cat_id, $post_count, $order, $orderby, $be_class ) { ?>
    <!-- Blog start here -->
    <section class="home-blog home-blog-six padding-120<?php echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>" style="background-color: <?php echo esc_attr( $bg_color ); ?>">
      <div class="container">

      <?php
      if( ! empty( $title ) || ! empty( $sub_title ) ) : ?>

      <div class="section-header text-center">

        <?php
        if( ! empty( $title ) ) :

          echo '<h3>' . esc_html( $title ) . '</h3>';

        endif; ?>

        <?php
        if( ! empty( $sub_title ) ) :

          echo '<p><em>' . esc_html( $sub_title ) . '</em></p>';

        endif; ?>
        
      </div>

      <?php endif; ?>
      
      <div class="row">
		<?php
        if( $cat_id == true && !empty($cat_id[0])) {
            $query_args = array(
                'post_type' => 'post',
                'tax_query' => array(
                    array(
                        'taxonomy'  => 'category',
                        'field'     => 'term_id',
                        'terms'     => $cat_id,
                    ),
                ),
                'post_status'       => 'publish',
                'posts_per_page'	=> $post_count,
                'order'             => $order,
                'orderby'           => $orderby,
                'ignore_sticky_posts' => true,
            );
        } else {
            $query_args = array(
                'post_type'			=> 'post',
                'post_status'       => 'publish',
                'posts_per_page'	=> $post_count,
                'order'				=> $order,
                'orderby'			=> $orderby,
                'ignore_sticky_posts' => true,
            );
        }
        $recent_blog = new WP_Query( $query_args );
		if( $recent_blog->have_posts() ) :

			while( $recent_blog->have_posts() ) : $recent_blog->the_post(); ?>

	          <div class="col-md-4 col-sm-6 col-xs-12">
	            <div class="blog-item">

	            	<?php
	            	if( has_post_thumbnail() ) : ?>

		              <div class="image">
		                <a href="<?php the_permalink(); ?>">

		                	<?php the_post_thumbnail( 'big-event-blog-three-column', array( 'class' => 'img-responsive' ) ); ?>

		                </a>
		              </div><!-- image -->

	              	<?php endif; ?>

	              <div class="content">

	              	<?php
	              	the_title( '<h4><a href="' . get_permalink() . '">', '</a></h4>' ); ?>
	                
	                <?php
	                the_excerpt(); ?>
	              </div><!-- content -->

	              <ul class="post-meta">
	                <li><span class="icon flaticon-tool"></span><?php the_time( 'j.m.Y' ) ?></li>
				    <?php
					if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
						echo '<li class="comments-link"><span class="icon flaticon-chat"></span>';
						comments_popup_link(
							sprintf(
								wp_kses(
									/* translators: %s: post title */
									__( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'big-event' ),
									array(
										'span' => array(
											'class' => array(),
										),
									)
								),
								get_the_title()
							)
						);
						echo '</li>';
					} ?>
	              </ul><!-- post-meta -->
	            </div><!-- blog item -->
	          </div>

			<?php endwhile;

			wp_reset_postdata();

			endif; ?>
        </div><!-- row -->
      </div><!-- container -->
    </section><!-- home-blog -->
    <!-- Blog end here -->
<?php }