<?php
/**
 * Big Event Recent Blog
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_recent_blog_6 extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'title'				=> '',
			'sub_title'			=> '',
			'cat_id'			=> '',
			'post_count'		=> '',
			'order'				=> '',
			'orderby'			=> '',
			'be_class'			=> ''
		), $atts ) );
		ob_start();
			big_event_recent_blog_6( $title, $sub_title, $cat_id, $post_count, $order, $orderby, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Recent Blog 06', 'big-event' ),
	'base'			=> 'big_event_recent_blog_6',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'			=> array(
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'Recent Blog', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'sub_title',
			'group'			=> esc_html__( 'Recent Blog', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'How many posts want to display?', 'big-event' ),
			'param_name'	=> 'post_count',
			'group'			=> esc_html__( 'Recent Blog', 'big-event' )
		),
        array(
            "type"          => "dropdown",
            "heading"       => esc_html__("Select category:", 'top-news'),
            "param_name"    => "cat_id",
            "value"         => big_event_getcat(),
            "description"   => esc_html__("Select a category to display", 'big-event'),
            'group'			=> esc_html__( 'Recent Blog', 'big-event' )
    	),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Order', 'big-event' ),
			'param_name'	=> 'order',
			'value'			=> array(
				esc_html__( 'Select Order', 'big-event' )	=> '',
				esc_html__( 'DESC', 'big-event' )			=> 'DESC',
				esc_html__( 'ASC', 'big-event' )			=> 'ASC'
			),
			'group'			=> esc_html__( 'Recent Blog', 'big-event' )
		),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Order By', 'big-event' ),
			'param_name'	=> 'orderby',
			'description'	=> esc_html__( 'Select how to retrieve price table', 'big-event' ),
			'value'			=> array(
				esc_html__( 'Select order by', 'big-event' )	=> '',
				esc_html__( 'Date', 'big-event' )				=> 'date',
				esc_html__( 'Name', 'big-event' )				=> 'name',
				esc_html__( 'Modified', 'big-event' )			=> 'modified',
				esc_html__( 'Author', 'big-event' )				=> 'author',
				esc_html__( 'Random', 'big-event' )				=> 'rand',
				esc_html__( 'Comment Count', 'big-event' )		=> 'comment_count'
			),
			'group'			=> esc_html__( 'Recent Blog', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Classes', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' )
		)
	)
) );
endif;

function big_event_recent_blog_6( $title, $sub_title, $cat_id, $post_count, $order, $orderby, $be_class ) {
    $css_classes = array(
        'blog-section',
        'blog-gradient',
        'padding-120'
    );
    if(!empty($be_class)):
        $css_classes[] = $be_class;
    endif;
    
	?>
    <!-- Blog start here -->
    <section class="<?php echo implode( ' ', $css_classes ) ?>">
        <div class="container">
            <?php if( ! empty( $title ) || ! empty( $sub_title ) ) : ?>
            <div class="section-header text-center">
              <?php
              if( ! empty( $title ) ) :
                echo '<h3>' . esc_html( $title ) . '</h3>';
              endif;

              if( ! empty( $sub_title ) ) :
                echo '<p><em>' . esc_html( $sub_title ) . '</em></p>';
              endif; 
              ?>        
            </div>
            <?php endif; ?>

            <div class="row">
                <?php
                if( $cat_id == true && !empty($cat_id[0])) {
                    $query_args = array(
                        'post_type' => 'post',
                        'tax_query' => array(
                            array(
                                'taxonomy'  => 'category',
                                'field'     => 'term_id',
                                'terms'     => $cat_id,
                            ),
                        ),
                        'post_status'       => 'publish',
                        'posts_per_page'	=> $post_count,
                        'order'             => $order,
                        'orderby'           => $orderby,
                        'ignore_sticky_posts' => true,
                    );
                } else {
                    $query_args = array(
                        'post_type'			=> 'post',
                        'post_status'       => 'publish',
                        'posts_per_page'	=> $post_count,
                        'order'				=> $order,
                        'orderby'			=> $orderby,
                        'ignore_sticky_posts' => true,
                    );
                }
                $recent_blog = new WP_Query( $query_args );

                if( $recent_blog->have_posts() ) :

                    while( $recent_blog->have_posts() ) : $recent_blog->the_post(); 
                    $comments_count = wp_count_comments(get_the_ID());
                ?>

                <div class="col-md-6 col-sm-12">
                    <div class="blog-item">
                        <?php if(has_post_thumbnail()): ?>
                        <div class="blog-thumb">
                            <?php the_post_thumbnail('big-event-blog-two-column'); ?>
                            <div class="blog-content">
                                <?php
                                $posted_on = sprintf(
                                        /* translators: %s: post author. */
                                        esc_html_x('on %s', 'post date', 'big-event'), '<a href="' . esc_url(get_permalink()) . '">' . get_the_date() . '</a>'
                                );
                                $byline = sprintf(
                                        /* translators: %s: post author. */
                                        esc_html_x('by %s', 'post author', 'big-event'), '<a href="' . esc_url(get_author_posts_url(get_the_author_meta('ID'))) . '">' . esc_html(get_the_author()) . '</a>'
                                );
                                ?>
                                <p class="metapost"><?php echo $byline ?>  <span><?php echo $posted_on ?></span></p>
                                <?php the_title('<h3><a href="' . get_permalink() . '">', '</a></h3>'); ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>                                                
                <?php
                endwhile;
                wp_reset_postdata();
                endif; 
                ?>
            </div><!-- row -->
        </div><!-- container -->
    </section><!-- home-blog -->
    <!-- Blog end here -->
<?php }