<?php
/**
 * Big Event Recent Blog
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_recent_blog_5 extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'bg_image'			=> '',
			'bg_color'			=> '#001A29',
			'title'				=> '',
			'sub_title'			=> '',
			'cat_id'			=> '',
			'post_count'		=> '',
			'order'				=> '',
			'orderby'			=> '',
			'be_class'			=> ''
		), $atts ) );
		ob_start();
			big_event_recent_blog_5( $bg_image, $bg_color, $title, $sub_title, $cat_id, $post_count, $order, $orderby, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Recent Blog 05', 'big-event' ),
	'base'			=> 'big_event_recent_blog_5',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'			=> array(
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Section Background Image', 'big-event' ),
			'param_name'	=> 'bg_image',
            'group'			=> esc_html__( 'Recent Blog', 'big-event' )
		),
        array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Section Background Color', 'big-event' ),
			'param_name'	=> 'bg_color',
			'std'           => '#001A29',
            'group'			=> esc_html__( 'Recent Blog', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'Recent Blog', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'sub_title',
			'group'			=> esc_html__( 'Recent Blog', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'How many posts want to display?', 'big-event' ),
			'param_name'	=> 'post_count',
			'group'			=> esc_html__( 'Recent Blog', 'big-event' )
		),
        array(
            "type"          => "dropdown",
            "heading"       => esc_html__("Select category:", 'top-news'),
            "param_name"    => "cat_id",
            "value"         => big_event_getcat(),
            "description"   => esc_html__("Select a category to display", 'big-event'),
            'group'			=> esc_html__( 'Recent Blog', 'big-event' )
    	),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Order', 'big-event' ),
			'param_name'	=> 'order',
			'value'			=> array(
				esc_html__( 'Select Order', 'big-event' )	=> '',
				esc_html__( 'DESC', 'big-event' )			=> 'DESC',
				esc_html__( 'ASC', 'big-event' )			=> 'ASC'
			),
			'group'			=> esc_html__( 'Recent Blog', 'big-event' )
		),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Order By', 'big-event' ),
			'param_name'	=> 'orderby',
			'description'	=> esc_html__( 'Select how to retrieve price table', 'big-event' ),
			'value'			=> array(
				esc_html__( 'Select order by', 'big-event' )	=> '',
				esc_html__( 'Date', 'big-event' )				=> 'date',
				esc_html__( 'Name', 'big-event' )				=> 'name',
				esc_html__( 'Modified', 'big-event' )			=> 'modified',
				esc_html__( 'Author', 'big-event' )				=> 'author',
				esc_html__( 'Random', 'big-event' )				=> 'rand',
				esc_html__( 'Comment Count', 'big-event' )		=> 'comment_count'
			),
			'group'			=> esc_html__( 'Recent Blog', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Classes', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' )
		)
	)
) );
endif;

function big_event_recent_blog_5( $bg_image, $bg_color, $title, $sub_title, $cat_id, $post_count, $order, $orderby, $be_class ) {
    $bg_image = wp_get_attachment_image_src( $bg_image, 'full' );
	?>
    <!-- Blog start here -->
    <section class="home-blog home-blog-seven home-blog-eight padding-120<?php echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>" style="<?php echo (!empty($bg_image)) ? 'background-image:url('.esc_url( $bg_image[0] ).')':'background-color:'.$bg_color.'' ?>">
        <div class="container">
            <?php if( ! empty( $title ) || ! empty( $sub_title ) ) : ?>
            <div class="section-header text-center">
              <?php
              if( ! empty( $title ) ) :
                echo '<h3>' . esc_html( $title ) . '</h3>';
              endif;

              if( ! empty( $sub_title ) ) :
                echo '<p><em>' . esc_html( $sub_title ) . '</em></p>';
              endif; 
              ?>        
            </div>
            <?php endif; ?>

            <div class="row">
            <?php
            if( $cat_id == true && !empty($cat_id[0])) {
                $query_args = array(
                    'post_type' => 'post',
                    'tax_query' => array(
                        array(
                            'taxonomy'  => 'category',
                            'field'     => 'term_id',
                            'terms'     => $cat_id,
                        ),
                    ),
                    'post_status'       => 'publish',
                    'posts_per_page'	=> $post_count,
                    'order'             => $order,
                    'orderby'           => $orderby,
                    'ignore_sticky_posts' => true,
                );
            } else {
                $query_args = array(
                    'post_type'			=> 'post',
                    'post_status'       => 'publish',
                    'posts_per_page'	=> $post_count,
                    'order'				=> $order,
                    'orderby'			=> $orderby,
                    'ignore_sticky_posts' => true,
                );
            }
            $recent_blog = new WP_Query( $query_args );

            if( $recent_blog->have_posts() ) :

                while( $recent_blog->have_posts() ) : $recent_blog->the_post(); 
                $comments_count = wp_count_comments(get_the_ID());
            ?>

                  
                <div class="col-md-4 col-sm-6 col-xs-12">
                    <div class="blog-item">
                        <div class="blog-item-inner clearfix">
                            <div class="image gradient-overlay">
                                <?php 
                                if( has_post_thumbnail() ) :                                    
                                    $posted_on = sprintf(
                                        /* translators: %s: post author. */
                                        esc_html_x( 'on %s', 'post date', 'big-event' ),
                                        '<a href="' . esc_url( get_permalink() ) . '">' . get_the_date() . '</a>'
                                    );
                                    $byline = sprintf(
                                        /* translators: %s: post author. */
                                        esc_html_x( 'by %s', 'post author', 'big-event' ),
                                        '<a href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a>'
                                    );
                                    echo '<a href="'.get_permalink().'">'.the_post_thumbnail( 'big-event-340-400', array( 'class' => 'img-responsive' ) ).'</a>';
                                endif; 
                                ?>
                                
                                <div class="content">
                                    <?php the_title( '<h4><a href="' . get_permalink() . '">', '</a></h4>' ); ?>
                                    <p class="name"><?php echo $byline ?>  <span><?php echo $posted_on ?></span></p>
                                    <?php the_excerpt(); ?>                                    
                                </div>
                            </div>
                            <!-- image -->

                            <!-- content -->
                            <div class="item-content">
                              <div class="red-more-btn">
                                  <a href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read More', 'big-event' ); ?> <i class="fa fa-angle-double-right" aria-hidden="true"></i></a>
                              </div>
                              <ul class="post-meta">
                                  <li><i class="fa fa-comments" aria-hidden="true"></i> <?php echo esc_html($comments_count->total_comments) ?></li>
                              </ul>
                              <!-- post-meta -->
                            </div>
                          
                        </div>
                          
                    </div>
                    <!-- blog item -->
                </div>                
                <?php
                endwhile;
                wp_reset_postdata();
                endif; 
                ?>
            </div><!-- row -->
        </div><!-- container -->
    </section><!-- home-blog -->
    <!-- Blog end here -->
<?php }