<?php
/**
 * Big Event Recent Blog
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_recent_blog_4 extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'bg_image'		=> '',
			'title'			=> '',
			'sub_title'		=> '',
			'cat_id'		=> '',
			'post_count'	=> '',
			'order'			=> '',
			'orderby'		=> '',
			'be_class'		=> ''
		), $atts ) );
		ob_start();
			big_event_recent_blog_4( $bg_image, $title, $sub_title, $cat_id, $post_count, $order, $orderby, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Recent Blog 04', 'big-event' ),
	'base'			=> 'big_event_recent_blog_4',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event Dark', 'big-event' ),
	'params'			=> array(
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Background Image', 'big-event' ),
			'param_name'	=> 'bg_image',
			'group'			=> esc_html__( 'Recent Blog', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'Recent Blog', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'sub_title',
			'group'			=> esc_html__( 'Recent Blog', 'big-event' )
		),
        array(
            "type"          => "dropdown",
            "heading"       => esc_html__("Select category:", 'top-news'),
            "param_name"    => "cat_id",
            "value"         => big_event_getcat(),
            "description"   => esc_html__("Select a category to display", 'big-event'),
            'group'			=> esc_html__( 'Recent Blog', 'big-event' )
    	),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'How many posts want to display?', 'big-event' ),
			'param_name'	=> 'post_count',
			'group'			=> esc_html__( 'Recent Blog', 'big-event' )
		),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Order', 'big-event' ),
			'param_name'	=> 'order',
			'value'			=> array(
				esc_html__( 'Select Order', 'big-event' )	=> '',
				esc_html__( 'DESC', 'big-event' )			=> 'DESC',
				esc_html__( 'ASC', 'big-event' )			=> 'ASC'
			),
			'group'			=> esc_html__( 'Recent Blog', 'big-event' )
		),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Order By', 'big-event' ),
			'param_name'	=> 'orderby',
			'description'	=> esc_html__( 'Select how to retrieve price table', 'big-event' ),
			'value'			=> array(
				esc_html__( 'Select order by', 'big-event' )	=> '',
				esc_html__( 'Date', 'big-event' )				=> 'date',
				esc_html__( 'Name', 'big-event' )				=> 'name',
				esc_html__( 'Modified', 'big-event' )			=> 'modified',
				esc_html__( 'Author', 'big-event' )				=> 'author',
				esc_html__( 'Random', 'big-event' )				=> 'rand',
				esc_html__( 'Comment Count', 'big-event' )		=> 'comment_count'
			),
			'group'			=> esc_html__( 'Recent Blog', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Classes', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' )
		)
	)
) );
endif;