<?php
/**
 * Big Event Recent Blog
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
function big_event_recent_blog_2( $bg_color, $color_selection, $title, $sub_title, $cat_id, $post_count, $order, $orderby, $be_class ) {

	if( $color_selection == '2' ) :
		$color = ' home-blog-three';
	else :
		$color = '';
	endif;

	?>
    <!-- Blog start here -->
    <section class="home-blog home-blog-two home-blog-five padding-120<?php echo esc_attr( $color ); echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>" style="background-color: <?php echo esc_attr( $bg_color ); ?>">
      <div class="container">

      <?php
      if( ! empty( $title ) || ! empty( $sub_title ) ) : ?>

      <div class="section-header text-center">

        <?php
        if( ! empty( $title ) ) :

          echo '<h3>' . esc_html( $title ) . '</h3>';

        endif; ?>

        <?php
        if( ! empty( $sub_title ) ) :

          echo '<p><em>' . esc_html( $sub_title ) . '</em></p>';

        endif; ?>
        
      </div>

      <?php endif; ?>
      
      <div class="row">
		<?php
		if( $cat_id == true && !empty($cat_id[0])) {
            $query_args = array(
                'post_type' => 'post',
                'tax_query' => array(
                    array(
                        'taxonomy'  => 'category',
                        'field'     => 'term_id',
                        'terms'     => $cat_id,
                    ),
                ),
                'post_status'       => 'publish',
                'posts_per_page'	=> $post_count,
                'order'             => $order,
                'orderby'           => $orderby,
                'ignore_sticky_posts' => true,
            );
        } else {
            $query_args = array(
                'post_type'			=> 'post',
                'post_status'       => 'publish',
                'posts_per_page'	=> $post_count,
                'order'				=> $order,
                'orderby'			=> $orderby,
                'ignore_sticky_posts' => true,
            );
        }
        $recent_blog = new WP_Query( $query_args );

		if( $recent_blog->have_posts() ) :

			while( $recent_blog->have_posts() ) : $recent_blog->the_post(); ?>

		      <div class="col-md-6 col-sm-12 col-xs-12">
	            <div class="blog-item">

	            	<?php if( has_post_thumbnail() ) : ?>

		              <div class="image">
		                <a href="<?php the_permalink(); ?>">
		                	<?php the_post_thumbnail( 'big-event-blog-two-column' ); ?>
		                </a>
		              </div><!-- image -->

	              	<?php endif; ?>

                    <div class="blog-content">
                        <div>
                            <?php big_event_posted_on();

                            if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
                                echo '<li class="comments-link"><span class="icon flaticon-chat"></span>';
                                comments_popup_link(
                                    sprintf(
                                        wp_kses(
                                            /* translators: %s: post title */
                                            __( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'big-event' ),
                                            array(
                                                'span' => array(
                                                    'class' => array(),
                                                ),
                                            )
                                        ),
                                        get_the_title()
                                    )
                                );
                                echo '</li>';
                            }
                            ?>

                          </ul><!-- post-meta -->
                          <div class="content">

                            <?php
                            the_title( '<h4><a href="' . get_permalink() . '">', '</a></h4>' ); ?>

                            <?php
                            the_excerpt(); ?>

                            <a href="<?php the_permalink(); ?>" class="default-button"><?php esc_html_e( 'Read More', 'big-event' ); ?></a>
                          </div><!-- content -->
                        </div>
                    </div><!-- blog-content -->
	            </div><!-- blog item -->
	          </div>

			<?php endwhile;

			wp_reset_postdata();

			endif; ?>
        </div><!-- row -->
      </div><!-- container -->
    </section><!-- home-blog -->
    <!-- Blog end here -->
<?php }