<?php
/**
 * Big Event Pricing Table
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

function big_event_pricing_table( $bg_image, $overlay, $color_variation, $title, $sub_title, $categories, $post_count, $order, $orderby, $be_class ) {
	$bg_image = wp_get_attachment_image_src( $bg_image, 'full' );
	if( $color_variation == 1 ) :
		$pricing = ' pricing-six';
	else :
		$pricing = '';
	endif;
	?>
<!-- Pricing start here -->
<section class="pricing<?php echo esc_attr( $pricing ); echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; echo ( empty( $bg_image ) ) ? ' pricing-seven padding-120' : ''; ?>" style="background-image: url( <?php echo esc_attr( $bg_image[0] ); ?> );">
	<?php
	if( ! empty( $bg_image ) ) : ?>

  	<div class="overlay<?php echo ( $overlay == 'red' ) ? ' home-six-overlay' : ''; ?>">

  	<?php endif; ?>

    <div class="container">

      <?php
      if( ! empty( $title ) || ! empty( $sub_title ) ) : ?>

      <div class="section-header text-center">

        <?php
        if( ! empty( $title ) ) :

          echo '<h3>' . esc_html( $title ) . '</h3>';

        endif; ?>

        <?php
        if( ! empty( $sub_title ) ) :

          echo '<p><em>' . esc_html( $sub_title ) . '</em></p>';

        endif; ?>
        
      </div>

      <?php endif; ?>
      
      <div class="pricing-items">
        <div class="row">
		<?php
		if( $categories == NULL ) :
			$pricing_table = new WP_Query( array(
				'post_type'			=> 'price-table',
				'posts_per_page'	=> $post_count,
				'order'				=> $order,
				'orderby'			=> $orderby
			) );
        else :
            $pricing_table = new WP_Query( array(
				'post_type'			=> 'price-table',
				'posts_per_page'	=> $post_count,
				'order'				=> $order,
				'orderby'			=> $orderby,
              	'tax_query' => array(
                array(
                  'taxonomy' => 'pricing_category',
                  'field'    => 'term_id',
                  'terms'    => $categories,
                ),
              ),
            ) );
        endif;


		if( $pricing_table->have_posts() ) :

			$i = 1;

			while( $pricing_table->have_posts() ) : $pricing_table->the_post();

			if( $i == 1 ) :
				$color = ' first';
			elseif( $i == 2 ) :
				$color = ' second';
			else :
				$color = ' third';
			endif;

			if( function_exists( 'cs_get_option' ) ) :

				$price_table_options 			= get_post_meta( get_the_ID(), '_be_pricing_table_options', true );
				$be_price_table_currency		= isset( $price_table_options['be_price_table_currency'] ) ? $price_table_options['be_price_table_currency'] : '';
				$be_price_table_rate			= isset( $price_table_options['be_price_table_rate'] ) ? $price_table_options['be_price_table_rate'] : '';
				$be_price_table_offers			= isset( $price_table_options['be_price_table_offers'] ) ? $price_table_options['be_price_table_offers'] : '';
				$be_price_table_button_text		= isset( $price_table_options['be_price_table_button_text'] ) ? $price_table_options['be_price_table_button_text'] : '';
				$be_price_table_button_url		= isset( $price_table_options['be_price_table_button_url'] ) ? $price_table_options['be_price_table_button_url'] : '';

			endif; ?>

	          <div class="col-md-4 col-sm-6 col-xs-12">
	            <div class="pricing-item<?php echo esc_attr( $color ) ?>">
	              <div class="pricing-header">
	              	<?php
	              	the_title( '<h3 class="name">', '</h3>' ); ?>


	              	<?php
	              	if( ! empty( $be_price_table_currency ) && ! empty( $be_price_table_rate ) ) :

	              		echo '<h2 class="amount"><sup>' . esc_html( $be_price_table_currency ) . '</sup>' . esc_html( $be_price_table_rate ) . '</h2>';

	              	endif; ?>
	                
	                
	              </div><!-- pricing-header -->

		            <?php
		            if( ! empty( $be_price_table_offers ) ) : ?>

		              <div class="pricing-options">

		              	<?php foreach( $be_price_table_offers as $be_price_table_offer ) : ?>

			                <p><span class="<?php echo ( $be_price_table_offer['offer_icon'] == 'fa fa-times' ) ? ' ' . 'off' : '' ?>"><i class="<?php echo esc_attr( $be_price_table_offer['offer_icon'] ); ?>" aria-hidden="true"></i></span><?php echo esc_html( $be_price_table_offer['offer_title'] ); ?></p>

		            	<?php endforeach; ?>

		              </div><!-- pricing-options -->

	          		<?php endif; ?>

					<?php
					if( ! empty( $be_price_table_button_text ) && ! empty( $be_price_table_button_url ) ) : ?>

						<div class="pricing-button">
							<a href="<?php echo esc_url( $be_price_table_button_url ); ?>">
								<?php echo esc_html( $be_price_table_button_text ); ?>
							</a>
						</div>

					<?php endif; ?>

	            </div>
	          </div>
			<?php $i++; endwhile;

			wp_reset_postdata();

			endif; ?>

        </div><!-- row -->
      </div><!-- pricing items -->
      
    </div><!-- container -->
	<?php
	if( ! empty( $bg_image ) ) : ?>
  	</div><!-- overlay -->
	<?php endif; ?>
</section><!-- pricing -->
<!-- Pricing end here -->
<?php }