<?php
/**
 * Event Hub Shortcodes
 *
 * Visual Composer of Pricing Table Style
 *
 * @package big-event
 * @author CodexCoder
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_pricing_table_7 extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'title'				=> '',
			'sub_title'			=> '',
			'categories'		=> '',
			'post_count'		=> 2,
			'order'				=> '',
			'orderby'			=> '',
			'be_class'			=> ''
		), $atts ) );
		ob_start();
			big_event_pricing_table_7( $title, $sub_title, $categories, $post_count, $order, $orderby, $be_class );
		return ob_get_clean();
	}
}


vc_map( array(
	'name'			=> esc_html__( 'Price Table 07', 'big-event' ),
	'base'			=> 'big_event_pricing_table_7',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'Price Table', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'sub_title',
			'group'			=> esc_html__( 'Price Table', 'big-event' )
		),
        array(
            'param_name'    => 'categories',
            'type'          => 'dropdown',
            'value'         => big_event_get_terms_vc('pricing_category'),
            'heading'       => esc_html__('Category filter:', 'big-event'),
			'group'			=> esc_html__( 'Price Table', 'big-event' )
        ),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Limit', 'big-event' ),
			'param_name'	=> 'post_count',
			'std'           => '2',
			'description'	=> esc_html__( 'How many tables you wanna display?', 'big-event' ),
			'group'			=> esc_html__( 'Price Table', 'big-event' )
		),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Order', 'big-event' ),
			'param_name'	=> 'order',
			'value'			=> array(
				esc_html__( 'Select Order', 'big-event' )	=> '',
				esc_html__( 'DESC', 'big-event' )			=> 'DESC',
				esc_html__( 'ASC', 'big-event' )			=> 'ASC'
			),
			'group'			=> esc_html__( 'Price Table', 'big-event' )
		),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Order By', 'big-event' ),
			'param_name'	=> 'orderby',
			'description'	=> esc_html__( 'Select how to retrieve price table', 'big-event' ),
			'value'			=> array(
				esc_html__( 'Select order by', 'big-event' )	=> '',
				esc_html__( 'Date', 'big-event' )				=> 'date',
				esc_html__( 'Name', 'big-event' )				=> 'name',
				esc_html__( 'Modified', 'big-event' )			=> 'modified',
				esc_html__( 'Author', 'big-event' )				=> 'author',
				esc_html__( 'Random', 'big-event' )				=> 'rand',
				esc_html__( 'Comment Count', 'big-event' )		=> 'comment_count'
			),
			'group'			=> esc_html__( 'Price Table', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Classes', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' )
		)
	)
) );
endif;

function big_event_pricing_table_7( $title, $sub_title, $categories, $post_count, $order, $orderby, $be_class ) {
    $css_classes = array(
        'ticket-section',
        'padding-120'
    );
    if(!empty($be_class)):
        $css_classes[] = $be_class;
    endif;
	?>
    <section class="<?php echo implode( ' ', $css_classes ) ?>">
        <div class="container">
            <div class="row">
                <?php if (!empty($title) || !empty($sub_title)): ?>
                    <div class="section-header text-center">
                        <?php
                        if (!empty($title)) :
                            echo '<h3>' . esc_html($title) . '</h3>';
                        endif;
                        if (!empty($sub_title)) :
                            echo '<p>' . esc_html($sub_title) . '</p>';
                        endif;
                        ?>
                    </div>
                <?php endif; ?>
                <div class="section-wrapper">
                    <div class="row">
                        <?php                                                 
                        if( !empty($categories) ) :
                            $pricing_table = new WP_Query( array(
                                'post_type'			=> 'price-table',
                                'posts_per_page'	=> $post_count,
                                'order'				=> $order,
                                'orderby'			=> $orderby,
                                'tax_query' => array(
                                array(
                                  'taxonomy' => 'pricing_category',
                                  'field'    => 'term_id',
                                  'terms'    => $categories,
                                ),
                              ),
                            ) );                            
                        else :
                            $pricing_table = new WP_Query( array(
                                'post_type'			=> 'price-table',
                                'posts_per_page'	=> $post_count,
                                'order'				=> $order,
                                'orderby'			=> $orderby
                            ) );
                        endif;

                        if( $pricing_table->have_posts() ) :

                            $i = 1;

                            while( $pricing_table->have_posts() ) : $pricing_table->the_post();

                            if( function_exists( 'cs_get_option' ) ) :

                                $price_table_options = get_post_meta( get_the_ID(), '_be_pricing_table_options', true );
                                $be_price_sortdesc = isset( $price_table_options['be_price_sortdesc'] ) ? $price_table_options['be_price_sortdesc'] : '';
                                $be_price_table_currency = isset( $price_table_options['be_price_table_currency'] ) ? $price_table_options['be_price_table_currency'] : '';
                                $be_price_table_rate = isset( $price_table_options['be_price_table_rate'] ) ? $price_table_options['be_price_table_rate'] : '';
                                $be_price_table_offers = isset( $price_table_options['be_price_table_offers'] ) ? $price_table_options['be_price_table_offers'] : '';
                                $be_price_table_button_text	= isset( $price_table_options['be_price_table_button_text'] ) ? $price_table_options['be_price_table_button_text'] : '';
                                $be_price_table_button_url = isset( $price_table_options['be_price_table_button_url'] ) ? $price_table_options['be_price_table_button_url'] : '';

                            endif; 
                            ?>
                        <div class="col-md-6 col-sm-6 col-ticket">
                            <div class="ticket-item">
                                <?php 
                                if (!empty($be_price_table_currency) || !empty($be_price_table_rate)):
                                    echo '<h2>';
                                    if (!empty($be_price_table_currency)):
                                        echo '<span>'.esc_html($be_price_table_currency).'</span>';
                                    endif;
                                    if (!empty($be_price_table_rate)):
                                        echo esc_html($be_price_table_rate);
                                    endif;
                                    echo '</h2>';
                                endif;
                                
                                the_title('<h3>', '</h3>');
                                
                                if (!empty($be_price_sortdesc)):
                                    echo '<p>'.esc_html($be_price_sortdesc).'</p>';
                                endif;
                                ?>
                                <div class="ticket-item-list-wrapper">
                                    <ul class="ticket-item-list ticket-item-list-left">
                                        <?php foreach( $be_price_table_offers as $offer ) : ?>
                                        <li>
                                            <i class="<?php echo esc_attr( $offer['offer_icon'] ); ?>" aria-hidden="true"></i>
                                            <?php                                            
                                            echo esc_html( $offer['offer_title'] ); 
                                            ?>
                                        </li>
                                        <?php endforeach; ?>                                        
                                    </ul>                                    
                                </div>
                                <?php if( ! empty( $be_price_table_button_text ) && ! empty( $be_price_table_button_url ) ) :
                                    echo '<a class="half-fest festival-button" href="'.esc_url( $be_price_table_button_url ).'">'.esc_html( $be_price_table_button_text ).'</a>';
                                endif; ?>
                            </div>
                        </div> 
                        <?php endwhile; wp_reset_postdata(); endif; ?>
                    </div>
                </div><!--section-wrapper end-->
            </div><!--row end-->
        </div><!--container end-->         
    </section>
<?php }